/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Process;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AttributionResponseData;
import com.adjust.sdk.CustomScheduledExecutor;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.EventResponseData;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRunActivityHandler;
import com.adjust.sdk.ISdkClickHandler;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SessionParameters;
import com.adjust.sdk.SessionResponseData;
import com.adjust.sdk.TimerCycle;
import com.adjust.sdk.TimerOnce;
import com.adjust.sdk.Util;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ActivityHandler
implements IActivityHandler {
    private static long FOREGROUND_TIMER_INTERVAL;
    private static long FOREGROUND_TIMER_START;
    private static long BACKGROUND_TIMER_INTERVAL;
    private static long SESSION_INTERVAL;
    private static long SUBSESSION_INTERVAL;
    private static final String TIME_TRAVEL = "Time travel!";
    private static final String ADJUST_PREFIX = "adjust_";
    private static final String ACTIVITY_STATE_NAME = "Activity state";
    private static final String ATTRIBUTION_NAME = "Attribution";
    private static final String FOREGROUND_TIMER_NAME = "Foreground timer";
    private static final String BACKGROUND_TIMER_NAME = "Background timer";
    private static final String DELAY_START_TIMER_NAME = "Delay Start timer";
    private static final String SESSION_CALLBACK_PARAMETERS_NAME = "Session Callback parameters";
    private static final String SESSION_PARTNER_PARAMETERS_NAME = "Session Partner parameters";
    private CustomScheduledExecutor scheduledExecutor;
    private IPackageHandler packageHandler;
    private ActivityState activityState;
    private ILogger logger;
    private TimerCycle foregroundTimer;
    private TimerOnce backgroundTimer;
    private TimerOnce delayStartTimer;
    private InternalState internalState;
    private DeviceInfo deviceInfo;
    private AdjustConfig adjustConfig;
    private AdjustAttribution attribution;
    private IAttributionHandler attributionHandler;
    private ISdkClickHandler sdkClickHandler;
    private SessionParameters sessionParameters;

    @Override
    public void teardown(boolean deleteState) {
        if (this.backgroundTimer != null) {
            this.backgroundTimer.teardown();
        }
        if (this.foregroundTimer != null) {
            this.foregroundTimer.teardown();
        }
        if (this.delayStartTimer != null) {
            this.delayStartTimer.teardown();
        }
        if (this.scheduledExecutor != null) {
            try {
                this.scheduledExecutor.shutdownNow();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.packageHandler != null) {
            this.packageHandler.teardown(deleteState);
        }
        if (this.attributionHandler != null) {
            this.attributionHandler.teardown();
        }
        if (this.sdkClickHandler != null) {
            this.sdkClickHandler.teardown();
        }
        if (this.sessionParameters != null) {
            if (this.sessionParameters.callbackParameters != null) {
                this.sessionParameters.callbackParameters.clear();
            }
            if (this.sessionParameters.partnerParameters != null) {
                this.sessionParameters.partnerParameters.clear();
            }
        }
        this.teardownActivityStateS(deleteState);
        this.teardownAttributionS(deleteState);
        this.teardownAllSessionParametersS(deleteState);
        this.packageHandler = null;
        this.logger = null;
        this.foregroundTimer = null;
        this.scheduledExecutor = null;
        this.backgroundTimer = null;
        this.delayStartTimer = null;
        this.internalState = null;
        this.deviceInfo = null;
        this.adjustConfig = null;
        this.attributionHandler = null;
        this.sdkClickHandler = null;
        this.sessionParameters = null;
    }

    private ActivityHandler(AdjustConfig adjustConfig) {
        this.init(adjustConfig);
        this.logger = AdjustFactory.getLogger();
        this.logger.lockLogLevel();
        this.scheduledExecutor = new CustomScheduledExecutor("ActivityHandler", false);
        this.internalState = new InternalState();
        this.internalState.enabled = true;
        this.internalState.offline = false;
        this.internalState.background = true;
        this.internalState.delayStart = false;
        this.internalState.updatePackages = false;
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.initI();
            }
        });
    }

    @Override
    public void init(AdjustConfig adjustConfig) {
        this.adjustConfig = adjustConfig;
    }

    public static ActivityHandler getInstance(AdjustConfig adjustConfig) {
        if (adjustConfig == null) {
            AdjustFactory.getLogger().error("AdjustConfig missing", new Object[0]);
            return null;
        }
        if (!adjustConfig.isValid()) {
            AdjustFactory.getLogger().error("AdjustConfig not initialized correctly", new Object[0]);
            return null;
        }
        if (adjustConfig.processName != null) {
            int currentPid = Process.myPid();
            ActivityManager manager = (ActivityManager)adjustConfig.context.getSystemService("activity");
            if (manager == null) {
                return null;
            }
            for (ActivityManager.RunningAppProcessInfo processInfo : manager.getRunningAppProcesses()) {
                if (processInfo.pid != currentPid) continue;
                if (processInfo.processName.equalsIgnoreCase(adjustConfig.processName)) break;
                AdjustFactory.getLogger().info("Skipping initialization in background process (%s)", processInfo.processName);
                return null;
            }
        }
        ActivityHandler activityHandler = new ActivityHandler(adjustConfig);
        return activityHandler;
    }

    @Override
    public void onResume() {
        this.internalState.background = false;
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.delayStartI();
                ActivityHandler.this.stopBackgroundTimerI();
                ActivityHandler.this.startForegroundTimerI();
                ActivityHandler.this.logger.verbose("Subsession start", new Object[0]);
                ActivityHandler.this.startI();
            }
        });
    }

    @Override
    public void onPause() {
        this.internalState.background = true;
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.stopForegroundTimerI();
                ActivityHandler.this.startBackgroundTimerI();
                ActivityHandler.this.logger.verbose("Subsession end", new Object[0]);
                ActivityHandler.this.endI();
            }
        });
    }

    @Override
    public void trackEvent(final AdjustEvent event) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (ActivityHandler.this.activityState == null) {
                    ActivityHandler.this.logger.warn("Event tracked before first activity resumed.\nIf it was triggered in the Application class, it might timestamp or even send an install long before the user opens the app.\nPlease check https://github.com/adjust/android_sdk#can-i-trigger-an-event-at-application-launch for more information.", new Object[0]);
                    ActivityHandler.this.startI();
                }
                ActivityHandler.this.trackEventI(event);
            }
        });
    }

    @Override
    public void finishedTrackingActivity(ResponseData responseData) {
        if (responseData instanceof SessionResponseData) {
            this.attributionHandler.checkSessionResponse((SessionResponseData)responseData);
            return;
        }
        if (responseData instanceof EventResponseData) {
            this.launchEventResponseTasks((EventResponseData)responseData);
            return;
        }
    }

    @Override
    public void setEnabled(final boolean enabled) {
        if (!this.hasChangedState(this.isEnabled(), enabled, "Adjust already enabled", "Adjust already disabled")) {
            return;
        }
        this.internalState.enabled = enabled;
        if (this.activityState == null) {
            this.updateStatus(!enabled, "Handlers will start as paused due to the SDK being disabled", "Handlers will still start as paused", "Handlers will start as active due to the SDK being enabled");
            return;
        }
        Runnable saveEnabled = new Runnable(){

            @Override
            public void run() {
                ((ActivityHandler)ActivityHandler.this).activityState.enabled = enabled;
            }
        };
        this.writeActivityStateS(saveEnabled);
        this.updateStatus(!enabled, "Pausing handlers due to SDK being disabled", "Handlers remain paused", "Resuming handlers due to SDK being enabled");
    }

    private void updateStatus(boolean pausingState, String pausingMessage, String remainsPausedMessage, String unPausingMessage) {
        if (pausingState) {
            this.logger.info(pausingMessage, new Object[0]);
        } else if (this.pausedI(false)) {
            if (this.pausedI(true)) {
                this.logger.info(remainsPausedMessage, new Object[0]);
            } else {
                this.logger.info(remainsPausedMessage + ", except the Sdk Click Handler", new Object[0]);
            }
        } else {
            this.logger.info(unPausingMessage, new Object[0]);
        }
        this.updateHandlersStatusAndSend();
    }

    private boolean hasChangedState(boolean previousState, boolean newState, String trueMessage, String falseMessage) {
        if (previousState != newState) {
            return true;
        }
        if (previousState) {
            this.logger.debug(trueMessage, new Object[0]);
        } else {
            this.logger.debug(falseMessage, new Object[0]);
        }
        return false;
    }

    @Override
    public void setOfflineMode(boolean offline) {
        if (!this.hasChangedState(this.internalState.isOffline(), offline, "Adjust already in offline mode", "Adjust already in online mode")) {
            return;
        }
        this.internalState.offline = offline;
        if (this.activityState == null) {
            this.updateStatus(offline, "Handlers will start paused due to SDK being offline", "Handlers will still start as paused", "Handlers will start as active due to SDK being online");
            return;
        }
        this.updateStatus(offline, "Pausing handlers to put SDK offline mode", "Handlers remain paused", "Resuming handlers to put SDK in online mode");
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabledI();
    }

    private boolean isEnabledI() {
        if (this.activityState != null) {
            return this.activityState.enabled;
        }
        return this.internalState.isEnabled();
    }

    @Override
    public void readOpenUrl(final Uri url, final long clickTime) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.readOpenUrlI(url, clickTime);
            }
        });
    }

    private void updateAdidI(String adid) {
        if (adid == null) {
            return;
        }
        if (adid.equals(this.activityState.adid)) {
            return;
        }
        this.activityState.adid = adid;
        this.writeActivityStateI();
    }

    @Override
    public boolean updateAttributionI(AdjustAttribution attribution) {
        if (attribution == null) {
            return false;
        }
        if (attribution.equals(this.attribution)) {
            return false;
        }
        this.attribution = attribution;
        this.writeAttributionI();
        return true;
    }

    @Override
    public void setAskingAttribution(final boolean askingAttribution) {
        Runnable saveAskingAttribution = new Runnable(){

            @Override
            public void run() {
                ((ActivityHandler)ActivityHandler.this).activityState.askingAttribution = askingAttribution;
            }
        };
        this.writeActivityStateS(saveAskingAttribution);
    }

    @Override
    public void sendReferrer(final String referrer, final long clickTime) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.sendReferrerI(referrer, clickTime);
            }
        });
    }

    @Override
    public void launchEventResponseTasks(final EventResponseData eventResponseData) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchEventResponseTasksI(eventResponseData);
            }
        });
    }

    @Override
    public void launchSessionResponseTasks(final SessionResponseData sessionResponseData) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchSessionResponseTasksI(sessionResponseData);
            }
        });
    }

    @Override
    public void launchAttributionResponseTasks(final AttributionResponseData attributionResponseData) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchAttributionResponseTasksI(attributionResponseData);
            }
        });
    }

    @Override
    public void sendFirstPackages() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.sendFirstPackagesI();
            }
        });
    }

    @Override
    public void addSessionCallbackParameter(final String key, final String value) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.addSessionCallbackParameterI(key, value);
            }
        });
    }

    @Override
    public void addSessionPartnerParameter(final String key, final String value) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.addSessionPartnerParameterI(key, value);
            }
        });
    }

    @Override
    public void removeSessionCallbackParameter(final String key) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.removeSessionCallbackParameterI(key);
            }
        });
    }

    @Override
    public void removeSessionPartnerParameter(final String key) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.removeSessionPartnerParameterI(key);
            }
        });
    }

    @Override
    public void resetSessionCallbackParameters() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.resetSessionCallbackParametersI();
            }
        });
    }

    @Override
    public void resetSessionPartnerParameters() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.resetSessionPartnerParametersI();
            }
        });
    }

    @Override
    public void setPushToken(final String token) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (ActivityHandler.this.activityState == null) {
                    ActivityHandler.this.startI();
                }
                ActivityHandler.this.setPushTokenI(token);
            }
        });
    }

    public String getAdid() {
        if (this.activityState == null) {
            return null;
        }
        return this.activityState.adid;
    }

    public AdjustAttribution getAttribution() {
        return this.attribution;
    }

    public ActivityPackage getAttributionPackageI() {
        long now = System.currentTimeMillis();
        PackageBuilder attributionBuilder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, now);
        return attributionBuilder.buildAttributionPackage();
    }

    public InternalState getInternalState() {
        return this.internalState;
    }

    private void updateHandlersStatusAndSend() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.updateHandlersStatusAndSendI();
            }
        });
    }

    private void initI() {
        String playAdId;
        SESSION_INTERVAL = AdjustFactory.getSessionInterval();
        SUBSESSION_INTERVAL = AdjustFactory.getSubsessionInterval();
        FOREGROUND_TIMER_INTERVAL = AdjustFactory.getTimerInterval();
        FOREGROUND_TIMER_START = AdjustFactory.getTimerStart();
        BACKGROUND_TIMER_INTERVAL = AdjustFactory.getTimerInterval();
        this.readAttributionI(this.adjustConfig.context);
        this.readActivityStateI(this.adjustConfig.context);
        this.sessionParameters = new SessionParameters();
        this.readSessionCallbackParametersI(this.adjustConfig.context);
        this.readSessionPartnerParametersI(this.adjustConfig.context);
        if (this.activityState != null) {
            this.internalState.enabled = this.activityState.enabled;
            this.internalState.updatePackages = this.activityState.updatePackages;
        }
        this.readConfigFile(this.adjustConfig.context);
        this.deviceInfo = new DeviceInfo(this.adjustConfig.context, this.adjustConfig.sdkPrefix);
        if (this.adjustConfig.eventBufferingEnabled) {
            this.logger.info("Event buffering is enabled", new Object[0]);
        }
        if ((playAdId = Util.getPlayAdId(this.adjustConfig.context)) == null) {
            this.logger.warn("Unable to get Google Play Services Advertising ID at start time", new Object[0]);
            if (this.deviceInfo.macSha1 == null && this.deviceInfo.macShortMd5 == null && this.deviceInfo.androidId == null) {
                this.logger.error("Unable to get any device id's. Please check if Proguard is correctly set with Adjust SDK", new Object[0]);
            }
        } else {
            this.logger.info("Google Play Services Advertising ID read correctly at start time", new Object[0]);
        }
        if (this.adjustConfig.defaultTracker != null) {
            this.logger.info("Default tracker: '%s'", this.adjustConfig.defaultTracker);
        }
        if (this.adjustConfig.pushToken != null) {
            this.logger.info("Push token: '%s'", this.adjustConfig.pushToken);
            if (this.activityState != null) {
                this.setPushToken(this.adjustConfig.pushToken);
            }
        }
        this.foregroundTimer = new TimerCycle(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.foregroundTimerFiredI();
            }
        }, FOREGROUND_TIMER_START, FOREGROUND_TIMER_INTERVAL, FOREGROUND_TIMER_NAME);
        if (this.adjustConfig.sendInBackground) {
            this.logger.info("Send in background configured", new Object[0]);
            this.backgroundTimer = new TimerOnce(this.scheduledExecutor, new Runnable(){

                @Override
                public void run() {
                    ActivityHandler.this.backgroundTimerFiredI();
                }
            }, BACKGROUND_TIMER_NAME);
        }
        if (this.activityState == null && this.adjustConfig.delayStart != null && this.adjustConfig.delayStart > 0.0) {
            this.logger.info("Delay start configured", new Object[0]);
            this.internalState.delayStart = true;
            this.delayStartTimer = new TimerOnce(this.scheduledExecutor, new Runnable(){

                @Override
                public void run() {
                    ActivityHandler.this.sendFirstPackagesI();
                }
            }, DELAY_START_TIMER_NAME);
        }
        Util.setUserAgent(this.adjustConfig.userAgent);
        this.packageHandler = AdjustFactory.getPackageHandler(this, this.adjustConfig.context, this.toSendI(false));
        ActivityPackage attributionPackage = this.getAttributionPackageI();
        this.attributionHandler = AdjustFactory.getAttributionHandler(this, attributionPackage, this.toSendI(false));
        this.sdkClickHandler = AdjustFactory.getSdkClickHandler(this.toSendI(true));
        if (this.isToUpdatePackagesI()) {
            this.updatePackagesI();
        }
        if (this.adjustConfig.referrer != null) {
            this.sendReferrerI(this.adjustConfig.referrer, this.adjustConfig.referrerClickTime);
        }
        this.sessionParametersActionsI(this.adjustConfig.sessionParametersActionsArray);
    }

    private void readConfigFile(Context context) {
        Properties properties;
        try {
            InputStream inputStream = context.getAssets().open("adjust_config.properties");
            properties = new Properties();
            properties.load(inputStream);
        }
        catch (Exception e) {
            this.logger.debug("%s file not found in this app", e.getMessage());
            return;
        }
        this.logger.verbose("adjust_config.properties file read and loaded", new Object[0]);
        String defaultTracker = properties.getProperty("defaultTracker");
        if (defaultTracker != null) {
            this.adjustConfig.defaultTracker = defaultTracker;
        }
    }

    private void sessionParametersActionsI(List<IRunActivityHandler> sessionParametersActionsArray) {
        if (sessionParametersActionsArray == null) {
            return;
        }
        for (IRunActivityHandler sessionParametersAction : sessionParametersActionsArray) {
            sessionParametersAction.run(this);
        }
    }

    private void startI() {
        if (this.activityState != null && !this.activityState.enabled) {
            return;
        }
        this.updateHandlersStatusAndSendI();
        this.processSessionI();
        this.checkAttributionStateI();
    }

    private void processSessionI() {
        long now = System.currentTimeMillis();
        if (this.activityState == null) {
            this.activityState = new ActivityState();
            this.activityState.sessionCount = 1;
            this.activityState.pushToken = this.adjustConfig.pushToken;
            this.transferSessionPackageI(now);
            this.activityState.resetSessionAttributes(now);
            this.activityState.enabled = this.internalState.isEnabled();
            this.activityState.updatePackages = this.internalState.isToUpdatePackages();
            this.writeActivityStateI();
            return;
        }
        long lastInterval = now - this.activityState.lastActivity;
        if (lastInterval < 0L) {
            this.logger.error(TIME_TRAVEL, new Object[0]);
            this.activityState.lastActivity = now;
            this.writeActivityStateI();
            return;
        }
        if (lastInterval > SESSION_INTERVAL) {
            ++this.activityState.sessionCount;
            this.activityState.lastInterval = lastInterval;
            this.transferSessionPackageI(now);
            this.activityState.resetSessionAttributes(now);
            this.writeActivityStateI();
            return;
        }
        if (lastInterval > SUBSESSION_INTERVAL) {
            ++this.activityState.subsessionCount;
            this.activityState.sessionLength += lastInterval;
            this.activityState.lastActivity = now;
            this.logger.verbose("Started subsession %d of session %d", this.activityState.subsessionCount, this.activityState.sessionCount);
            this.writeActivityStateI();
            return;
        }
        this.logger.verbose("Time span since last activity too short for a new subsession", new Object[0]);
    }

    private void checkAttributionStateI() {
        if (!this.checkActivityStateI(this.activityState)) {
            return;
        }
        if (this.activityState.subsessionCount <= 1) {
            return;
        }
        if (this.attribution != null && !this.activityState.askingAttribution) {
            return;
        }
        this.attributionHandler.getAttribution();
    }

    private void endI() {
        if (!this.toSendI()) {
            this.pauseSendingI();
        }
        if (this.updateActivityStateI(System.currentTimeMillis())) {
            this.writeActivityStateI();
        }
    }

    private void trackEventI(AdjustEvent event) {
        if (!this.checkActivityStateI(this.activityState)) {
            return;
        }
        if (!this.isEnabledI()) {
            return;
        }
        if (!this.checkEventI(event)) {
            return;
        }
        if (!this.checkOrderIdI(event.orderId)) {
            return;
        }
        long now = System.currentTimeMillis();
        ++this.activityState.eventCount;
        this.updateActivityStateI(now);
        PackageBuilder eventBuilder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, now);
        ActivityPackage eventPackage = eventBuilder.buildEventPackage(event, this.sessionParameters, this.internalState.isDelayStart());
        this.packageHandler.addPackage(eventPackage);
        if (this.adjustConfig.eventBufferingEnabled) {
            this.logger.info("Buffered event %s", eventPackage.getSuffix());
        } else {
            this.packageHandler.sendFirstPackage();
        }
        if (this.adjustConfig.sendInBackground && this.internalState.isBackground()) {
            this.startBackgroundTimerI();
        }
        this.writeActivityStateI();
    }

    private void launchEventResponseTasksI(final EventResponseData eventResponseData) {
        this.updateAdidI(eventResponseData.adid);
        Handler handler = new Handler(this.adjustConfig.context.getMainLooper());
        if (eventResponseData.success && this.adjustConfig.onEventTrackingSucceededListener != null) {
            this.logger.debug("Launching success event tracking listener", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingSucceededListener.onFinishedEventTrackingSucceeded(eventResponseData.getSuccessResponseData());
                }
            };
            handler.post(runnable);
            return;
        }
        if (!eventResponseData.success && this.adjustConfig.onEventTrackingFailedListener != null) {
            this.logger.debug("Launching failed event tracking listener", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingFailedListener.onFinishedEventTrackingFailed(eventResponseData.getFailureResponseData());
                }
            };
            handler.post(runnable);
            return;
        }
    }

    private void launchSessionResponseTasksI(SessionResponseData sessionResponseData) {
        this.updateAdidI(sessionResponseData.adid);
        Handler handler = new Handler(this.adjustConfig.context.getMainLooper());
        boolean attributionUpdated = this.updateAttributionI(sessionResponseData.attribution);
        if (attributionUpdated) {
            this.launchAttributionListenerI(handler);
        }
        this.launchSessionResponseListenerI(sessionResponseData, handler);
    }

    private void launchSessionResponseListenerI(final SessionResponseData sessionResponseData, Handler handler) {
        if (sessionResponseData.success && this.adjustConfig.onSessionTrackingSucceededListener != null) {
            this.logger.debug("Launching success session tracking listener", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingSucceededListener.onFinishedSessionTrackingSucceeded(sessionResponseData.getSuccessResponseData());
                }
            };
            handler.post(runnable);
            return;
        }
        if (!sessionResponseData.success && this.adjustConfig.onSessionTrackingFailedListener != null) {
            this.logger.debug("Launching failed session tracking listener", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingFailedListener.onFinishedSessionTrackingFailed(sessionResponseData.getFailureResponseData());
                }
            };
            handler.post(runnable);
            return;
        }
    }

    private void launchAttributionResponseTasksI(AttributionResponseData attributionResponseData) {
        this.updateAdidI(attributionResponseData.adid);
        Handler handler = new Handler(this.adjustConfig.context.getMainLooper());
        boolean attributionUpdated = this.updateAttributionI(attributionResponseData.attribution);
        if (attributionUpdated) {
            this.launchAttributionListenerI(handler);
        }
        this.prepareDeeplinkI(attributionResponseData.deeplink, handler);
    }

    private void launchAttributionListenerI(Handler handler) {
        if (this.adjustConfig.onAttributionChangedListener == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ((ActivityHandler)ActivityHandler.this).adjustConfig.onAttributionChangedListener.onAttributionChanged(ActivityHandler.this.attribution);
            }
        };
        handler.post(runnable);
    }

    private void prepareDeeplinkI(final Uri deeplink, Handler handler) {
        if (deeplink == null) {
            return;
        }
        this.logger.info("Deferred deeplink received (%s)", deeplink);
        final Intent deeplinkIntent = this.createDeeplinkIntentI(deeplink);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean toLaunchDeeplink = true;
                if (((ActivityHandler)ActivityHandler.this).adjustConfig.onDeeplinkResponseListener != null) {
                    toLaunchDeeplink = ((ActivityHandler)ActivityHandler.this).adjustConfig.onDeeplinkResponseListener.launchReceivedDeeplink(deeplink);
                }
                if (toLaunchDeeplink) {
                    ActivityHandler.this.launchDeeplinkMain(deeplinkIntent, deeplink);
                }
            }
        };
        handler.post(runnable);
    }

    private Intent createDeeplinkIntentI(Uri deeplink) {
        Intent mapIntent = this.adjustConfig.deepLinkComponent == null ? new Intent("android.intent.action.VIEW", deeplink) : new Intent("android.intent.action.VIEW", deeplink, this.adjustConfig.context, this.adjustConfig.deepLinkComponent);
        mapIntent.setFlags(0x10000000);
        mapIntent.setPackage(this.adjustConfig.context.getPackageName());
        return mapIntent;
    }

    private void launchDeeplinkMain(Intent deeplinkIntent, Uri deeplink) {
        boolean isIntentSafe;
        PackageManager packageManager = this.adjustConfig.context.getPackageManager();
        List activities = packageManager.queryIntentActivities(deeplinkIntent, 0);
        boolean bl = isIntentSafe = activities.size() > 0;
        if (!isIntentSafe) {
            this.logger.error("Unable to open deferred deep link (%s)", deeplink);
            return;
        }
        this.logger.info("Open deferred deep link (%s)", deeplink);
        this.adjustConfig.context.startActivity(deeplinkIntent);
    }

    private void sendReferrerI(String referrer, long clickTime) {
        if (referrer == null || referrer.length() == 0) {
            return;
        }
        PackageBuilder clickPackageBuilder = this.queryStringClickPackageBuilderI(referrer);
        if (clickPackageBuilder == null) {
            return;
        }
        clickPackageBuilder.referrer = referrer;
        clickPackageBuilder.clickTime = clickTime;
        ActivityPackage clickPackage = clickPackageBuilder.buildClickPackage("reftag");
        this.sdkClickHandler.sendSdkClick(clickPackage);
    }

    private void readOpenUrlI(Uri url, long clickTime) {
        PackageBuilder clickPackageBuilder;
        if (url == null) {
            return;
        }
        String queryString = url.getQuery();
        if (queryString == null && url.toString().length() > 0) {
            queryString = "";
        }
        if ((clickPackageBuilder = this.queryStringClickPackageBuilderI(queryString)) == null) {
            return;
        }
        clickPackageBuilder.deeplink = url.toString();
        clickPackageBuilder.clickTime = clickTime;
        ActivityPackage clickPackage = clickPackageBuilder.buildClickPackage("deeplink");
        this.sdkClickHandler.sendSdkClick(clickPackage);
    }

    private PackageBuilder queryStringClickPackageBuilderI(String queryString) {
        String[] queryPairs;
        if (queryString == null) {
            return null;
        }
        LinkedHashMap<String, String> queryStringParameters = new LinkedHashMap<String, String>();
        AdjustAttribution queryStringAttribution = new AdjustAttribution();
        this.logger.verbose("Reading query string (%s)", queryString);
        for (String pair : queryPairs = queryString.split("&")) {
            this.readQueryStringI(pair, queryStringParameters, queryStringAttribution);
        }
        String reftag = (String)queryStringParameters.remove("reftag");
        long now = System.currentTimeMillis();
        PackageBuilder builder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, now);
        builder.extraParameters = queryStringParameters;
        builder.attribution = queryStringAttribution;
        builder.reftag = reftag;
        return builder;
    }

    private boolean readQueryStringI(String queryString, Map<String, String> extraParameters, AdjustAttribution queryStringAttribution) {
        String[] pairComponents = queryString.split("=");
        if (pairComponents.length != 2) {
            return false;
        }
        String key = pairComponents[0];
        if (!key.startsWith(ADJUST_PREFIX)) {
            return false;
        }
        String value = pairComponents[1];
        if (value.length() == 0) {
            return false;
        }
        String keyWOutPrefix = key.substring(ADJUST_PREFIX.length());
        if (keyWOutPrefix.length() == 0) {
            return false;
        }
        if (!this.trySetAttributionI(queryStringAttribution, keyWOutPrefix, value)) {
            extraParameters.put(keyWOutPrefix, value);
        }
        return true;
    }

    private boolean trySetAttributionI(AdjustAttribution queryStringAttribution, String key, String value) {
        if (key.equals("tracker")) {
            queryStringAttribution.trackerName = value;
            return true;
        }
        if (key.equals("campaign")) {
            queryStringAttribution.campaign = value;
            return true;
        }
        if (key.equals("adgroup")) {
            queryStringAttribution.adgroup = value;
            return true;
        }
        if (key.equals("creative")) {
            queryStringAttribution.creative = value;
            return true;
        }
        return false;
    }

    private void updateHandlersStatusAndSendI() {
        if (!this.toSendI()) {
            this.pauseSendingI();
            return;
        }
        this.resumeSendingI();
        if (!this.adjustConfig.eventBufferingEnabled) {
            this.packageHandler.sendFirstPackage();
        }
    }

    private void pauseSendingI() {
        this.attributionHandler.pauseSending();
        this.packageHandler.pauseSending();
        if (!this.toSendI(true)) {
            this.sdkClickHandler.pauseSending();
        } else {
            this.sdkClickHandler.resumeSending();
        }
    }

    private void resumeSendingI() {
        this.attributionHandler.resumeSending();
        this.packageHandler.resumeSending();
        this.sdkClickHandler.resumeSending();
    }

    private boolean updateActivityStateI(long now) {
        if (!this.checkActivityStateI(this.activityState)) {
            return false;
        }
        long lastInterval = now - this.activityState.lastActivity;
        if (lastInterval > SESSION_INTERVAL) {
            return false;
        }
        this.activityState.lastActivity = now;
        if (lastInterval < 0L) {
            this.logger.error(TIME_TRAVEL, new Object[0]);
        } else {
            this.activityState.sessionLength += lastInterval;
            this.activityState.timeSpent += lastInterval;
        }
        return true;
    }

    public static boolean deleteActivityState(Context context) {
        return context.deleteFile("AdjustIoActivityState");
    }

    public static boolean deleteAttribution(Context context) {
        return context.deleteFile("AdjustAttribution");
    }

    public static boolean deleteSessionCallbackParameters(Context context) {
        return context.deleteFile("AdjustSessionCallbackParameters");
    }

    public static boolean deleteSessionPartnerParameters(Context context) {
        return context.deleteFile("AdjustSessionPartnerParameters");
    }

    private void transferSessionPackageI(long now) {
        PackageBuilder builder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, now);
        ActivityPackage sessionPackage = builder.buildSessionPackage(this.sessionParameters, this.internalState.isDelayStart());
        this.packageHandler.addPackage(sessionPackage);
        this.packageHandler.sendFirstPackage();
    }

    private void startForegroundTimerI() {
        if (!this.isEnabledI()) {
            return;
        }
        this.foregroundTimer.start();
    }

    private void stopForegroundTimerI() {
        this.foregroundTimer.suspend();
    }

    private void foregroundTimerFiredI() {
        if (!this.isEnabledI()) {
            this.stopForegroundTimerI();
            return;
        }
        if (this.toSendI()) {
            this.packageHandler.sendFirstPackage();
        }
        if (this.updateActivityStateI(System.currentTimeMillis())) {
            this.writeActivityStateI();
        }
    }

    private void startBackgroundTimerI() {
        if (this.backgroundTimer == null) {
            return;
        }
        if (!this.toSendI()) {
            return;
        }
        if (this.backgroundTimer.getFireIn() > 0L) {
            return;
        }
        this.backgroundTimer.startIn(BACKGROUND_TIMER_INTERVAL);
    }

    private void stopBackgroundTimerI() {
        if (this.backgroundTimer == null) {
            return;
        }
        this.backgroundTimer.cancel();
    }

    private void backgroundTimerFiredI() {
        if (this.toSendI()) {
            this.packageHandler.sendFirstPackage();
        }
    }

    private void delayStartI() {
        long maxDelayStartMilli;
        if (this.internalState.isToStartNow()) {
            return;
        }
        if (this.isToUpdatePackagesI()) {
            return;
        }
        double delayStartSeconds = this.adjustConfig.delayStart != null ? this.adjustConfig.delayStart : 0.0;
        long delayStartMilli = (long)(delayStartSeconds * 1000.0);
        if (delayStartMilli > (maxDelayStartMilli = AdjustFactory.getMaxDelayStart())) {
            double maxDelayStartSeconds = maxDelayStartMilli / 1000L;
            String delayStartFormatted = Util.SecondsDisplayFormat.format(delayStartSeconds);
            String maxDelayStartFormatted = Util.SecondsDisplayFormat.format(maxDelayStartSeconds);
            this.logger.warn("Delay start of %s seconds bigger than max allowed value of %s seconds", delayStartFormatted, maxDelayStartFormatted);
            delayStartMilli = maxDelayStartMilli;
            delayStartSeconds = maxDelayStartSeconds;
        }
        String delayStartFormatted = Util.SecondsDisplayFormat.format(delayStartSeconds);
        this.logger.info("Waiting %s seconds before starting first session", delayStartFormatted);
        this.delayStartTimer.startIn(delayStartMilli);
        this.internalState.updatePackages = true;
        if (this.activityState != null) {
            this.activityState.updatePackages = true;
            this.writeActivityStateI();
        }
    }

    private void sendFirstPackagesI() {
        if (this.internalState.isToStartNow()) {
            this.logger.info("Start delay expired or never configured", new Object[0]);
            return;
        }
        this.updatePackagesI();
        this.internalState.delayStart = false;
        this.delayStartTimer.cancel();
        this.delayStartTimer = null;
        this.updateHandlersStatusAndSendI();
    }

    private void updatePackagesI() {
        this.packageHandler.updatePackages(this.sessionParameters);
        this.internalState.updatePackages = false;
        if (this.activityState != null) {
            this.activityState.updatePackages = false;
            this.writeActivityStateI();
        }
    }

    private boolean isToUpdatePackagesI() {
        if (this.activityState != null) {
            return this.activityState.updatePackages;
        }
        return this.internalState.isToUpdatePackages();
    }

    public void addSessionCallbackParameterI(String key, String value) {
        String oldValue;
        if (!Util.isValidParameter(key, "key", "Session Callback")) {
            return;
        }
        if (!Util.isValidParameter(value, "value", "Session Callback")) {
            return;
        }
        if (this.sessionParameters.callbackParameters == null) {
            this.sessionParameters.callbackParameters = new LinkedHashMap<String, String>();
        }
        if (value.equals(oldValue = this.sessionParameters.callbackParameters.get(key))) {
            this.logger.verbose("Key %s already present with the same value", key);
            return;
        }
        if (oldValue != null) {
            this.logger.warn("Key %s will be overwritten", key);
        }
        this.sessionParameters.callbackParameters.put(key, value);
        this.writeSessionCallbackParametersI();
    }

    public void addSessionPartnerParameterI(String key, String value) {
        String oldValue;
        if (!Util.isValidParameter(key, "key", "Session Partner")) {
            return;
        }
        if (!Util.isValidParameter(value, "value", "Session Partner")) {
            return;
        }
        if (this.sessionParameters.partnerParameters == null) {
            this.sessionParameters.partnerParameters = new LinkedHashMap<String, String>();
        }
        if (value.equals(oldValue = this.sessionParameters.partnerParameters.get(key))) {
            this.logger.verbose("Key %s already present with the same value", key);
            return;
        }
        if (oldValue != null) {
            this.logger.warn("Key %s will be overwritten", key);
        }
        this.sessionParameters.partnerParameters.put(key, value);
        this.writeSessionPartnerParametersI();
    }

    public void removeSessionCallbackParameterI(String key) {
        if (!Util.isValidParameter(key, "key", "Session Callback")) {
            return;
        }
        if (this.sessionParameters.callbackParameters == null) {
            this.logger.warn("Session Callback parameters are not set", new Object[0]);
            return;
        }
        String oldValue = this.sessionParameters.callbackParameters.remove(key);
        if (oldValue == null) {
            this.logger.warn("Key %s does not exist", key);
            return;
        }
        this.logger.debug("Key %s will be removed", key);
        this.writeSessionCallbackParametersI();
    }

    public void removeSessionPartnerParameterI(String key) {
        if (!Util.isValidParameter(key, "key", "Session Partner")) {
            return;
        }
        if (this.sessionParameters.partnerParameters == null) {
            this.logger.warn("Session Partner parameters are not set", new Object[0]);
            return;
        }
        String oldValue = this.sessionParameters.partnerParameters.remove(key);
        if (oldValue == null) {
            this.logger.warn("Key %s does not exist", key);
            return;
        }
        this.logger.debug("Key %s will be removed", key);
        this.writeSessionPartnerParametersI();
    }

    public void resetSessionCallbackParametersI() {
        if (this.sessionParameters.callbackParameters == null) {
            this.logger.warn("Session Callback parameters are not set", new Object[0]);
        }
        this.sessionParameters.callbackParameters = null;
        this.writeSessionCallbackParametersI();
    }

    public void resetSessionPartnerParametersI() {
        if (this.sessionParameters.partnerParameters == null) {
            this.logger.warn("Session Partner parameters are not set", new Object[0]);
        }
        this.sessionParameters.partnerParameters = null;
        this.writeSessionPartnerParametersI();
    }

    private void setPushTokenI(String token) {
        if (token == null) {
            return;
        }
        if (token.equals(this.activityState.pushToken)) {
            return;
        }
        this.activityState.pushToken = token;
        this.writeActivityStateI();
        long now = System.currentTimeMillis();
        PackageBuilder infoPackageBuilder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, now);
        ActivityPackage infoPackage = infoPackageBuilder.buildInfoPackage("push");
        this.packageHandler.addPackage(infoPackage);
        this.packageHandler.sendFirstPackage();
    }

    private void readActivityStateI(Context context) {
        try {
            this.activityState = Util.readObject(context, "AdjustIoActivityState", ACTIVITY_STATE_NAME, ActivityState.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", ACTIVITY_STATE_NAME, e.getMessage());
            this.activityState = null;
        }
    }

    private void readAttributionI(Context context) {
        try {
            this.attribution = Util.readObject(context, "AdjustAttribution", ATTRIBUTION_NAME, AdjustAttribution.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", ATTRIBUTION_NAME, e.getMessage());
            this.attribution = null;
        }
    }

    private void readSessionCallbackParametersI(Context context) {
        try {
            this.sessionParameters.callbackParameters = Util.readObject(context, "AdjustSessionCallbackParameters", SESSION_CALLBACK_PARAMETERS_NAME, Map.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", SESSION_CALLBACK_PARAMETERS_NAME, e.getMessage());
            this.sessionParameters.callbackParameters = null;
        }
    }

    private void readSessionPartnerParametersI(Context context) {
        try {
            this.sessionParameters.partnerParameters = Util.readObject(context, "AdjustSessionPartnerParameters", SESSION_PARTNER_PARAMETERS_NAME, Map.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", SESSION_PARTNER_PARAMETERS_NAME, e.getMessage());
            this.sessionParameters.partnerParameters = null;
        }
    }

    private void writeActivityStateI() {
        this.writeActivityStateS(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeActivityStateS(Runnable changeActivityState) {
        Class<ActivityState> clazz = ActivityState.class;
        synchronized (ActivityState.class) {
            if (this.activityState == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (changeActivityState != null) {
                changeActivityState.run();
            }
            Util.writeObject(this.activityState, this.adjustConfig.context, "AdjustIoActivityState", ACTIVITY_STATE_NAME);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownActivityStateS(boolean toDelete) {
        Class<ActivityState> clazz = ActivityState.class;
        synchronized (ActivityState.class) {
            if (this.activityState == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (toDelete && this.adjustConfig != null && this.adjustConfig.context != null) {
                ActivityHandler.deleteActivityState(this.adjustConfig.context);
            }
            this.activityState = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAttributionI() {
        Class<AdjustAttribution> clazz = AdjustAttribution.class;
        synchronized (AdjustAttribution.class) {
            if (this.attribution == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Util.writeObject(this.attribution, this.adjustConfig.context, "AdjustAttribution", ATTRIBUTION_NAME);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownAttributionS(boolean toDelete) {
        Class<AdjustAttribution> clazz = AdjustAttribution.class;
        synchronized (AdjustAttribution.class) {
            if (this.attribution == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (toDelete && this.adjustConfig != null && this.adjustConfig.context != null) {
                ActivityHandler.deleteAttribution(this.adjustConfig.context);
            }
            this.attribution = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionCallbackParametersI() {
        Class<SessionParameters> clazz = SessionParameters.class;
        synchronized (SessionParameters.class) {
            if (this.sessionParameters == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Util.writeObject(this.sessionParameters.callbackParameters, this.adjustConfig.context, "AdjustSessionCallbackParameters", SESSION_CALLBACK_PARAMETERS_NAME);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionPartnerParametersI() {
        Class<SessionParameters> clazz = SessionParameters.class;
        synchronized (SessionParameters.class) {
            if (this.sessionParameters == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Util.writeObject(this.sessionParameters.partnerParameters, this.adjustConfig.context, "AdjustSessionPartnerParameters", SESSION_PARTNER_PARAMETERS_NAME);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownAllSessionParametersS(boolean toDelete) {
        Class<SessionParameters> clazz = SessionParameters.class;
        synchronized (SessionParameters.class) {
            if (this.sessionParameters == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (toDelete && this.adjustConfig != null && this.adjustConfig.context != null) {
                ActivityHandler.deleteSessionCallbackParameters(this.adjustConfig.context);
                ActivityHandler.deleteSessionPartnerParameters(this.adjustConfig.context);
            }
            this.sessionParameters = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private boolean checkEventI(AdjustEvent event) {
        if (event == null) {
            this.logger.error("Event missing", new Object[0]);
            return false;
        }
        if (!event.isValid()) {
            this.logger.error("Event not initialized correctly", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkOrderIdI(String orderId) {
        if (orderId == null || orderId.isEmpty()) {
            return true;
        }
        if (this.activityState.findOrderId(orderId)) {
            this.logger.info("Skipping duplicated order ID '%s'", orderId);
            return false;
        }
        this.activityState.addOrderId(orderId);
        this.logger.verbose("Added order ID '%s'", orderId);
        return true;
    }

    private boolean checkActivityStateI(ActivityState activityState) {
        if (activityState == null) {
            this.logger.error("Missing activity state", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean pausedI() {
        return this.pausedI(false);
    }

    private boolean pausedI(boolean sdkClickHandlerOnly) {
        if (sdkClickHandlerOnly) {
            return this.internalState.isOffline() || !this.isEnabledI();
        }
        return this.internalState.isOffline() || !this.isEnabledI() || this.internalState.isDelayStart();
    }

    private boolean toSendI() {
        return this.toSendI(false);
    }

    private boolean toSendI(boolean sdkClickHandlerOnly) {
        if (this.pausedI(sdkClickHandlerOnly)) {
            return false;
        }
        if (this.adjustConfig.sendInBackground) {
            return true;
        }
        return this.internalState.isForeground();
    }

    public class InternalState {
        boolean enabled;
        boolean offline;
        boolean background;
        boolean delayStart;
        boolean updatePackages;

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDisabled() {
            return !this.enabled;
        }

        public boolean isOffline() {
            return this.offline;
        }

        public boolean isOnline() {
            return !this.offline;
        }

        public boolean isBackground() {
            return this.background;
        }

        public boolean isForeground() {
            return !this.background;
        }

        public boolean isDelayStart() {
            return this.delayStart;
        }

        public boolean isToStartNow() {
            return !this.delayStart;
        }

        public boolean isToUpdatePackages() {
            return this.updatePackages;
        }
    }
}

