/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.Constants;
import com.adjust.sdk.plugin.Plugin;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Reflection {
    public static String getPlayAdId(Context context) {
        try {
            Object AdvertisingInfoObject = Reflection.getAdvertisingInfoObject(context);
            String playAdid = (String)Reflection.invokeInstanceMethod(AdvertisingInfoObject, "getId", null, new Object[0]);
            return playAdid;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Boolean isPlayTrackingEnabled(Context context) {
        try {
            Object AdvertisingInfoObject = Reflection.getAdvertisingInfoObject(context);
            Boolean isLimitedTrackingEnabled = (Boolean)Reflection.invokeInstanceMethod(AdvertisingInfoObject, "isLimitAdTrackingEnabled", null, new Object[0]);
            Boolean isPlayTrackingEnabled = isLimitedTrackingEnabled == null ? null : Boolean.valueOf(isLimitedTrackingEnabled == false);
            return isPlayTrackingEnabled;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getMacAddress(Context context) {
        try {
            String macSha1 = (String)Reflection.invokeStaticMethod("com.adjust.sdk.plugin.MacAddressUtil", "getMacAddress", new Class[]{Context.class}, context);
            return macSha1;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getAndroidId(Context context) {
        try {
            String androidId = (String)Reflection.invokeStaticMethod("com.adjust.sdk.plugin.AndroidIdUtil", "getAndroidId", new Class[]{Context.class}, context);
            return androidId;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Object getAdvertisingInfoObject(Context context) throws Exception {
        return Reflection.invokeStaticMethod("com.google.android.gms.ads.identifier.AdvertisingIdClient", "getAdvertisingIdInfo", new Class[]{Context.class}, context);
    }

    private static boolean isConnectionResultSuccess(Integer statusCode) {
        if (statusCode == null) {
            return false;
        }
        try {
            Class<?> ConnectionResultClass = Class.forName("com.google.android.gms.common.ConnectionResult");
            Field SuccessField = ConnectionResultClass.getField("SUCCESS");
            int successStatusCode = SuccessField.getInt(null);
            return successStatusCode == statusCode;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String[] getSupportedAbis() {
        String[] supportedAbis = null;
        try {
            Class buildClass = Reflection.forName("android.os.Build");
            Field supportedAbisField = buildClass.getField("SUPPORTED_ABIS");
            Object supportedAbisObject = supportedAbisField.get(null);
            if (supportedAbisObject instanceof String[]) {
                supportedAbis = (String[])supportedAbisObject;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return supportedAbis;
    }

    public static String getCpuAbi() {
        String cpuAbi = null;
        try {
            Class buildClass = Reflection.forName("android.os.Build");
            Field cpuAbiField = buildClass.getField("CPU_ABI");
            Object cpuAbiObject = cpuAbiField.get(null);
            if (cpuAbiObject instanceof String) {
                cpuAbi = (String)cpuAbiObject;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cpuAbi;
    }

    public static Class forName(String className) {
        try {
            Class<?> classObject = Class.forName(className);
            return classObject;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Object createDefaultInstance(String className) {
        Class classObject = Reflection.forName(className);
        Object instance = Reflection.createDefaultInstance(classObject);
        return instance;
    }

    public static Object createDefaultInstance(Class classObject) {
        try {
            Object instance = classObject.newInstance();
            return instance;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Object createInstance(String className, Class[] cArgs, Object ... args) {
        try {
            Class<?> classObject = Class.forName(className);
            Constructor<?> constructor = classObject.getConstructor(cArgs);
            Object instance = constructor.newInstance(args);
            return instance;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Object invokeStaticMethod(String className, String methodName, Class[] cArgs, Object ... args) throws Exception {
        Class<?> classObject = Class.forName(className);
        return Reflection.invokeMethod(classObject, methodName, null, cArgs, args);
    }

    public static Object invokeInstanceMethod(Object instance, String methodName, Class[] cArgs, Object ... args) throws Exception {
        Class<?> classObject = instance.getClass();
        return Reflection.invokeMethod(classObject, methodName, instance, cArgs, args);
    }

    public static Object invokeMethod(Class classObject, String methodName, Object instance, Class[] cArgs, Object ... args) throws Exception {
        Method methodObject = classObject.getMethod(methodName, cArgs);
        Object resultObject = methodObject.invoke(instance, args);
        return resultObject;
    }

    public static Map<String, String> getPluginKeys(Context context) {
        HashMap<String, String> pluginKeys = new HashMap<String, String>();
        for (Plugin plugin : Reflection.getPlugins()) {
            Map.Entry<String, String> pluginEntry = plugin.getParameter(context);
            if (pluginEntry == null) continue;
            pluginKeys.put(pluginEntry.getKey(), pluginEntry.getValue());
        }
        if (pluginKeys.size() == 0) {
            return null;
        }
        return pluginKeys;
    }

    private static List<Plugin> getPlugins() {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>(Constants.PLUGINS.size());
        for (String pluginName : Constants.PLUGINS) {
            Object pluginObject = Reflection.createDefaultInstance(pluginName);
            if (pluginObject == null || !(pluginObject instanceof Plugin)) continue;
            plugins.add((Plugin)pluginObject);
        }
        return plugins;
    }
}

