/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRequestHandler;
import com.adjust.sdk.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class RequestHandler
extends HandlerThread
implements IRequestHandler {
    private InternalHandler internalHandler;
    private IPackageHandler packageHandler;
    private HttpClient httpClient;
    private ILogger logger;

    public RequestHandler(IPackageHandler packageHandler) {
        super("Adjust", 1);
        this.setDaemon(true);
        this.start();
        this.logger = AdjustFactory.getLogger();
        this.internalHandler = new InternalHandler(this.getLooper(), this);
        this.init(packageHandler);
        Message message = Message.obtain();
        message.arg1 = 72401;
        this.internalHandler.sendMessage(message);
    }

    @Override
    public void init(IPackageHandler packageHandler) {
        this.packageHandler = packageHandler;
    }

    @Override
    public void sendPackage(ActivityPackage pack) {
        Message message = Message.obtain();
        message.arg1 = 72400;
        message.obj = pack;
        this.internalHandler.sendMessage(message);
    }

    @Override
    public void sendClickPackage(ActivityPackage clickPackage) {
        Message message = Message.obtain();
        message.arg1 = 72402;
        message.obj = clickPackage;
        this.internalHandler.sendMessage(message);
    }

    private void initInternal() {
        this.httpClient = Util.getHttpClient();
    }

    private void sendInternal(ActivityPackage activityPackage, boolean sendToPackageHandler) {
        try {
            HttpUriRequest request = this.getRequest(activityPackage);
            HttpResponse response = this.httpClient.execute(request);
            this.requestFinished(response, sendToPackageHandler);
        }
        catch (UnsupportedEncodingException e) {
            this.sendNextPackage(activityPackage, "Failed to encode parameters", e, sendToPackageHandler);
        }
        catch (ClientProtocolException e) {
            this.closePackage(activityPackage, "Client protocol error", e, sendToPackageHandler);
        }
        catch (SocketTimeoutException e) {
            this.closePackage(activityPackage, "Request timed out", e, sendToPackageHandler);
        }
        catch (IOException e) {
            this.closePackage(activityPackage, "Request failed", e, sendToPackageHandler);
        }
        catch (Throwable e) {
            this.sendNextPackage(activityPackage, "Runtime exception", e, sendToPackageHandler);
        }
    }

    private void requestFinished(HttpResponse response, boolean sendToPackageHandler) {
        JSONObject jsonResponse = Util.parseJsonResponse(response);
        if (jsonResponse == null) {
            if (sendToPackageHandler) {
                this.packageHandler.closeFirstPackage();
            }
            return;
        }
        this.packageHandler.finishedTrackingActivity(jsonResponse);
        if (sendToPackageHandler) {
            this.packageHandler.sendNextPackage();
        }
    }

    private void closePackage(ActivityPackage activityPackage, String message, Throwable throwable, boolean sendToPackageHandler) {
        String packageMessage = activityPackage.getFailureMessage();
        String reasonString = this.getReasonString(message, throwable);
        this.logger.error("%s. (%s) Will retry later", packageMessage, reasonString);
        if (sendToPackageHandler) {
            this.packageHandler.closeFirstPackage();
        }
    }

    private void sendNextPackage(ActivityPackage activityPackage, String message, Throwable throwable, boolean sendToPackageHandler) {
        String failureMessage = activityPackage.getFailureMessage();
        String reasonString = this.getReasonString(message, throwable);
        this.logger.error("%s. (%s)", failureMessage, reasonString);
        if (sendToPackageHandler) {
            this.packageHandler.sendNextPackage();
        }
    }

    private String getReasonString(String message, Throwable throwable) {
        if (throwable != null) {
            return String.format(Locale.US, "%s: %s", message, throwable);
        }
        return String.format(Locale.US, "%s", message);
    }

    private HttpUriRequest getRequest(ActivityPackage activityPackage) throws UnsupportedEncodingException {
        String url = "https://app.adjust.com" + activityPackage.getPath();
        HttpPost request = new HttpPost(url);
        String language = Locale.getDefault().getLanguage();
        request.addHeader("Client-SDK", activityPackage.getClientSdk());
        request.addHeader("Accept-Language", language);
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : activityPackage.getParameters().entrySet()) {
            BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue());
            pairs.add(pair);
        }
        long now = System.currentTimeMillis();
        String dateString = Util.dateFormat(now);
        BasicNameValuePair sentAtPair = new BasicNameValuePair("sent_at", dateString);
        pairs.add(sentAtPair);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairs);
        entity.setContentType("application/x-www-form-urlencoded");
        request.setEntity((HttpEntity)entity);
        return request;
    }

    private static final class InternalHandler
    extends Handler {
        private static final int INIT = 72401;
        private static final int SEND = 72400;
        private static final int SEND_CLICK = 72402;
        private final WeakReference<RequestHandler> requestHandlerReference;

        protected InternalHandler(Looper looper, RequestHandler requestHandler) {
            super(looper);
            this.requestHandlerReference = new WeakReference<RequestHandler>(requestHandler);
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            RequestHandler requestHandler = (RequestHandler)this.requestHandlerReference.get();
            if (requestHandler == null) {
                return;
            }
            switch (message.arg1) {
                case 72401: {
                    requestHandler.initInternal();
                    break;
                }
                case 72400: {
                    ActivityPackage activityPackage = (ActivityPackage)message.obj;
                    requestHandler.sendInternal(activityPackage, true);
                    break;
                }
                case 72402: {
                    ActivityPackage clickPackage = (ActivityPackage)message.obj;
                    requestHandler.sendInternal(clickPackage, false);
                }
            }
        }
    }
}

