/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONObject;

public class AttributionHandler
implements IAttributionHandler {
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private IActivityHandler activityHandler;
    private ILogger logger = AdjustFactory.getLogger();
    private ActivityPackage attributionPackage;
    private ScheduledFuture waitingTask;
    private HttpClient httpClient = Util.getHttpClient();
    private boolean paused;
    private boolean hasListener;

    public AttributionHandler(IActivityHandler activityHandler, ActivityPackage attributionPackage, boolean startPaused, boolean hasListener) {
        this.init(activityHandler, attributionPackage, startPaused, hasListener);
    }

    @Override
    public void init(IActivityHandler activityHandler, ActivityPackage attributionPackage, boolean startPaused, boolean hasListener) {
        this.activityHandler = activityHandler;
        this.attributionPackage = attributionPackage;
        this.paused = startPaused;
        this.hasListener = hasListener;
    }

    @Override
    public void getAttribution() {
        this.getAttribution(0);
    }

    @Override
    public void checkAttribution(final JSONObject jsonResponse) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                AttributionHandler.this.checkAttributionInternal(jsonResponse);
            }
        });
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    private void getAttribution(int delayInMilliseconds) {
        if (this.waitingTask != null) {
            if (this.waitingTask.getDelay(TimeUnit.MILLISECONDS) > (long)delayInMilliseconds) {
                return;
            }
            this.waitingTask.cancel(false);
        }
        if (delayInMilliseconds != 0) {
            this.logger.debug("Waiting to query attribution in %d milliseconds", delayInMilliseconds);
        }
        this.waitingTask = this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                AttributionHandler.this.getAttributionInternal();
            }
        }, (long)delayInMilliseconds, TimeUnit.MILLISECONDS);
    }

    private void checkAttributionInternal(JSONObject jsonResponse) {
        if (jsonResponse == null) {
            return;
        }
        JSONObject attributionJson = jsonResponse.optJSONObject("attribution");
        AdjustAttribution attribution = AdjustAttribution.fromJson(attributionJson);
        int timerMilliseconds = jsonResponse.optInt("ask_in", -1);
        if (timerMilliseconds < 0) {
            this.activityHandler.tryUpdateAttribution(attribution);
            this.activityHandler.setAskingAttribution(false);
            return;
        }
        this.activityHandler.setAskingAttribution(true);
        this.getAttribution(timerMilliseconds);
    }

    private void getAttributionInternal() {
        if (!this.hasListener) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Attribution Handler is paused", new Object[0]);
            return;
        }
        this.logger.verbose("%s", this.attributionPackage.getExtendedString());
        HttpResponse httpResponse = null;
        try {
            HttpGet request = this.getRequest(this.attributionPackage);
            httpResponse = this.httpClient.execute((HttpUriRequest)request);
        }
        catch (Exception e) {
            this.logger.error("Failed to get attribution (%s)", e.getMessage());
            return;
        }
        JSONObject jsonResponse = Util.parseJsonResponse(httpResponse);
        this.checkAttributionInternal(jsonResponse);
    }

    private Uri buildUri(ActivityPackage attributionPackage) {
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.scheme("https");
        uriBuilder.authority("app.adjust.com");
        uriBuilder.appendPath(attributionPackage.getPath());
        for (Map.Entry<String, String> entry : attributionPackage.getParameters().entrySet()) {
            uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        return uriBuilder.build();
    }

    private HttpGet getRequest(ActivityPackage attributionPackage) throws URISyntaxException {
        HttpGet request = new HttpGet();
        Uri uri = this.buildUri(attributionPackage);
        request.setURI(new URI(uri.toString()));
        request.addHeader("Client-SDK", attributionPackage.getClientSdk());
        return request;
    }
}

