/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRequestHandler;
import com.adjust.sdk.Logger;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONObject;

public class RequestHandler
extends HandlerThread
implements IRequestHandler {
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final int SOCKET_TIMEOUT = 60000;
    private InternalHandler internalHandler;
    private IPackageHandler packageHandler;
    private HttpClient httpClient;
    private Logger logger;

    public RequestHandler(IPackageHandler packageHandler) {
        super("Adjust", 1);
        this.setDaemon(true);
        this.start();
        this.logger = AdjustFactory.getLogger();
        this.internalHandler = new InternalHandler(this.getLooper(), this);
        this.packageHandler = packageHandler;
        Message message = Message.obtain();
        message.arg1 = 72401;
        this.internalHandler.sendMessage(message);
    }

    @Override
    public void sendPackage(ActivityPackage pack) {
        Message message = Message.obtain();
        message.arg1 = 72400;
        message.obj = pack;
        this.internalHandler.sendMessage(message);
    }

    private void initInternal() {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)60000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)60000);
        this.httpClient = AdjustFactory.getHttpClient((HttpParams)httpParams);
    }

    private void sendInternal(ActivityPackage activityPackage) {
        try {
            HttpUriRequest request = this.getRequest(activityPackage);
            HttpResponse response = this.httpClient.execute(request);
            this.requestFinished(response, activityPackage);
        }
        catch (UnsupportedEncodingException e) {
            this.sendNextPackage(activityPackage, "Failed to encode parameters", e);
        }
        catch (ClientProtocolException e) {
            this.closePackage(activityPackage, "Client protocol error", e);
        }
        catch (SocketTimeoutException e) {
            this.closePackage(activityPackage, "Request timed out", e);
        }
        catch (IOException e) {
            this.closePackage(activityPackage, "Request failed", e);
        }
        catch (Throwable e) {
            this.sendNextPackage(activityPackage, "Runtime exception", e);
        }
    }

    private void requestFinished(HttpResponse response, ActivityPackage activityPackage) {
        int statusCode = response.getStatusLine().getStatusCode();
        String responseString = this.parseResponse(response);
        JSONObject jsonResponse = Util.buildJsonObject(responseString);
        ResponseData responseData = ResponseData.fromJson(jsonResponse, responseString);
        if (200 == statusCode) {
            responseData.setWasSuccess(true);
            this.logger.info(activityPackage.getSuccessMessage(), new Object[0]);
        } else {
            this.logger.error("%s. (%s)", activityPackage.getFailureMessage(), responseData.getError());
        }
        this.packageHandler.finishedTrackingActivity(activityPackage, responseData, jsonResponse);
        this.packageHandler.sendNextPackage();
    }

    private String parseResponse(HttpResponse response) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            response.getEntity().writeTo((OutputStream)out);
            out.close();
            return out.toString().trim();
        }
        catch (Exception e) {
            this.logger.error("Failed to parse response (%s)", e);
            return "Failed to parse response";
        }
    }

    private void closePackage(ActivityPackage activityPackage, String message, Throwable throwable) {
        String packageMessage = activityPackage.getFailureMessage();
        String handlerMessage = this.packageHandler.getFailureMessage();
        String reasonString = this.getReasonString(message, throwable);
        this.logger.error("%s. (%s) %s", packageMessage, reasonString, handlerMessage);
        ResponseData responseData = ResponseData.fromError(reasonString);
        responseData.setWillRetry(!this.packageHandler.dropsOfflineActivities());
        this.packageHandler.finishedTrackingActivity(activityPackage, responseData, null);
        this.packageHandler.closeFirstPackage();
    }

    private void sendNextPackage(ActivityPackage activityPackage, String message, Throwable throwable) {
        String failureMessage = activityPackage.getFailureMessage();
        String reasonString = this.getReasonString(message, throwable);
        this.logger.error("%s. (%s)", failureMessage, reasonString);
        ResponseData responseData = ResponseData.fromError(reasonString);
        this.packageHandler.finishedTrackingActivity(activityPackage, responseData, null);
        this.packageHandler.sendNextPackage();
    }

    private String getReasonString(String message, Throwable throwable) {
        if (throwable != null) {
            return String.format("%s: %s", message, throwable);
        }
        return String.format("%s", message);
    }

    private HttpUriRequest getRequest(ActivityPackage activityPackage) throws UnsupportedEncodingException {
        String url = "https://app.adjust.io" + activityPackage.getPath();
        HttpPost request = new HttpPost(url);
        String language = Locale.getDefault().getLanguage();
        request.addHeader("User-Agent", activityPackage.getUserAgent());
        request.addHeader("Client-SDK", activityPackage.getClientSdk());
        request.addHeader("Accept-Language", language);
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entity : activityPackage.getParameters().entrySet()) {
            BasicNameValuePair pair = new BasicNameValuePair(entity.getKey(), entity.getValue());
            pairs.add(pair);
        }
        long now = System.currentTimeMillis();
        String dateString = Util.dateFormat(now);
        BasicNameValuePair sentAtPair = new BasicNameValuePair("sent_at", dateString);
        pairs.add(sentAtPair);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairs);
        entity.setContentType("application/x-www-form-urlencoded");
        request.setEntity((HttpEntity)entity);
        return request;
    }

    private static final class InternalHandler
    extends Handler {
        private static final int INIT = 72401;
        private static final int SEND = 72400;
        private final WeakReference<RequestHandler> requestHandlerReference;

        protected InternalHandler(Looper looper, RequestHandler requestHandler) {
            super(looper);
            this.requestHandlerReference = new WeakReference<RequestHandler>(requestHandler);
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            RequestHandler requestHandler = (RequestHandler)this.requestHandlerReference.get();
            if (null == requestHandler) {
                return;
            }
            switch (message.arg1) {
                case 72401: {
                    requestHandler.initInternal();
                    break;
                }
                case 72400: {
                    ActivityPackage activityPackage = (ActivityPackage)message.obj;
                    requestHandler.sendInternal(activityPackage);
                }
            }
        }
    }
}

