/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.net.Uri;
import com.adjust.sdk.ActivityHandler;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.Logger;
import com.adjust.sdk.OnFinishedListener;
import java.util.Map;

public class Adjust {
    private static ActivityHandler activityHandler;

    public static void onResume(Context context) {
        if (null == activityHandler) {
            activityHandler = new ActivityHandler(context);
        }
        activityHandler.trackSubsessionStart();
    }

    public static void onPause() {
        try {
            Adjust.getLogger().debug("onPause", new Object[0]);
            activityHandler.trackSubsessionEnd();
        }
        catch (NullPointerException e) {
            Adjust.getLogger().error("No activity handler found", new Object[0]);
        }
    }

    public static void setOnFinishedListener(OnFinishedListener listener) {
        try {
            activityHandler.setOnFinishedListener(listener);
        }
        catch (NullPointerException e) {
            Adjust.getLogger().error("No activity handler found", new Object[0]);
        }
    }

    public static void trackEvent(String eventToken) {
        Adjust.trackEvent(eventToken, null);
    }

    public static void trackEvent(String eventToken, Map<String, String> parameters) {
        try {
            activityHandler.trackEvent(eventToken, parameters);
        }
        catch (NullPointerException e) {
            Adjust.getLogger().error("No activity handler found", new Object[0]);
        }
    }

    public static void trackRevenue(double amountInCents) {
        Adjust.trackRevenue(amountInCents, null);
    }

    public static void trackRevenue(double amountInCents, String eventToken) {
        Adjust.trackRevenue(amountInCents, eventToken, null);
    }

    public static void trackRevenue(double amountInCents, String eventToken, Map<String, String> parameters) {
        try {
            activityHandler.trackRevenue(amountInCents, eventToken, parameters);
        }
        catch (NullPointerException e) {
            Adjust.getLogger().error("No activity handler found", new Object[0]);
        }
    }

    public static void setEnabled(Boolean enabled) {
        try {
            activityHandler.setEnabled(enabled);
        }
        catch (NullPointerException e) {
            Adjust.getLogger().error("No activity handler found", new Object[0]);
        }
    }

    public static Boolean isEnabled() {
        try {
            return activityHandler.isEnabled();
        }
        catch (NullPointerException e) {
            Adjust.getLogger().error("No activity handler found", new Object[0]);
            return false;
        }
    }

    public static void appWillOpenUrl(Uri url) {
        try {
            activityHandler.readOpenUrl(url);
        }
        catch (NullPointerException e) {
            Adjust.getLogger().error("No activity handler found", new Object[0]);
        }
    }

    public static void appDidLaunch(Context context, String appToken, String environment, String logLevel, boolean eventBuffering) {
        activityHandler = new ActivityHandler(context, appToken, environment, logLevel, eventBuffering);
    }

    public static void setSdkPrefix(String sdkPrefix) {
        activityHandler.setSdkPrefix(sdkPrefix);
    }

    private static Logger getLogger() {
        return AdjustFactory.getLogger();
    }
}

