/*
 * Decompiled with CFR 0.152.
 */
package com.adityarathi.viewwrapperedittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import com.adityarathi.viewwrapperedittext.CustomEditText;
import com.adityarathi.viewwrapperedittext.R;
import java.util.ArrayList;

public class ViewTextWrapperLayout
extends LinearLayout {
    private int mDividerSpace = 0;
    private ArrayList<CustomEditText> editTextArrayList;
    private ArrayList<View> customViewArrayList;
    private ArrayList<View> viewArrayList;
    private int focusedEditTextPointer = 0;
    private int removePointer;
    private CustomEditText bodyMainEditText;
    private String bodyMainHint = "";
    private boolean generateSameTypeOfEditTexts = true;
    private View.OnFocusChangeListener focusListener = new View.OnFocusChangeListener(){

        public void onFocusChange(View v, boolean hasFocus) {
            if (hasFocus) {
                ViewTextWrapperLayout.this.focusedEditTextPointer = ViewTextWrapperLayout.this.viewArrayList.indexOf(v);
                Log.d((String)"Pointer4", (String)(ViewTextWrapperLayout.this.focusedEditTextPointer + ""));
            }
        }
    };

    public boolean isGenerateSameTypeOfEditTexts() {
        return this.generateSameTypeOfEditTexts;
    }

    public void setGenerateSameTypeOfEditTexts(boolean generateSameTypeOfEditTexts) {
        this.generateSameTypeOfEditTexts = generateSameTypeOfEditTexts;
    }

    public ViewTextWrapperLayout(Context context) {
        this(context, null);
    }

    public ViewTextWrapperLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    public void setOrientation(int orientation) {
        if (0 == orientation) {
            throw new IllegalArgumentException("ViewTextWrapperLayout must be VERTICAL.");
        }
        super.setOrientation(orientation);
    }

    private void initialize(Context context, AttributeSet attrs) {
        this.viewArrayList = new ArrayList();
        this.customViewArrayList = new ArrayList();
        this.editTextArrayList = new ArrayList();
        this.focusedEditTextPointer = 0;
        this.setOrientation(1);
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ViewTextWrapperLayout);
            if (ta != null) {
                this.mDividerSpace = ta.getDimensionPixelSize(R.styleable.ViewTextWrapperLayout_arathiDividerSpace, 0);
            }
            ta.recycle();
            this.bodyMainEditText = new CustomEditText(this.getContext());
            this.bodyMainEditText.setOnFocusChangeListener(this.focusListener);
            this.bodyMainEditText.setHint(this.bodyMainHint);
            this.bodyMainEditText.setGravity(48);
            this.viewArrayList.add((View)this.bodyMainEditText);
            this.addView((View)this.bodyMainEditText, 0);
        }
    }

    public void addViewWithinText(View view) {
        CustomEditText nextEditText = new CustomEditText(this.getContext());
        this.additionOperationOfTheViews(view, nextEditText);
    }

    public void addViewWithinText(View view, CustomEditText nextEditText) {
        this.additionOperationOfTheViews(view, nextEditText);
    }

    private void additionOperationOfTheViews(View view, CustomEditText nextEditText) {
        Log.d((String)"Pointer1", (String)(this.focusedEditTextPointer + ""));
        if (this.focusedEditTextPointer < 0 || this.focusedEditTextPointer >= this.viewArrayList.size() || !(this.viewArrayList.get(this.focusedEditTextPointer) instanceof CustomEditText)) {
            return;
        }
        CustomEditText previousEditText = (CustomEditText)this.viewArrayList.get(this.focusedEditTextPointer);
        nextEditText.setOnFocusChangeListener(this.focusListener);
        int cursorPosition = previousEditText.getCursorPositionEnd();
        Editable existingText = previousEditText.getText();
        CharSequence cursorToEnd = cursorPosition < existingText.length() ? existingText.subSequence(cursorPosition, existingText.length()) : "";
        CharSequence remainingText = existingText.subSequence(0, cursorPosition);
        previousEditText.setText(remainingText);
        nextEditText.setText(cursorToEnd);
        this.viewArrayList.add(this.focusedEditTextPointer + 1, view);
        this.addView(view, this.focusedEditTextPointer + 1);
        this.viewArrayList.add(this.focusedEditTextPointer + 2, (View)nextEditText);
        this.addView((View)nextEditText, this.focusedEditTextPointer + 2);
        if (previousEditText.getText().toString().equals("")) {
            this.removeView((View)previousEditText);
            this.viewArrayList.remove((Object)previousEditText);
            if (nextEditText.isFocused()) {
                this.focusedEditTextPointer = this.viewArrayList.indexOf((Object)nextEditText);
            }
        }
        Log.d((String)"Pointer2", (String)(this.focusedEditTextPointer + ""));
    }

    public void deleteViewWithinText(View view) {
        Log.d((String)"Pointer3", (String)(this.focusedEditTextPointer + ""));
        this.removePointer = this.viewArrayList.indexOf(view);
        Log.d((String)"REMOVE POINTER", (String)(this.removePointer + ""));
        boolean mergeEditTexts = false;
        boolean bodyTopMergeBelow = false;
        if (this.removePointer > 0 && this.removePointer < this.viewArrayList.size() && this.viewArrayList.get(this.removePointer - 1) instanceof CustomEditText && this.viewArrayList.get(this.removePointer + 1) instanceof CustomEditText) {
            mergeEditTexts = true;
        } else if (this.removePointer == 0 && this.viewArrayList.get(this.removePointer + 1) instanceof CustomEditText) {
            bodyTopMergeBelow = true;
        }
        if (mergeEditTexts) {
            CustomEditText editTextAbove = (CustomEditText)this.viewArrayList.get(this.removePointer - 1);
            CustomEditText editTextBelow = (CustomEditText)this.viewArrayList.get(this.removePointer + 1);
            Editable charSequence1 = editTextAbove.getText();
            Editable charSequence2 = editTextBelow.getText();
            String combined = charSequence1.toString().concat(charSequence2.toString());
            editTextAbove.setText(combined);
            this.removeViewAt(this.removePointer);
            this.viewArrayList.remove(this.removePointer);
            this.removeViewAt(this.removePointer);
            this.viewArrayList.remove(this.removePointer);
        } else {
            if (bodyTopMergeBelow) {
                this.bodyMainEditText = (CustomEditText)this.viewArrayList.get(this.removePointer + 1);
                this.bodyMainEditText.setHint(this.bodyMainHint);
            }
            this.focusedEditTextPointer = this.removePointer - 1 >= 0 && this.viewArrayList.get(this.removePointer - 1) instanceof CustomEditText ? this.removePointer - 1 : this.removePointer;
            this.removeViewAt(this.removePointer);
            this.viewArrayList.remove(this.removePointer);
        }
        Log.d((String)"Pointer4", (String)(this.focusedEditTextPointer + ""));
    }
}

