/*
 * Decompiled with CFR 0.152.
 */
package com.adityaikhbalm.bottomnavigationviewrounded;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.view.View;
import com.adityaikhbalm.bottomnavigationviewrounded.R;
import com.google.android.material.bottomnavigation.BottomNavigationView;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/adityaikhbalm/bottomnavigationviewrounded/BottomNavigationViewRounded;", "Lcom/google/android/material/bottomnavigation/BottomNavigationView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "cornerDimensions", "", "mPath", "Landroid/graphics/Path;", "convertDpToPixel", "", "draw", "", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "", "h", "oldw", "oldh", "bottomnavigationrounded_release"})
public final class BottomNavigationViewRounded
extends BottomNavigationView {
    private Path mPath;
    private float[] cornerDimensions;
    private HashMap _$_findViewCache;

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.clipPath(this.mPath);
        super.draw(canvas);
        canvas.restore();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        RectF r = new RectF(0.0f, 0.0f, (float)w, (float)h);
        this.mPath = new Path();
        this.mPath.addRoundRect(r, this.cornerDimensions, Path.Direction.CW);
        this.mPath.close();
    }

    private final float convertDpToPixel() {
        float f = 50;
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return f * ((float)resources.getDisplayMetrics().densityDpi / (float)160);
    }

    /*
     * WARNING - void declaration
     */
    public BottomNavigationViewRounded(@NotNull Context context, @Nullable AttributeSet attrs) {
        int backgroundColor;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.mPath = new Path();
        this.cornerDimensions = new float[8];
        ShapeDrawable bottomNavigationDrawable = new ShapeDrawable((Shape)new RoundRectShape(this.cornerDimensions, null, null));
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BottomNavigationViewRounded);
            backgroundColor = ta.getColor(R.styleable.BottomNavigationViewRounded_backgroundColor, -1);
            if (backgroundColor != -1) {
                Paint paint = bottomNavigationDrawable.getPaint();
                Intrinsics.checkExpressionValueIsNotNull((Object)paint, (String)"bottomNavigationDrawable.paint");
                paint.setColor(backgroundColor);
            }
            ta.recycle();
        }
        this.setBackground((Drawable)bottomNavigationDrawable);
        float radius = this.convertDpToPixel();
        backgroundColor = 0;
        int n = this.cornerDimensions.length;
        while (backgroundColor < n) {
            void i;
            this.cornerDimensions[i] = radius;
            ++i;
        }
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

