/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;
import com.adi.lib.R;
import com.adi.lib.chart.ChartView;
import com.adi.lib.chart.entity.Chart;
import com.adi.lib.chart.entity.Scene;
import com.adi.lib.utils.AndroidUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class XAxisView
extends View {
    private int height;
    private int width;
    Scene scene;
    DateFormat df = new SimpleDateFormat("MMM dd", Locale.US);
    Paint fontPaint = new Paint();
    float textSize;
    String date;
    float horizontalPadding;
    float verticalPadding;
    Chart chart;
    float fontAlpha;

    public XAxisView(Context context, Chart chart) {
        super(context);
        this.chart = chart;
        this.init();
    }

    private void init() {
        this.textSize = AndroidUtils.dpToPx(this.getContext(), 12.0f);
        this.horizontalPadding = AndroidUtils.dpToPx(this.getContext(), 18.0f);
        this.verticalPadding = AndroidUtils.dpToPx(this.getContext(), 20.0f);
        this.fontPaint.setAntiAlias(true);
        this.fontPaint.setTextSize(this.textSize);
        this.fontPaint.setStyle(Paint.Style.FILL);
        this.fontPaint.setTextAlign(Paint.Align.RIGHT);
        this.applyTheme();
    }

    public void applyTheme() {
        if (ChartView.THEME == 0) {
            if (this.chart.getChartLines().get(0).getType() == 1) {
                this.fontPaint.setColor(this.getResources().getColor(R.color.lineXText));
                this.fontAlpha = 1.0f;
            } else {
                this.fontPaint.setColor(this.getResources().getColor(R.color.barXText));
                this.fontAlpha = 0.5f;
            }
        } else if (this.chart.getChartLines().get(0).getType() == 1) {
            this.fontPaint.setColor(this.getResources().getColor(R.color.darkLineXText));
            this.fontAlpha = 0.6f;
        } else {
            this.fontPaint.setColor(this.getResources().getColor(R.color.darkBarXText));
            this.fontAlpha = 0.6f;
        }
    }

    public void updateScene(Scene scene) {
        this.scene = scene;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.scene != null && this.scene.getDates1() != null) {
            float percent = this.scene.getDatePercent();
            this.drawDates(canvas, this.scene.getDates1(), percent);
            this.drawDates(canvas, this.scene.getDates2(), 1.0f);
        }
    }

    private void drawDates(Canvas canvas, long[] dates, float percent) {
        if (this.scene != null) {
            this.fontPaint.setAlpha((int)(255.0f * percent * this.fontAlpha));
            for (int i = 0; i < dates.length; ++i) {
                this.date = this.df.format(dates[dates.length - i - 1]);
                canvas.drawText(this.date, this.getScreenX(dates[dates.length - 1 - i], this.scene) - this.horizontalPadding, this.verticalPadding, this.fontPaint);
            }
        }
    }

    private float getScreenX(long x, Scene scene) {
        return (float)((double)(x - scene.getMinX()) / (double)(scene.getMaxX() - scene.getMinX()) * (double)this.width);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.width = right - left;
        this.height = bottom - top;
    }
}

