/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.adi.lib.R;
import com.adi.lib.chart.BaseChartView;
import com.adi.lib.chart.ChartView;
import com.adi.lib.chart.entity.ChartLine;
import com.adi.lib.chart.entity.PickerDetails;
import com.adi.lib.chart.entity.Scene;
import com.adi.lib.utils.AndroidUtils;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class ChartPercentageStackedView
extends BaseChartView {
    private Paint paint = new Paint();
    private float[][] points;
    float minY;
    double sum;
    Path path = new Path();
    double lastYPosition;
    private boolean initialized = false;
    private Paint pickerLinePaint = new Paint(1);

    public ChartPercentageStackedView(Context context, boolean chartMode) {
        super(context, chartMode);
        this.init();
    }

    private void init() {
        this.paint.setStrokeWidth(AndroidUtils.dpToPx(this.getContext(), 1.0f));
        this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.paint.setAntiAlias(true);
        this.pickerLinePaint.setStrokeWidth(AndroidUtils.dpToPx(this.getContext(), 1.0f));
        this.pickerLinePaint.setStrokeCap(Paint.Cap.ROUND);
        this.pickerLinePaint.setStyle(Paint.Style.STROKE);
        this.applyTheme();
    }

    @Override
    public void applyTheme() {
        super.applyTheme();
        if (ChartView.THEME == 1) {
            this.pickerLinePaint.setColor(this.getResources().getColor(R.color.darkGridHorizontalLine));
        } else {
            this.pickerLinePaint.setColor(this.getResources().getColor(R.color.gridHorizontalLine));
        }
    }

    @Override
    void updateChartLines(List<ChartLine> chartLines) {
        super.updateChartLines(chartLines);
        this.initialized = false;
    }

    @Override
    void updateScene(Scene newScene) {
        super.updateScene(newScene);
        this.minY = this.height + this.topPadding;
        if (this.chartMode) {
            this.points = new float[this.chartLines.size()][(this.stop - this.start + 3) * 2];
            this.calculatePoints();
            this.postInvalidate(0, 0, (int)this.width, (int)this.height);
        } else if (!this.initialized) {
            this.points = new float[this.chartLines.size()][(this.stop - this.start + 3) * 2];
            this.calculatePoints();
            this.postInvalidate(0, 0, (int)this.width, (int)this.height);
            this.initialized = true;
        }
    }

    @Override
    void animateChart(float percent, float hm) {
        this.initialized = false;
        for (int i = this.start; i <= this.stop; ++i) {
            this.sum = 0.0;
            for (ChartLine chartLine : this.chartLines) {
                if (chartLine.isAnimationInProcess()) {
                    this.sum += chartLine.getY()[i] * (double)percent;
                    continue;
                }
                if (!chartLine.isVisible()) continue;
                this.sum += chartLine.getY()[i];
            }
            this.scene.getMaximums()[i] = this.sum;
        }
        this.calculatePointsForAnimation(percent);
        this.postInvalidate(0, 0, (int)this.width, (int)this.height);
    }

    private void calculatePoints() {
        this.i = this.start;
        while (this.i <= this.stop) {
            this.lastYPosition = 0.0;
            this.j = this.chartLines.size() - 1;
            while (this.j >= 0) {
                if (((ChartLine)this.chartLines.get(this.j)).isVisible()) {
                    this.lastYPosition += ((ChartLine)this.chartLines.get(this.j)).getY()[this.i];
                    this.points[this.j][(this.i - this.start) * 2] = this.getScreenX(this.xArray[this.i]);
                    this.points[this.j][(this.i - this.start) * 2 + 1] = this.getScreenY(this.lastYPosition, this.scene.getMinimums()[this.i], this.scene.getMaximums()[this.i]);
                }
                --this.j;
            }
            ++this.i;
        }
    }

    private void calculatePointsForAnimation(float percent) {
        this.i = this.start;
        while (this.i <= this.stop) {
            this.lastYPosition = 0.0;
            this.j = this.chartLines.size() - 1;
            while (this.j >= 0) {
                if (((ChartLine)this.chartLines.get(this.j)).isAnimationInProcess()) {
                    this.lastYPosition += ((ChartLine)this.chartLines.get(this.j)).getY()[this.i] * (double)percent;
                    this.points[this.j][(this.i - this.start) * 2] = this.getScreenX(this.xArray[this.i]);
                } else if (((ChartLine)this.chartLines.get(this.j)).isVisible()) {
                    this.lastYPosition += ((ChartLine)this.chartLines.get(this.j)).getY()[this.i];
                }
                this.points[this.j][(this.i - this.start) * 2 + 1] = this.getScreenY(this.lastYPosition, this.scene.getMinimums()[this.i], this.scene.getMaximums()[this.i]);
                --this.j;
            }
            ++this.i;
        }
    }

    @Override
    protected void calculateStartAndStopX() {
        super.calculateStartAndStopX();
        int count = (int)((float)this.horizontalPadding / this.gapInPixel);
        this.start = this.start - count - 1;
        if (this.start < 0) {
            this.start = 0;
        }
        if (this.stop != this.xArray.length - 1) {
            ++this.stop;
        }
    }

    @Override
    public void pick(PickerDetails pickerDetails) {
        super.pick(pickerDetails);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (this.chartLines != null && this.scene != null && this.scene.getMaximums() != null) {
            for (int i = 0; i < this.chartLines.size(); ++i) {
                this.paint.setColor(((ChartLine)this.chartLines.get(i)).getColor());
                if (this.animationInProcess) {
                    this.paint.setAlpha(((ChartLine)this.chartLines.get(i)).getAlpha());
                    this.drawChartLine(canvas, i);
                    continue;
                }
                this.paint.setAlpha(255);
                if (!((ChartLine)this.chartLines.get(i)).isVisible()) continue;
                this.drawChartLine(canvas, i);
            }
            if (this.picked) {
                this.pickerLinePaint.setAlpha(25);
                canvas.drawLine(this.getScreenX(this.pickerDetails.x), this.topPadding, this.getScreenX(this.pickerDetails.x), this.height + this.topPadding, this.pickerLinePaint);
            }
        }
    }

    private void drawChartLine(Canvas canvas, int index) {
        this.path.reset();
        this.i = this.start;
        while (this.i <= this.stop) {
            if (this.i == this.start) {
                this.path.moveTo((float)((int)this.points[index][(this.i - this.start) * 2]), (float)((int)this.points[index][(this.i - this.start) * 2 + 1]));
            }
            this.path.lineTo((float)((int)this.points[index][(this.i - this.start) * 2]), (float)((int)this.points[index][(this.i - this.start) * 2 + 1]));
            ++this.i;
        }
        this.path.lineTo(this.points[index][(this.stop - this.start) * 2], this.height + this.topPadding);
        this.path.lineTo(this.points[index][0], this.height + this.topPadding);
        this.path.lineTo(this.points[index][0], (float)((int)this.points[index][1]));
        canvas.drawPath(this.path, this.paint);
    }
}

