/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import com.adi.lib.R;
import com.adi.lib.chart.BaseChartView;
import com.adi.lib.chart.ChartView;
import com.adi.lib.chart.entity.ChartLine;
import com.adi.lib.chart.entity.PickerDetails;
import com.adi.lib.chart.entity.Scene;
import com.adi.lib.utils.AndroidUtils;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class ChartLinesView
extends BaseChartView {
    private Paint paint = new Paint(1);
    private Paint pickerLinePaint = new Paint(1);
    private Paint circlePaint = new Paint(1);
    private float[][] points;
    private boolean initialized;
    float circleBorderWidth;
    float circleRadius;
    float lineAlpha;

    public ChartLinesView(Context context, int lineWidth, boolean chartMode) {
        super(context, chartMode);
        this.init(lineWidth);
    }

    private void init(int lineWidth) {
        this.paint.setStrokeWidth(AndroidUtils.dpToPx(this.getContext(), lineWidth));
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStyle(Paint.Style.FILL);
        this.circleBorderWidth = AndroidUtils.dpToPx(this.getContext(), 2.0f);
        this.circleRadius = AndroidUtils.dpToPx(this.getContext(), 5.0f);
        this.circlePaint.setColor(-1);
        this.circlePaint.setStrokeWidth(2.0f);
        this.circlePaint.setStyle(Paint.Style.STROKE);
        this.pickerLinePaint.setStrokeWidth(AndroidUtils.dpToPx(this.getContext(), 1.0f));
        this.pickerLinePaint.setStrokeCap(Paint.Cap.ROUND);
        this.pickerLinePaint.setStyle(Paint.Style.STROKE);
        this.pickerLinePaint.setAlpha(25);
        this.applyTheme();
    }

    @Override
    public void applyTheme() {
        super.applyTheme();
        if (ChartView.THEME == 1) {
            this.pickerLinePaint.setColor(this.getResources().getColor(R.color.darkGridHorizontalLine));
            this.lineAlpha = 0.1f;
        } else {
            this.pickerLinePaint.setColor(this.getResources().getColor(R.color.gridHorizontalLine));
            this.lineAlpha = 0.1f;
        }
    }

    @Override
    void updateScene(Scene newScene) {
        super.updateScene(newScene);
        if (this.chartMode) {
            this.points = new float[this.chartLines.size()][(this.stop - this.start + 1) * 4];
            this.calculatePoints();
            this.postInvalidate(0, 0, (int)this.width, (int)this.height);
        } else if (!this.initialized) {
            this.points = new float[this.chartLines.size()][(this.stop - this.start + 1) * 4];
            this.calculatePoints();
            this.postInvalidate(0, 0, (int)this.width, (int)this.height);
            this.initialized = true;
        }
    }

    @Override
    void animateChart(float maxY, float minY) {
        if (this.chartMode) {
            Log.d((String)"ADIC", (String)("maxY: " + maxY + " minY: " + minY));
        }
        this.initialized = false;
        this.scene.setMaxY(maxY);
        this.scene.setMinY(minY);
        this.calculatePointsForAnimation();
        this.postInvalidate(0, 0, (int)this.width, (int)this.height);
    }

    @Override
    void updateChartLines(List<ChartLine> chartLines) {
        super.updateChartLines(chartLines);
        this.initialized = false;
    }

    private void calculatePoints() {
        this.j = 0;
        while (this.j < this.chartLines.size()) {
            this.i = this.start;
            while (this.i < this.stop) {
                this.points[this.j][(this.i - this.start) * 4] = this.getScreenX(this.xArray[this.i]);
                this.points[this.j][(this.i - this.start) * 4 + 1] = this.getScreenY(((ChartLine)this.chartLines.get(this.j)).getY()[this.i]);
                this.points[this.j][(this.i - this.start) * 4 + 2] = this.getScreenX(this.xArray[this.i + 1]);
                this.points[this.j][(this.i - this.start) * 4 + 3] = this.getScreenY(((ChartLine)this.chartLines.get(this.j)).getY()[this.i + 1]);
                ++this.i;
            }
            ++this.j;
        }
    }

    private void calculatePointsForAnimation() {
        this.j = 0;
        while (this.j < this.chartLines.size()) {
            if (this.chartMode || !((ChartLine)this.chartLines.get(this.j)).isAnimationInProcess()) {
                this.i = this.start;
                while (this.i < this.stop) {
                    this.points[this.j][(this.i - this.start) * 4 + 1] = this.getScreenY(((ChartLine)this.chartLines.get(this.j)).getY()[this.i]);
                    this.points[this.j][(this.i - this.start) * 4 + 3] = this.getScreenY(((ChartLine)this.chartLines.get(this.j)).getY()[this.i + 1]);
                    ++this.i;
                }
            }
            ++this.j;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.chartLines != null && this.scene != null && this.scene.getMaximums() != null) {
            int i;
            for (i = 0; i < this.chartLines.size(); ++i) {
                this.paint.setColor(((ChartLine)this.chartLines.get(i)).getColor());
                if (this.animationInProcess) {
                    this.paint.setAlpha(((ChartLine)this.chartLines.get(i)).getAlpha());
                    this.drawChartLine(canvas, i);
                    continue;
                }
                this.paint.setAlpha(255);
                if (!((ChartLine)this.chartLines.get(i)).isVisible()) continue;
                this.drawChartLine(canvas, i);
            }
            if (this.picked) {
                this.pickerLinePaint.setAlpha((int)(255.0f * this.lineAlpha));
                canvas.drawLine(this.getScreenX(this.pickerDetails.x), this.topPadding, this.getScreenX(this.pickerDetails.x), this.height + this.topPadding, this.pickerLinePaint);
                for (i = 0; i < this.chartLines.size(); ++i) {
                    if (!((ChartLine)this.chartLines.get(i)).isVisible()) continue;
                    ChartLinesView.fillCircleStrokeBorder(canvas, this.getScreenX(this.pickerDetails.x), this.getScreenY(this.pickerDetails.values[i]), this.circleRadius, -1, this.circleBorderWidth, ((ChartLine)this.chartLines.get(i)).getColor(), this.circlePaint);
                }
            }
        }
    }

    @Override
    protected void calculateStartAndStopX() {
        super.calculateStartAndStopX();
        int count = (int)((float)this.horizontalPadding / this.gapInPixel);
        this.start = this.start - count - 1;
        if (this.start < 0) {
            this.start = 0;
        }
        if (this.stop != this.xArray.length - 1) {
            ++this.stop;
        }
    }

    @Override
    public void pick(PickerDetails pickerDetails) {
        super.pick(pickerDetails);
        this.invalidate();
    }

    public static void fillCircleStrokeBorder(Canvas c, float cx, float cy, float radius, int circleColor, float borderWidth, int borderColor, Paint p) {
        int saveColor = p.getColor();
        p.setColor(circleColor);
        Paint.Style saveStyle = p.getStyle();
        p.setStyle(Paint.Style.FILL);
        c.drawCircle(cx, cy, radius, p);
        if (borderWidth > 0.0f) {
            p.setColor(borderColor);
            p.setStyle(Paint.Style.STROKE);
            float saveStrokeWidth = p.getStrokeWidth();
            p.setStrokeWidth(borderWidth);
            c.drawCircle(cx, cy, radius - borderWidth / 2.0f, p);
            p.setStrokeWidth(saveStrokeWidth);
        }
        p.setColor(saveColor);
        p.setStyle(saveStyle);
    }

    private void drawChartLine(Canvas canvas, int index) {
        canvas.drawLines(this.points[index], this.paint);
    }
}

