/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import com.adi.lib.chart.ChartCore;
import com.adi.lib.chart.ChartGridView;
import com.adi.lib.chart.ChartView;
import com.adi.lib.chart.entity.Chart;
import com.adi.lib.chart.entity.GridState;
import com.adi.lib.chart.entity.Scene;

class ChartGridAnimator {
    private ValueAnimator grid1ScaleAnimator = new ValueAnimator();
    private ValueAnimator grid1AlphaAnimator = new ValueAnimator();
    private ValueAnimator grid2ScaleAnimator = new ValueAnimator();
    private ValueAnimator grid2AlphaAnimator = new ValueAnimator();
    private ValueAnimator appearAnimator = new ValueAnimator();
    private AnimatorSet animatorSet = new AnimatorSet();
    private ChartGridView chartGreedView;
    private GridState grid1 = new GridState();
    private GridState grid2 = new GridState();
    private GridState scaledGrid1 = new GridState();
    private GridState scaledGrid2 = new GridState();
    private float maxDelta;
    private float minDelta;
    private Scene currentOldScene;
    private Scene currentNewScene;
    private Scene nextOldScene;
    private Scene nextNewScene;
    private Chart chart;
    private boolean appear;
    private boolean disappear;
    private Scene appearScene;
    private int visibleCount;
    private boolean sceneChanged;

    ChartGridAnimator() {
        this.appearAnimator.addUpdateListener(a -> {
            if (this.appear) {
                if (this.chart.isyScaled()) {
                    if (this.chart.getChartLines().get(this.appearScene.getNotScaledYIndex()).isVisible()) {
                        this.grid1.alpha = (Integer)a.getAnimatedValue();
                    } else {
                        this.scaledGrid1.alpha = (Integer)a.getAnimatedValue();
                    }
                } else {
                    this.grid1.alpha = (Integer)a.getAnimatedValue();
                }
            } else if (this.disappear) {
                if (this.chart.isyScaled()) {
                    if (this.chart.getChartLines().get(this.appearScene.getNotScaledYIndex()).isAnimationInProcess()) {
                        this.grid1.alpha = (Integer)a.getAnimatedValue();
                    } else {
                        this.scaledGrid1.alpha = (Integer)a.getAnimatedValue();
                    }
                } else {
                    this.grid1.alpha = (Integer)a.getAnimatedValue();
                }
            }
        });
        this.grid1ScaleAnimator.addUpdateListener(a -> {
            if (!this.appear && !this.disappear && this.visibleCount > 0) {
                if (this.chart.isyScaled()) {
                    this.grid1.scaleFactor = ((Float)a.getAnimatedValue()).floatValue();
                    this.scaledGrid1.scaleFactor = ((Float)a.getAnimatedValue()).floatValue();
                    this.chartGreedView.update(this.grid1, this.grid2, this.scaledGrid1, this.scaledGrid2);
                } else {
                    this.grid1.scaleFactor = ((Float)a.getAnimatedValue()).floatValue();
                    this.chartGreedView.update(this.grid1, this.grid2);
                }
            } else if (this.chart.isyScaled()) {
                this.chartGreedView.update(this.grid1, this.grid2, this.scaledGrid1, this.scaledGrid2);
            } else {
                this.chartGreedView.update(this.grid1, this.grid2);
            }
        });
        this.grid1AlphaAnimator.addUpdateListener(a -> {
            if (!this.appear && !this.disappear && this.visibleCount > 0) {
                if (this.chart.isyScaled()) {
                    this.grid1.alpha = this.chart.getChartLines().get(this.chartGreedView.scene.getNotScaledYIndex()).isVisible() ? (Integer)a.getAnimatedValue() : 0;
                    this.scaledGrid1.alpha = this.chart.getChartLines().get(this.chartGreedView.scene.getScaledYIndex()).isVisible() ? (Integer)a.getAnimatedValue() : 0;
                } else {
                    this.grid1.alpha = (Integer)a.getAnimatedValue();
                }
            }
        });
        this.grid2ScaleAnimator.addUpdateListener(a -> {
            if (!this.appear && !this.disappear && this.visibleCount > 0) {
                this.grid2.scaleFactor = ((Float)a.getAnimatedValue()).floatValue();
                if (this.chart.isyScaled()) {
                    this.scaledGrid2.scaleFactor = ((Float)a.getAnimatedValue()).floatValue();
                }
            }
        });
        this.grid2AlphaAnimator.addUpdateListener(a -> {
            if (!this.appear && !this.disappear && this.visibleCount > 0) {
                if (this.chart.isyScaled()) {
                    if (this.chart.getChartLines().get(this.chartGreedView.scene.getNotScaledYIndex()).isAnimationInProcess()) {
                        this.grid2.alpha = 0;
                    } else if (this.chart.getChartLines().get(this.chartGreedView.scene.getNotScaledYIndex()).isVisible()) {
                        this.grid2.alpha = (Integer)a.getAnimatedValue();
                    }
                    if (this.chart.getChartLines().get(this.chartGreedView.scene.getScaledYIndex()).isAnimationInProcess()) {
                        this.scaledGrid2.alpha = 0;
                    } else if (this.chart.getChartLines().get(this.chartGreedView.scene.getScaledYIndex()).isVisible()) {
                        this.scaledGrid2.alpha = (Integer)a.getAnimatedValue();
                    }
                } else {
                    this.grid2.alpha = (Integer)a.getAnimatedValue();
                }
            }
        });
        this.animatorSet.setDuration((long)ChartView.ANIMATOR_DURATION);
        this.animatorSet.playTogether(new Animator[]{this.grid1ScaleAnimator, this.grid1AlphaAnimator, this.grid2ScaleAnimator, this.grid2AlphaAnimator, this.appearAnimator});
        this.animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (ChartGridAnimator.this.nextOldScene != null && ChartGridAnimator.this.nextNewScene != null) {
                    ChartGridAnimator.this.currentOldScene = ChartGridAnimator.this.nextOldScene;
                    ChartGridAnimator.this.currentNewScene = ChartGridAnimator.this.nextNewScene;
                    ChartGridAnimator.this.nextOldScene = null;
                    ChartGridAnimator.this.nextNewScene = null;
                    ChartGridAnimator.this.process();
                }
            }
        });
    }

    void disappear(ChartGridView chartGreedView, Scene scene, Chart chart) {
        this.chartGreedView = chartGreedView;
        this.appearScene = scene;
        this.chart = chart;
        this.disappear = true;
        this.appear = false;
        this.appearAnimator.setIntValues(new int[]{255, 0});
        this.grid1AlphaAnimator.setIntValues(new int[]{255, 255});
        this.grid2AlphaAnimator.setIntValues(new int[]{255, 255});
        this.grid1ScaleAnimator.setFloatValues(new float[]{1.0f, 1.0f});
        this.grid2ScaleAnimator.setFloatValues(new float[]{1.0f, 1.0f});
        if (chart.isyScaled()) {
            if (chart.getChartLines().get(scene.getNotScaledYIndex()).isAnimationInProcess()) {
                this.grid1.set(scene.getMinY(), scene.getMaxY(), 255, 1.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
                this.grid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
                this.scaledGrid1.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
                this.scaledGrid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
            } else {
                this.scaledGrid1.set(scene.getMinY(), scene.getMaxY(), 255, 1.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
                this.scaledGrid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
                this.grid1.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
                this.grid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
            }
        } else {
            this.grid1.set(scene.getMinY(), scene.getMaxY(), 255, 1.0f, false);
            this.grid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false);
        }
        this.animatorSet.start();
    }

    void appear(ChartGridView chartGreedView, Scene scene, Chart chart) {
        this.chartGreedView = chartGreedView;
        this.appearScene = scene;
        this.chart = chart;
        this.appear = true;
        this.disappear = false;
        this.appearAnimator.setIntValues(new int[]{0, 255});
        this.grid1AlphaAnimator.setIntValues(new int[]{255, 255});
        this.grid2AlphaAnimator.setIntValues(new int[]{255, 255});
        this.grid1ScaleAnimator.setFloatValues(new float[]{1.0f, 1.0f});
        this.grid2ScaleAnimator.setFloatValues(new float[]{1.0f, 1.0f});
        if (chart.isyScaled()) {
            if (chart.getChartLines().get(scene.getNotScaledYIndex()).isAnimationInProcess()) {
                this.grid1.set(scene.getMinY(), scene.getMaxY(), 0, 1.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
                this.grid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
                this.scaledGrid1.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
                this.scaledGrid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
            } else {
                this.scaledGrid1.set(scene.getMinY(), scene.getMaxY(), 0, 1.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
                this.scaledGrid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
                this.grid1.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
                this.grid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
            }
        } else {
            this.grid1.set(scene.getMinY(), scene.getMaxY(), 0, 1.0f, false);
            this.grid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false);
        }
        this.animatorSet.start();
    }

    synchronized void animate(ChartGridView chartGreedView, Scene scene1, Scene scene2, Chart chart) {
        this.visibleCount = ChartCore.getVisibleChartLinesCount(chart.getChartLines());
        this.chartGreedView = chartGreedView;
        this.appear = false;
        this.disappear = false;
        this.chart = chart;
        if (this.animatorSet.isRunning()) {
            this.nextOldScene = scene1;
            this.nextNewScene = scene2;
        } else {
            this.currentOldScene = scene1;
            this.currentNewScene = scene2;
            this.nextOldScene = null;
            this.nextNewScene = null;
            this.process();
        }
    }

    private void process() {
        this.appearAnimator.setIntValues(new int[]{255, 255});
        this.grid1AlphaAnimator.setIntValues(new int[]{0, 255});
        this.grid2AlphaAnimator.setIntValues(new int[]{255, 0});
        this.grid1.set(this.currentNewScene.getMinY(), this.currentNewScene.getMaxY());
        this.grid2.set(this.currentOldScene.getMinY(), this.currentOldScene.getMaxY());
        if (this.chart.isyScaled()) {
            this.scaledGrid1.set(this.currentNewScene.getMinY(), this.currentNewScene.getMaxY(), true);
            this.scaledGrid2.set(this.currentOldScene.getMinY(), this.currentOldScene.getMaxY(), true);
            this.grid1.color = this.chart.getChartLines().get(this.chartGreedView.scene.getNotScaledYIndex()).getColor();
            this.grid2.color = this.chart.getChartLines().get(this.chartGreedView.scene.getNotScaledYIndex()).getColor();
            this.scaledGrid1.color = this.chart.getChartLines().get(this.chartGreedView.scene.getScaledYIndex()).getColor();
            this.scaledGrid2.color = this.chart.getChartLines().get(this.chartGreedView.scene.getScaledYIndex()).getColor();
        }
        this.minDelta = (float)(this.currentNewScene.getMinY() - this.currentOldScene.getMinY());
        this.maxDelta = (float)(this.currentNewScene.getMaxY() - this.currentOldScene.getMaxY());
        boolean bl = this.sceneChanged = this.minDelta != 0.0f || this.maxDelta != 0.0f;
        if (Math.abs(this.maxDelta) >= Math.abs(this.minDelta)) {
            this.animateMaxYChange(this.maxDelta);
        } else {
            this.animateMinYChange(this.minDelta);
        }
        this.animatorSet.start();
    }

    private void animateMinYChange(float minDelta) {
        this.grid1.greedCenter = -1.0f;
        this.grid2.greedCenter = -1.0f;
        if (this.chart.isyScaled()) {
            this.scaledGrid1.greedCenter = -1.0f;
            this.scaledGrid2.greedCenter = -1.0f;
        }
        if (minDelta < 0.0f) {
            this.grid1ScaleAnimator.setFloatValues(new float[]{2.0f, 1.0f});
            this.grid2ScaleAnimator.setFloatValues(new float[]{1.0f, 0.7f});
        } else {
            this.grid1ScaleAnimator.setFloatValues(new float[]{0.7f, 1.0f});
            this.grid2ScaleAnimator.setFloatValues(new float[]{1.0f, 2.0f});
        }
    }

    private void animateMaxYChange(float maxDelta) {
        this.grid1.greedCenter = 1.0f;
        this.grid2.greedCenter = 1.0f;
        if (this.chart.isyScaled()) {
            this.scaledGrid1.greedCenter = 1.0f;
            this.scaledGrid2.greedCenter = 1.0f;
        }
        if (maxDelta < 0.0f) {
            this.grid1ScaleAnimator.setFloatValues(new float[]{0.0f, 1.0f});
            this.grid2ScaleAnimator.setFloatValues(new float[]{1.0f, 2.0f});
        } else {
            this.grid1ScaleAnimator.setFloatValues(new float[]{2.0f, 1.0f});
            this.grid2ScaleAnimator.setFloatValues(new float[]{1.0f, 0.0f});
        }
    }
}

