/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import com.adi.lib.chart.entity.Chart;
import com.adi.lib.chart.entity.ChartLine;
import com.adi.lib.chart.entity.Extremum;
import com.adi.lib.chart.entity.Interval;
import com.adi.lib.chart.entity.Scene;
import com.adi.lib.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class ChartCore {
    private static int MIN_DISTANCE_BETWEEN_PEAKS = 20;
    public static int CHART_PARTS_COUNT = 6;

    ChartCore() {
    }

    Scene initializeScene(Chart chart) {
        Scene scene = new Scene();
        long minX = chart.getChartLines().get(0).getX()[0];
        long maxX = chart.getChartLines().get(0).getX()[chart.getChartLines().get(0).getX().length - 1];
        if (chart.isyScaled()) {
            this.scale(scene, chart.getChartLines());
        }
        scene.setMinSliderWidth((maxX - minX) / (long)CHART_PARTS_COUNT);
        this.updateSceneY(chart, scene);
        this.updateSceneX(chart, scene, chart.getChartLines().get(0).getX()[0], chart.getChartLines().get(0).getX()[chart.getChartLines().get(0).getX().length - 1], false);
        return scene;
    }

    private void scale(Scene scene, List<ChartLine> chartLines) {
        int i;
        double[] chartMaxYs = new double[chartLines.size()];
        for (int i2 = 0; i2 < chartLines.size(); ++i2) {
            chartMaxYs[i2] = ArrayUtils.max(chartLines.get(i2).getY());
        }
        int maxPosition = 0;
        double max = chartMaxYs[0];
        for (i = 1; i < chartMaxYs.length; ++i) {
            if (!(chartMaxYs[i] > max)) continue;
            maxPosition = i;
            max = chartMaxYs[i];
        }
        for (i = 0; i < chartLines.size(); ++i) {
            if (i != maxPosition) {
                float scaleFactor = (float)(max / chartMaxYs[i]);
                scene.setyScaleFactor(scaleFactor);
                this.scaleChartLine(chartLines.get(i), scaleFactor);
                scene.setScaledYIndex(i);
                continue;
            }
            scene.setNotScaledYIndex(i);
        }
    }

    private void scaleChartLine(ChartLine chartLine, float scaleFactor) {
        for (int i = 0; i < chartLine.getY().length; ++i) {
            chartLine.getY()[i] = chartLine.getY()[i] * (double)scaleFactor;
        }
    }

    void updateSceneY(Chart chart, Scene scene) {
        if (ChartCore.getVisibleChartLinesCount(chart.getChartLines()) != 0) {
            this.calculateYMaxMin(chart, scene, 0);
            this.calculateYMaxMin(chart, scene, 1);
        }
    }

    void updateSceneX(Chart chart, Scene scene, long minX, long maxX, boolean calculateXAxis) {
        scene.setMinX(minX);
        scene.setMaxX(maxX);
        if (scene.getMaximums() != null) {
            long[] xArray = chart.getChartLines().get(0).getX();
            double[] yArray = scene.getMaximums();
            if (!chart.isPercentage()) {
                this.calculateYAxis(scene, xArray, yArray, minX, maxX);
            } else {
                scene.setMaxY(100.0);
            }
            if (calculateXAxis) {
                this.calculateXAxis(scene, xArray, minX, maxX);
            }
        }
    }

    private long[] getIntervals(long[] xArray, long minX, long maxX) {
        double interval = (double)(maxX - minX) / 6.0;
        int count = (int)Math.ceil((double)(xArray[xArray.length - 1] - xArray[0]) / interval) + 1;
        long[] intervals = new long[count];
        for (int i = 0; i < count; ++i) {
            long nextVal;
            intervals[count - i - 1] = nextVal = (long)((double)xArray[xArray.length - 1] - (double)i * interval);
        }
        return intervals;
    }

    private long[] getXChangePoints(long[] xArray, long minSliderWidth) {
        int count = (int)Math.ceil((double)(xArray[xArray.length - 1] - xArray[0]) / (double)minSliderWidth);
        long[] points = new long[count + 1];
        for (int i = 0; i <= count; ++i) {
            long nextVal;
            points[i] = nextVal = (long)i * minSliderWidth;
        }
        return points;
    }

    private void calculateXAxis(Scene scene, long[] xArray, long minX, long maxX) {
        if (scene.getXChangePoints() == null) {
            scene.setXChangePoints(this.getXChangePoints(xArray, scene.getMinSliderWidth()));
        }
        if (scene.getXArray() == null) {
            scene.setXArray(this.getIntervals(xArray, xArray[xArray.length - 1] - scene.getMinSliderWidth(), xArray[xArray.length - 1]));
        }
        long[] intervals = scene.getXArray();
        long width = maxX - minX;
        long[] changePoints = scene.getXChangePoints();
        long p1 = 0L;
        long p2 = 0L;
        for (int i = 0; i < changePoints.length - 1; ++i) {
            p1 = changePoints[i];
            p2 = changePoints[i + 1];
            if (width > p1 && width <= p2) break;
        }
        float persent = p1 == 0L ? 1.0f : 1.0f - (float)(((double)width - (double)p1) / ((double)p2 - (double)p1));
        for (int i = 0; i < changePoints.length; ++i) {
            int j;
            if (changePoints[i] <= scene.getMinSliderWidth() || changePoints[i] > width) continue;
            int count = 0;
            for (j = 0; j < intervals.length; ++j) {
                if (j % 2 != 0) continue;
                ++count;
            }
            long[] newIntervals = new long[count];
            int idx = 0;
            for (j = 0; j < intervals.length; ++j) {
                if (j % 2 != 0) continue;
                newIntervals[count - idx - 1] = intervals[intervals.length - 1 - j];
                ++idx;
            }
            if ((float)i >= (float)changePoints.length / 2.0f) {
                persent = 1.0f;
            }
            if (!((float)i < (float)changePoints.length / 2.0f + 1.0f)) continue;
            intervals = newIntervals;
        }
        scene.setDatePercent(persent);
        float length = (float)intervals.length / 2.0f;
        long[] scene1 = new long[(int)Math.floor(length)];
        long[] scene2 = new long[(int)Math.ceil(length)];
        int idx1 = 0;
        int idx2 = 0;
        for (int i = 0; i < intervals.length; ++i) {
            if (i % 2 == 0) {
                scene2[idx2] = intervals[i];
                ++idx2;
                continue;
            }
            scene1[idx1] = intervals[i];
            ++idx1;
        }
        if (scene1[scene1.length - 1] == xArray[xArray.length - 1]) {
            scene.setDates1(scene2);
            scene.setDates2(scene1);
        } else {
            scene.setDates1(scene1);
            scene.setDates2(scene2);
        }
    }

    private void calculateYAxis(Scene scene, long[] xArray, double[] yArray, long minX, long maxX) {
        float maxY = (float)ArrayUtils.getMaxYFromXRange(xArray, scene.getMaximums(), minX, maxX);
        float minY = (float)ArrayUtils.getMinYFromXRange(xArray, scene.getMinimums(), minX, maxX);
        scene.setMinY(minY);
        scene.setMaxY(maxY);
    }

    private void setMinY(Scene scene, double[] yArray, int start, int stop) {
        scene.setMinY(ArrayUtils.min(Arrays.copyOfRange(yArray, start, stop)));
    }

    private void calculateYMaxMin(Chart chart, Scene scene, int type) {
        double[] yArray = type == 0 ? this.getGlobalYMaximums(chart) : this.getGlobalYMinimums(chart);
        if (!chart.isPercentage()) {
            this.extremumFilter(chart, yArray, type);
            List<Interval> intervals = this.getIntervals(yArray);
            if (type == 0) {
                scene.setMaxIntervals(intervals);
            } else {
                scene.setMinIntervals(intervals);
            }
            this.noiseFilter(yArray, intervals, type);
        } else {
            scene.setMaxIntervals(new ArrayList<Interval>());
            scene.setMinIntervals(new ArrayList<Interval>());
        }
        if (type == 0) {
            scene.setMaximums(yArray);
        } else {
            scene.setMinimums(yArray);
        }
    }

    private List<Interval> getIntervals(double[] array) {
        double minDeltaThreshold = ArrayUtils.max(array) / 10.0;
        double[] delta = ArrayUtils.getDelta(array);
        ArrayUtils.round(delta);
        double current = delta[0];
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        Interval interval = new Interval();
        interval.start = 0;
        interval.delta = 0.0;
        for (int i = 1; i < delta.length; ++i) {
            if (delta[i] != current) {
                interval.stop = i - 1;
                intervals.add(interval);
                interval = new Interval();
                interval.start = i;
                interval.delta += delta[i];
            } else {
                interval.delta += delta[i];
            }
            current = delta[i];
            if (i != delta.length - 1) continue;
            interval.stop = i;
            intervals.add(interval);
        }
        ArrayList<Interval> cleanIntervals = new ArrayList<Interval>();
        for (Interval nextInterval : intervals) {
            if (!(Math.abs(array[nextInterval.stop] - array[nextInterval.start]) > minDeltaThreshold) || nextInterval.stop - nextInterval.start <= 5 || ChartCore.roundDouble(array[nextInterval.start]) == ChartCore.roundDouble(array[nextInterval.stop])) continue;
            cleanIntervals.add(nextInterval);
        }
        return cleanIntervals;
    }

    private void noiseFilter(double[] array, List<Interval> intervals, int type) {
        int lastPosition = 0;
        for (int i = 0; i < intervals.size(); ++i) {
            int j;
            Interval interval = intervals.get(i);
            double targetVal = type == 0 ? ArrayUtils.max(array, lastPosition, interval.start) : ArrayUtils.min(array, lastPosition, interval.start);
            for (j = lastPosition; j <= interval.start; ++j) {
                array[j] = targetVal;
            }
            lastPosition = interval.stop;
            if (i != intervals.size() - 1) continue;
            targetVal = type == 0 ? ArrayUtils.max(array, interval.stop, array.length - 1) : ArrayUtils.min(array, interval.stop, array.length - 1);
            for (j = interval.stop; j <= array.length - 1; ++j) {
                array[j] = targetVal;
            }
        }
        for (Interval nextInterval : intervals) {
            ArrayUtils.makeInterpolation(array, nextInterval.start, nextInterval.stop);
        }
        ArrayUtils.round(array);
    }

    private void windowFilter(int windowSize, double[] yArray, int type) {
        double[] result = new double[yArray.length];
        int startPosition = 0;
        int endPosition = windowSize;
        while (endPosition <= yArray.length - 1) {
            double y = type == 0 ? ArrayUtils.max(yArray, startPosition, endPosition) : ArrayUtils.min(yArray, startPosition, endPosition);
            if (startPosition == 0) {
                for (int i = startPosition; i <= endPosition; ++i) {
                    result[i] = y;
                }
            } else {
                result[endPosition] = y;
            }
            ++endPosition;
            ++startPosition;
        }
        System.arraycopy(result, 0, yArray, 0, yArray.length);
    }

    private void extremumFilter(Chart chart, double[] yArray, int type) {
        List<Extremum> extremums = this.getExtremums(yArray);
        ArrayList<Extremum> sortedExtremums = new ArrayList<Extremum>(extremums);
        if (type == 0) {
            Collections.sort(sortedExtremums, (p1, p2) -> Double.compare(p2.value, p1.value));
        } else {
            Collections.sort(sortedExtremums, (p1, p2) -> Double.compare(p1.value, p2.value));
        }
        List<Extremum> cleanExtremums = this.getCleanExtremums(sortedExtremums, extremums);
        boolean collisionExist = true;
        while (collisionExist) {
            int i;
            Collections.sort(cleanExtremums, (p1, p2) -> Integer.compare(p1.index, p2.index));
            cleanExtremums.get((int)0).startPosition = 0;
            cleanExtremums.get((int)(cleanExtremums.size() - 1)).endPosition = extremums.size() - 1;
            for (i = 0; i < cleanExtremums.size() - 1; ++i) {
                int j;
                Extremum p12 = cleanExtremums.get(i);
                Extremum p22 = cleanExtremums.get(i + 1);
                yArray[p12.index] = p12.value;
                yArray[p22.index] = p22.value;
                ArrayUtils.makeInterpolation(yArray, p12.index, p22.index);
                if (i == 0) {
                    for (j = p12.startPosition; j <= p12.index; ++j) {
                        yArray[j] = p12.value;
                    }
                }
                if (i != cleanExtremums.size() - 2) continue;
                for (j = p22.index; j < p22.endPosition; ++j) {
                    yArray[j] = p22.value;
                }
            }
            collisionExist = false;
            if (type == 0) {
                block4: for (i = 0; i < yArray.length; ++i) {
                    for (ChartLine chartLine : chart.getChartLines()) {
                        if (!chartLine.isVisible()) continue;
                        if (collisionExist) continue block4;
                        if (!(chartLine.getY()[i] > yArray[i])) continue;
                        collisionExist = true;
                        cleanExtremums.add(new Extremum(i, i, i, chartLine.getY()[i]));
                        continue block4;
                    }
                }
                continue;
            }
            block6: for (i = 0; i < yArray.length; ++i) {
                for (ChartLine chartLine : chart.getChartLines()) {
                    if (!chartLine.isVisible()) continue;
                    if (collisionExist) continue block6;
                    if (!(chartLine.getY()[i] < yArray[i])) continue;
                    collisionExist = true;
                    cleanExtremums.add(new Extremum(i, i, i, chartLine.getY()[i]));
                    continue block6;
                }
            }
        }
    }

    private double[] getGlobalYMaximums(Chart chart) {
        double[] yMaximums = new double[chart.getChartLines().get(0).getX().length];
        if (chart.isStacked() || chart.isPercentage()) {
            for (int i = 0; i < chart.getChartLines().get(0).getX().length; ++i) {
                double maxY = 0.0;
                for (ChartLine chartLine : chart.getChartLines()) {
                    if (!chartLine.isVisible()) continue;
                    maxY += chartLine.getY()[i];
                }
                yMaximums[i] = maxY;
            }
        } else {
            for (int i = 0; i < chart.getChartLines().get(0).getX().length; ++i) {
                double maxY = Double.MIN_VALUE;
                for (ChartLine chartLine : chart.getChartLines()) {
                    if (!chartLine.isVisible() || !(chartLine.getY()[i] > maxY)) continue;
                    maxY = chartLine.getY()[i];
                }
                yMaximums[i] = maxY;
            }
        }
        return yMaximums;
    }

    private double[] getGlobalYMinimums(Chart chart) {
        double[] minimums = new double[chart.getChartLines().get(0).getX().length];
        if (chart.isStacked() || chart.getChartLines().get(0).getType() == 2) {
            for (int i = 0; i < chart.getChartLines().get(0).getX().length; ++i) {
                minimums[i] = 0.0;
            }
        } else {
            for (int i = 0; i < chart.getChartLines().get(0).getX().length; ++i) {
                double minY = Double.MAX_VALUE;
                for (ChartLine chartLine : chart.getChartLines()) {
                    if (!chartLine.isVisible() || !(chartLine.getY()[i] < minY)) continue;
                    minY = chartLine.getY()[i];
                }
                minimums[i] = minY;
            }
        }
        return minimums;
    }

    private List<Extremum> getCleanExtremums(List<Extremum> sortedPeaks, List<Extremum> peaks) {
        ArrayList<Extremum> cleanExtremums = new ArrayList<Extremum>();
        while (sortedPeaks.size() != 0) {
            Extremum peak = sortedPeaks.get(0);
            cleanExtremums.add(peak);
            sortedPeaks.remove(peak);
            for (Extremum nextPeak : peaks) {
                if ((nextPeak.startPosition < peak.startPosition || nextPeak.startPosition > peak.endPosition) && (nextPeak.endPosition < peak.startPosition || nextPeak.endPosition > peak.endPosition)) continue;
                sortedPeaks.remove(nextPeak);
            }
        }
        return cleanExtremums;
    }

    private List<Extremum> getExtremums(double[] y) {
        ArrayList<Extremum> peaks = new ArrayList<Extremum>();
        for (int i = 0; i < y.length; ++i) {
            int endPosition;
            int startPosition = i - MIN_DISTANCE_BETWEEN_PEAKS;
            if (startPosition < 0) {
                startPosition = 0;
            }
            if ((endPosition = i + MIN_DISTANCE_BETWEEN_PEAKS) > y.length + 1) {
                endPosition = y.length + 1;
            }
            peaks.add(new Extremum(i, startPosition, endPosition, y[i]));
        }
        return peaks;
    }

    static int[] getGridNumbers(double minY, double maxY, float count) {
        minY = ChartCore.roundDouble(minY);
        int[] result = new int[(int)(count + 1.0f)];
        double step = Math.floor((maxY - minY) / (double)count);
        int roundStep = ChartCore.roundDouble(step);
        int i = 0;
        while ((float)i <= count) {
            result[i] = (int)(minY + (double)(roundStep * i));
            ++i;
        }
        return result;
    }

    static String numberToString(int number) {
        if (number > 1000000) {
            return number / 1000000 + "M";
        }
        return number + "";
    }

    static int[] maxYToGreedNumbers(double maxY, float count) {
        int[] result = new int[(int)(count + 1.0f)];
        double step = Math.floor(maxY / (double)count);
        int roundStep = ChartCore.roundDouble(step);
        int i = 0;
        while ((float)i <= count) {
            result[i] = roundStep * i;
            ++i;
        }
        return result;
    }

    public static int roundDouble(double val) {
        int round = 1;
        if (val >= 600000.0) {
            round = 100000;
        } else if (val >= 60000.0 && val < 600000.0) {
            round = 10000;
        } else if (val >= 6000.0 && val <= 60000.0) {
            round = 1000;
        } else if (val >= 600.0 && val <= 6000.0) {
            round = 100;
        } else if (val >= 100.0 && val <= 600.0) {
            round = 10;
        }
        return ((int)val + round / 2) / round * round;
    }

    public static int getVisibleChartLinesCount(List<ChartLine> chartLines) {
        int i = 0;
        for (ChartLine chartLine : chartLines) {
            if (!chartLine.isVisible()) continue;
            ++i;
        }
        return i;
    }
}

