/*
 * Decompiled with CFR 0.152.
 */
package com.adi.lib.chart;

import android.content.Context;
import android.view.View;
import com.adi.lib.chart.entity.ChartLine;
import com.adi.lib.chart.entity.PickerDetails;
import com.adi.lib.chart.entity.Scene;
import java.util.List;

abstract class BaseChartView
extends View {
    protected boolean animationInProcess;
    protected Scene scene;
    protected List<ChartLine> chartLines;
    protected long[] xArray;
    protected long gap;
    protected float gapInPixel;
    protected int start;
    protected int stop;
    protected long minX;
    protected long maxX;
    protected int j;
    protected int i;
    protected float height;
    protected float width;
    protected long horizontalPaddingInPercent;
    protected int horizontalPadding;
    protected float topPadding = 0.0f;
    protected boolean chartMode;
    protected boolean picked;
    protected PickerDetails pickerDetails;

    public void pick(PickerDetails pickerDetails) {
        this.pickerDetails = pickerDetails;
        this.picked = true;
    }

    public void clearPick() {
        this.picked = false;
    }

    public void applyTheme() {
    }

    public BaseChartView(Context context, boolean chartMode) {
        super(context);
        this.chartMode = chartMode;
    }

    void updateChartLines(List<ChartLine> chartLines) {
        this.chartLines = chartLines;
        this.xArray = chartLines.get(0).getX();
        this.gap = this.xArray[1] - this.xArray[0];
    }

    void updateScene(Scene newScene) {
        this.scene = newScene;
        this.horizontalPaddingInPercent = (long)((double)(this.scene.getMaxX() - this.scene.getMinX()) * (double)this.horizontalPadding / (double)this.width);
        this.minX = this.scene.getMinX() - this.horizontalPaddingInPercent;
        this.maxX = this.scene.getMaxX() + this.horizontalPaddingInPercent;
        this.gapInPixel = this.getScreenX(this.xArray[1]) - this.getScreenX(this.xArray[0]);
        this.calculateStartAndStopX();
    }

    abstract void animateChart(float var1, float var2);

    public void animateChartPercent(float percent) {
    }

    public Scene getScene() {
        return this.scene;
    }

    public void setAnimationInProcess(boolean animationInProcess) {
        this.animationInProcess = animationInProcess;
    }

    protected void calculateStartAndStopX() {
        this.start = -1;
        this.stop = -1;
        if (this.maxX >= this.xArray[this.xArray.length - 1]) {
            this.stop = this.xArray.length - 1;
        }
        if (this.minX <= this.xArray[0]) {
            this.start = 0;
        }
        if (this.start != -1 && this.stop != -1) {
            return;
        }
        this.i = 0;
        while (this.i < this.xArray.length) {
            if (this.xArray[this.i] + this.gap >= this.scene.getMinX() && this.start == -1) {
                this.start = this.i;
            }
            if (this.xArray[this.i] >= this.maxX) {
                if (this.xArray[this.i] == this.maxX && this.i != this.xArray.length - 1) {
                    if (this.stop == -1) {
                        this.stop = this.i + 1;
                        break;
                    }
                } else if (this.stop == -1) {
                    this.stop = this.i;
                    break;
                }
            }
            ++this.i;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.width = right - left;
        this.height = (float)(bottom - top) - this.topPadding;
    }

    public void setTopPadding(float topPadding) {
        this.topPadding = topPadding;
    }

    public void setHorizontalPadding(int horizontalPadding) {
        this.horizontalPadding = horizontalPadding;
    }

    float getScreenX(long x) {
        return (float)(x - this.minX) / (float)(this.maxX - this.minX) * this.width;
    }

    float getScreenX(long x, long minX, long maxX) {
        return (float)((double)(x - minX) / (double)(maxX - minX) * (double)this.width);
    }

    float getScreenY(double y) {
        return (float)((double)this.height - (y - this.scene.getMinY()) / (this.scene.getMaxY() - this.scene.getMinY()) * (double)this.height) + this.topPadding;
    }

    float getScreenY(double y, double minY, double maxY) {
        return (float)((double)this.height - (y - minY) / (maxY - minY) * (double)this.height) + this.topPadding;
    }
}

