package com.adi.lib.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

import com.adi.lib.R;
import com.adi.lib.chart.Settings;

public class AndroidUtils {
    public static float dpToPx(Context context, float dp) {
        return dp * context.getResources().getDisplayMetrics().density;
    }

    public static void changeSystemColor(AppCompatActivity activity, Toolbar toolbar, Menu menu) {
        int colorPrimary;
        int toolbarTextColor;
        if (Settings.theme == R.style.AppTheme) {
            colorPrimary = ContextCompat.getColor(activity, R.color.colorPrimary);
            toolbarTextColor = ContextCompat.getColor(activity, R.color.toolbarTextColor);
            menu.getItem(0).setIcon(ContextCompat.getDrawable(activity, R.drawable.ic_brightness_2_gray_36dp));
        } else {
            colorPrimary = ContextCompat.getColor(activity, R.color.darkColorPrimary);
            toolbarTextColor = ContextCompat.getColor(activity, R.color.darkToolbarTextColor);
            menu.getItem(0).setIcon(ContextCompat.getDrawable(activity, R.drawable.ic_brightness_2_white_36dp));
        }
        setStatusBarColor(activity);
        if (activity.getSupportActionBar() != null) {
            activity.getSupportActionBar().setBackgroundDrawable(new ColorDrawable(colorPrimary));
            toolbar.setTitleTextColor(toolbarTextColor);
        }
    }

    public static void setStatusBarColor(Activity activity) {
        int colorPrimaryDark;
        int colorPrimaryDarkSupported;
        if (Settings.theme == R.style.AppTheme) {
            colorPrimaryDark = ContextCompat.getColor(activity, R.color.colorPrimaryDark);
            colorPrimaryDarkSupported = ContextCompat.getColor(activity, R.color.colorPrimaryDarkSupported);
        } else {
            colorPrimaryDark = ContextCompat.getColor(activity, R.color.darkColorPrimaryDark);
            colorPrimaryDarkSupported = ContextCompat.getColor(activity, R.color.darkColorPrimaryDarkSupported);
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Window window = activity.getWindow();
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                window.setStatusBarColor(colorPrimaryDark);
                if (Settings.theme == R.style.AppTheme) {
                    window.getDecorView().setSystemUiVisibility(window.getDecorView().getSystemUiVisibility() | View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);

                } else {
                    window.getDecorView().setSystemUiVisibility(window.getDecorView().getSystemUiVisibility() & ~View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
                }
            } else {
                window.setStatusBarColor(colorPrimaryDarkSupported);
            }


        }
    }
}
