package com.adi.lib.chart.entity;


import java.util.ArrayList;
import java.util.List;

public class Scene implements Cloneable {
    private long minX, maxX; //min and max slider position
    private double maxY, minY;
    private double[] maximums;
    private double[] minimums;
    private List<Interval> maxIntervals;
    private List<Interval> minIntervals;
    private long dates1[];
    private long dates2[];
    private float datePercent;
    private long[] xChangePoints;
    private long[] xArray;
    private long minSliderWidth;
    private int moveDirection = 0; //0-left 1 - right
    private float yScaleFactor;
    private int scaledYIndex;
    private int notScaledYIndex;

    public Scene() {
    }

    public long getMinX() {
        return minX;
    }

    public void setMinX(long minX) {
        this.minX = minX;
    }

    public long getMaxX() {
        return maxX;
    }

    public void setMaxX(long maxX) {
        this.maxX = maxX;
    }

    public double getMaxY() {
        return maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public double[] getMaximums() {
        return maximums;
    }

    public void setMaximums(double[] yMaximums) {
        this.maximums = yMaximums;
    }

    public List<Interval> getMaxIntervals() {
        return maxIntervals;
    }

    public void setMaxIntervals(List<Interval> maxIntervals) {
        this.maxIntervals = maxIntervals;
    }

    public long[] getDates1() {
        return dates1;
    }

    public void setDates1(long[] dates1) {
        this.dates1 = dates1;
    }

    public long[] getDates2() {
        return dates2;
    }

    public void setDates2(long[] dates2) {
        this.dates2 = dates2;
    }

    public float getDatePercent() {
        return datePercent;
    }

    public void setDatePercent(float datePercent) {
        this.datePercent = datePercent;
    }


    public long[] getXChangePoints() {
        return xChangePoints;
    }

    public void setXChangePoints(long[] xChangePoints) {
        this.xChangePoints = xChangePoints;
    }

    public long[] getXArray() {
        return xArray;
    }

    public void setXArray(long[] xArray) {
        this.xArray = xArray;
    }

    public long getMinSliderWidth() {
        return minSliderWidth;
    }

    public void setMinSliderWidth(long minSliderWidth) {
        this.minSliderWidth = minSliderWidth;
    }

    public Scene copy() {
        try {
            Scene scene = (Scene) this.clone();
            scene.maxIntervals = new ArrayList<>(this.maxIntervals);
            return scene;
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getMoveDirection() {
        return moveDirection;
    }

    public void setMoveDirection(int moveDirection) {
        this.moveDirection = moveDirection;
    }

    public float getyScaleFactor() {
        return yScaleFactor;
    }

    public void setyScaleFactor(float yScaleFactor) {
        this.yScaleFactor = yScaleFactor;
    }

    public int getScaledYIndex() {
        return scaledYIndex;
    }

    public void setScaledYIndex(int scaledYIndex) {
        this.scaledYIndex = scaledYIndex;
    }

    public int getNotScaledYIndex() {
        return notScaledYIndex;
    }

    public void setNotScaledYIndex(int notScaledYIndex) {
        this.notScaledYIndex = notScaledYIndex;
    }

    public double getMinY() {
        return minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public List<Interval> getMinIntervals() {
        return minIntervals;
    }

    public void setMinIntervals(List<Interval> minIntervals) {
        this.minIntervals = minIntervals;
    }

    public double[] getMinimums() {
        return minimums;
    }

    public void setMinimums(double[] minimums) {
        this.minimums = minimums;
    }
}
