package com.adi.lib.chart;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;

import com.adi.lib.R;
import com.adi.lib.chart.entity.Chart;
import com.adi.lib.chart.entity.Scene;
import com.adi.lib.utils.AndroidUtils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;


public class XAxisView extends View {
    private int height, width;
    Scene scene;
    DateFormat df = new SimpleDateFormat("MMM dd", Locale.US);
    Paint fontPaint = new Paint();
    float textSize;
    String date;
    float horizontalPadding;
    float verticalPadding;
    Chart chart;
    float fontAlpha;

    public XAxisView(Context context, Chart chart) {
        super(context);
        this.chart = chart;
        init();
    }

    private void init() {
        textSize = AndroidUtils.dpToPx(this.getContext(), 12);
        horizontalPadding = AndroidUtils.dpToPx(this.getContext(), 18);
        verticalPadding = AndroidUtils.dpToPx(this.getContext(), 20);
        fontPaint.setAntiAlias(true);
        fontPaint.setTextSize(textSize);
        fontPaint.setStyle(Paint.Style.FILL);
        fontPaint.setTextAlign(Paint.Align.RIGHT);
        applyTheme();
    }

    public void applyTheme() {
        if (ChartView.THEME == ChartView.THEME_LIGHT) {
            if (chart.getChartLines().get(0).getType() == 1) {
                fontPaint.setColor(getResources().getColor(R.color.lineXText));
                fontAlpha = 1.0f;
            } else {
                fontPaint.setColor(getResources().getColor(R.color.barXText));
                fontAlpha = 0.5f;
            }
        } else {
            if (chart.getChartLines().get(0).getType() == 1) {
                fontPaint.setColor(getResources().getColor(R.color.darkLineXText));
                fontAlpha = 0.6f;
            } else {
                fontPaint.setColor(getResources().getColor(R.color.darkBarXText));
                fontAlpha = 0.6f;
            }
        }
    }

    public void updateScene(Scene scene) {
        this.scene = scene;
        invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (scene != null && scene.getDates1() != null) {
            float percent = scene.getDatePercent();
            drawDates(canvas, scene.getDates1(), percent);
            drawDates(canvas, scene.getDates2(), 1.0f);
        }
    }

    private void drawDates(Canvas canvas, long[] dates, float percent) {
        if (scene != null) {
            fontPaint.setAlpha((int) (255 * percent * fontAlpha));
            for (int i = 0; i < dates.length; i++) {
                date = df.format(dates[dates.length - i - 1]);
                canvas.drawText(date, getScreenX(dates[dates.length - 1 - i], scene) - horizontalPadding, verticalPadding, fontPaint);
            }
        }
    }


    private float getScreenX(long x, Scene scene) {
        return (float) (((double) (x - scene.getMinX()) / (double) (scene.getMaxX() - scene.getMinX())) * (float) width);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        width = right - left;
        height = bottom - top;
    }
}
