package com.adi.lib.chart;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.support.v4.content.ContextCompat;
import android.view.View;

import com.adi.lib.R;
import com.adi.lib.utils.AndroidUtils;
import com.adi.lib.chart.entity.Chart;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class ChartTopPanel extends View {

    private Paint fontPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    private Paint datePaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    private Paint gradientPaint = new Paint();
    private String title;
    private float titleHeight, titleWidth, horizontalPadding, paddingTop;
    DateFormat df = new SimpleDateFormat("dd MMMM yyyy", Locale.US);
    Rect textBounds = new Rect();
    LinearGradient shader;
    int width, height;
    int shaderColor;
    Chart chart;
    Date startDate, endDate;

    public ChartTopPanel(Context context, Chart chart) {
        super(context);
        this.chart = chart;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(chart.getChartLines().get(0).getX()[0]);
        startDate = calendar.getTime();
        calendar.setTimeInMillis(chart.getChartLines().get(0).getX()[chart.getChartLines().get(0).getX().length - 1]);
        endDate = calendar.getTime();
        init();
    }

    private void init() {
        this.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
        fontPaint.setTextSize(AndroidUtils.dpToPx(getContext(), 18));
        fontPaint.setStyle(Paint.Style.FILL);
        fontPaint.setTypeface(Typeface.create(Typeface.DEFAULT, Typeface.BOLD));

        datePaint.setTextSize(AndroidUtils.dpToPx(getContext(), 16));
        datePaint.setStyle(Paint.Style.FILL);
        datePaint.setTypeface(Typeface.create(Typeface.DEFAULT, Typeface.BOLD));
        datePaint.setTextAlign(Paint.Align.RIGHT);

        horizontalPadding = AndroidUtils.dpToPx(getContext(), 18);
        paddingTop = AndroidUtils.dpToPx(getContext(), 20);
        applyTheme();

    }

    public void applyTheme() {
        if (ChartView.THEME == ChartView.THEME_LIGHT) {
            fontPaint.setColor(ContextCompat.getColor(getContext(), R.color.chartTitleColor));
            datePaint.setColor(ContextCompat.getColor(getContext(), R.color.chartTitleColor));
            shaderColor = ContextCompat.getColor(getContext(), R.color.chartViewBackgroundColor);
        } else {
            fontPaint.setColor(ContextCompat.getColor(getContext(), R.color.darkChartTitleColor));
            datePaint.setColor(ContextCompat.getColor(getContext(), R.color.darkChartTitleColor));
            shaderColor = ContextCompat.getColor(getContext(), R.color.darkChartViewBackgroundColor);
        }
    }

    public void drawShadow() {
        shader = new LinearGradient(0, 0, 1, getHeight(), shaderColor, Color.TRANSPARENT, Shader.TileMode.MIRROR);
        gradientPaint.setDither(true);
        gradientPaint.setShader(shader);
    }

    public void drawTitle(String title) {
        this.title = title;
        fontPaint.getTextBounds(title, 0, title.length(), textBounds);
        titleHeight = textBounds.height();
        titleWidth = textBounds.width();
        invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        /*if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            if (shader != null) {
                canvas.drawRect(0, 0, getWidth(), getHeight(), gradientPaint);
            }
        }*/
        if (title != null) {
            canvas.drawText(title, horizontalPadding, paddingTop + titleHeight, fontPaint);
        }
        if (chart != null) {
            canvas.drawText(df.format(startDate) + " - " + df.format(endDate), width - horizontalPadding, paddingTop + titleHeight, datePaint);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        width = MeasureSpec.getSize(widthMeasureSpec);
        height = MeasureSpec.getSize(heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}
