package com.adi.lib.chart;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;

import com.adi.lib.R;
import com.adi.lib.utils.AndroidUtils;
import com.adi.lib.chart.entity.ChartLine;
import com.adi.lib.chart.entity.PickerDetails;
import com.adi.lib.chart.entity.Scene;

import java.util.List;

import static com.adi.lib.chart.ChartView.THEME_DARK;


@SuppressLint("ViewConstructor")
public class ChartPercentageStackedView extends BaseChartView {
    private Paint paint = new Paint();
    private float[][] points;
    float minY;
    double sum;
    Path path = new Path();
    double lastYPosition;
    private boolean initialized = false;
    private Paint pickerLinePaint = new Paint(Paint.ANTI_ALIAS_FLAG);

    public ChartPercentageStackedView(Context context, boolean chartMode) {
        super(context, chartMode);
        init();
    }

    private void init() {
        paint.setStrokeWidth(AndroidUtils.dpToPx(getContext(), 1));
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        paint.setAntiAlias(true);
        pickerLinePaint.setStrokeWidth(AndroidUtils.dpToPx(getContext(), 1));
        pickerLinePaint.setStrokeCap(Paint.Cap.ROUND);
        pickerLinePaint.setStyle(Paint.Style.STROKE);
        applyTheme();
    }

    @Override
    public void applyTheme() {
        super.applyTheme();
        if (ChartView.THEME == THEME_DARK) {
            pickerLinePaint.setColor(getResources().getColor(R.color.darkGridHorizontalLine));
        } else {
            pickerLinePaint.setColor(getResources().getColor(R.color.gridHorizontalLine));
        }
    }

    @Override
    void updateChartLines(List<ChartLine> chartLines) {
        super.updateChartLines(chartLines);
        initialized = false;
    }

    @Override
    void updateScene(Scene newScene) {
        super.updateScene(newScene);
        minY = height + topPadding;
        if (chartMode) {
            points = new float[chartLines.size()][(stop - start + 3) * 2];
            calculatePoints();
            postInvalidate(0, 0, (int) width, (int) height);
        } else {//для слайдра не нужно пересчитывать точки при движении
            if (!initialized) {
                points = new float[chartLines.size()][(stop - start + 3) * 2];
                calculatePoints();
                postInvalidate(0, 0, (int) width, (int) height);
                initialized = true;
            }
        }
    }

    @Override
    void animateChart(float percent, float hm) {//TODO refactor
        initialized = false;
        for (int i = start; i <= stop; i++) {
            sum = 0;
            for (ChartLine chartLine : chartLines) {
                if (chartLine.isAnimationInProcess()) {
                    sum += chartLine.getY()[i] * percent;
                } else {
                    if (chartLine.isVisible()) {
                        sum += chartLine.getY()[i];
                    }
                }
            }
            scene.getMaximums()[i] = sum;
        }
        calculatePointsForAnimation(percent);
        postInvalidate(0, 0, (int) width, (int) height);
    }

    private void calculatePoints() {
        for (i = start; i <= stop; i++) {
            lastYPosition = 0;
            for (j = chartLines.size() - 1; j >= 0; j--) {
                if (chartLines.get(j).isVisible()) {
                    lastYPosition += chartLines.get(j).getY()[i];
                    points[j][(i - start) * 2] = getScreenX(xArray[i]);
                    points[j][(i - start) * 2 + 1] = getScreenY(lastYPosition, scene.getMinimums()[i], scene.getMaximums()[i]);
                }
            }
        }
    }

    private void calculatePointsForAnimation(float percent) {
        for (i = start; i <= stop; i++) {
            lastYPosition = 0;
            for (j = chartLines.size() - 1; j >= 0; j--) {
                if (chartLines.get(j).isAnimationInProcess()) {
                    lastYPosition += chartLines.get(j).getY()[i] * percent;
                    points[j][(i - start) * 2] = getScreenX(xArray[i]);
                } else {
                    if (chartLines.get(j).isVisible()) {
                        lastYPosition += chartLines.get(j).getY()[i];
                    }
                }
                points[j][(i - start) * 2 + 1] = getScreenY(lastYPosition, scene.getMinimums()[i], scene.getMaximums()[i]);
            }
        }
    }


    //отодвигаем старт влево для того чтобы не было видно левого отступа
    @Override
    protected void calculateStartAndStopX() {
        super.calculateStartAndStopX();
        int count = (int) (horizontalPadding / gapInPixel);
        start = start - count - 1;
        if (start < 0) start = 0;
        if (stop != xArray.length - 1) {
            stop = stop + 1;
        }
    }

    @Override
    public void pick(PickerDetails pickerDetails) {
        super.pick(pickerDetails);
        invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (chartLines != null && scene != null && scene.getMaximums() != null) {
            for (int i = 0; i < chartLines.size(); i++) {
                paint.setColor(chartLines.get(i).getColor());
                if (animationInProcess) {
                    paint.setAlpha(chartLines.get(i).getAlpha());
                    drawChartLine(canvas, i);
                } else {
                    paint.setAlpha(255);
                    if (chartLines.get(i).isVisible()) {
                        drawChartLine(canvas, i);
                    }
                }
            }
            if (picked) {
                pickerLinePaint.setAlpha(255 / 10);
                canvas.drawLine(getScreenX(pickerDetails.x), topPadding, getScreenX(pickerDetails.x), height + topPadding, pickerLinePaint);
            }
        }
    }


    private void drawChartLine(Canvas canvas, int index) {
        path.reset();
        for (i = start; i <= stop; i++) {
            if (i == start) {
                path.moveTo((int) points[index][(i - start) * 2], (int) points[index][(i - start) * 2 + 1]);
            }
            path.lineTo((int) points[index][(i - start) * 2], (int) points[index][(i - start) * 2 + 1]);
        }
        path.lineTo(points[index][(stop - start) * 2], height + topPadding);
        path.lineTo(points[index][0], height + topPadding);
        path.lineTo(points[index][0], (int) points[index][1]);
        canvas.drawPath(path, paint);

    }


}
