package com.adi.lib.chart;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.os.Handler;
import android.os.Looper;
import android.view.animation.DecelerateInterpolator;

import com.adi.lib.chart.entity.ChartLine;
import com.adi.lib.chart.entity.Scene;

public class ChartPercentageAnimator {
    private AnimatorSet animatorSet = new AnimatorSet();
    private ValueAnimator scaleAnimator = new ValueAnimator();
    private ValueAnimator alphaAnimator = new ValueAnimator();
    private Scene scene;
    private ChartLine animationChartLine;
    private ChartLineAnimator.AnimationListener animationListener;
    private BaseChartView chartLinesView;
    private BaseChartView navigationChartLineView;
    private boolean animateAlpha;

    ChartPercentageAnimator() {
        alphaAnimator.addUpdateListener(a -> {
            if (animateAlpha) {
                animationChartLine.setAlpha((int) a.getAnimatedValue());
            }
        });
        scaleAnimator.addUpdateListener(a -> {
            chartLinesView.animateChart((float) a.getAnimatedValue(), 0);
            navigationChartLineView.animateChart((float) a.getAnimatedValue(), 0);
        });
        alphaAnimator.setDuration(ChartView.ANIMATOR_DURATION);
        scaleAnimator.setDuration(ChartView.ANIMATOR_DURATION);
        animatorSet.setInterpolator(new DecelerateInterpolator());
        animatorSet.playTogether(scaleAnimator, alphaAnimator);
        animatorSet.removeAllListeners();
        animatorSet.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    chartLinesView.setAnimationInProcess(false);
                    if (animationChartLine != null) {
                        animationChartLine.setAnimationInProcess(false);
                    }
                    if (animationListener != null)
                        animationListener.onAnimationEnd(scene);
                }, 100);
            }
        });
    }

    void hide(BaseChartView chartLinesView, BaseChartView navigationChartLineView, ChartLine animationChartLine, boolean animateScale, boolean animateAlpha) {
        animatorSet.cancel();
        this.animateAlpha = animateAlpha;
        this.scene = chartLinesView.getScene();
        this.animationChartLine = animationChartLine;
        this.chartLinesView = chartLinesView;
        this.navigationChartLineView = navigationChartLineView;
        chartLinesView.setAnimationInProcess(true);
        if (animationChartLine != null) {
            animationChartLine.setAnimationInProcess(true);
        }
        if (animateScale) {
            initAnimation(1.f, 0, 255, 0);
        } else {
            initAnimation(1.f, 0, 255, 0);
        }
    }


    void show(BaseChartView chartLinesView, BaseChartView navigationChartLineView, ChartLine animationChartLine, boolean animateScale, boolean animateAlpha) {
        animatorSet.cancel();
        this.animateAlpha = animateAlpha;
        this.scene = chartLinesView.getScene();
        this.animationChartLine = animationChartLine;
        this.chartLinesView = chartLinesView;
        this.navigationChartLineView = navigationChartLineView;
        chartLinesView.setAnimationInProcess(true);
        if (animationChartLine != null) {
            animationChartLine.setAnimationInProcess(true);
        }
        if (animateScale) {
            initAnimation(0, 1.f, 0, 255);
        } else {
            initAnimation(0, 1.f, 0, 255);
        }
    }

    private void initAnimation(float scaleStart, float scaleStop, int alphaStart, int alphaStop) {
        alphaAnimator.setIntValues(alphaStart, alphaStop);
        scaleAnimator.setFloatValues(scaleStart, scaleStop);
        animatorSet.start();
    }

    public interface AnimationListener {
        void onAnimationEnd(Scene scene);
    }

    void setAnimationListener(ChartLineAnimator.AnimationListener animationListener) {
        this.animationListener = animationListener;
    }
}