package com.adi.lib.chart;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.view.animation.DecelerateInterpolator;

import com.adi.lib.chart.entity.ChartLine;
import com.adi.lib.chart.entity.Scene;

import static com.adi.lib.chart.ChartView.ANIMATOR_DURATION;

class ChartLineAnimator {
    private AnimatorSet animatorSet = new AnimatorSet();
    private ValueAnimator maxYAnimator = new ValueAnimator();
    private ValueAnimator minYAnimator = new ValueAnimator();
    private ValueAnimator alphaAnimator = new ValueAnimator();
    private ValueAnimator percentAnimator = new ValueAnimator();
    private Scene scene;
    private ChartLine animationChartLine;
    private AnimationListener animationListener;
    private BaseChartView chartLinesView;
    private boolean animateAlpha;
    float minY;

    ChartLineAnimator() {
        alphaAnimator.addUpdateListener(a -> {
            if (animateAlpha) {
                animationChartLine.setAlpha((int) a.getAnimatedValue());
            }
        });
        maxYAnimator.addUpdateListener(a -> {
            chartLinesView.animateChart((float) a.getAnimatedValue(), minY);
        });
        minYAnimator.addUpdateListener(a -> {
            minY = (float) a.getAnimatedValue();
        });
        percentAnimator.addUpdateListener(a -> {
            chartLinesView.animateChartPercent((float) a.getAnimatedValue());
        });
        animatorSet.setInterpolator(new DecelerateInterpolator());
        animatorSet.playTogether(maxYAnimator, minYAnimator, alphaAnimator, percentAnimator);
        animatorSet.removeAllListeners();
        animatorSet.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                chartLinesView.setAnimationInProcess(false);
                if (animationChartLine != null) {
                    animationChartLine.setAnimationInProcess(false);
                }
                if (animationListener != null)
                    animationListener.onAnimationEnd(scene);
            }
        });
        animatorSet.setDuration(ANIMATOR_DURATION);
    }

    void hide(BaseChartView chartLinesView, Scene newScene, ChartLine animationChartLine, boolean animateScale, boolean animateAlpha) {
        animatorSet.cancel();
        this.animateAlpha = animateAlpha;
        this.scene = chartLinesView.getScene();
        this.animationChartLine = animationChartLine;
        this.chartLinesView = chartLinesView;
        chartLinesView.setAnimationInProcess(true);
        if (animationChartLine != null) {
            animationChartLine.setAnimationInProcess(true);
        }
        if (animateScale) {
            initAnimation(scene, newScene, 255, 0, 1f, 0);
        } else {
            initAnimation(scene, scene, 255, 0, 1f, 0);
        }
    }


    void show(BaseChartView chartLinesView, Scene newScene, ChartLine animationChartLine, boolean animateScale, boolean animateAlpha) {
        animatorSet.cancel();
        this.animateAlpha = animateAlpha;
        this.scene = chartLinesView.getScene();
        this.animationChartLine = animationChartLine;
        this.chartLinesView = chartLinesView;
        chartLinesView.setAnimationInProcess(true);
        if (animationChartLine != null) {
            animationChartLine.setAnimationInProcess(true);
        }
        if (animateScale) {
            initAnimation(scene, newScene, 0, 255, 0, 1.f);
        } else {
            initAnimation(scene, scene, 0, 255, 0, 1.f);
        }
    }

    private void initAnimation(Scene oldScene, Scene newScene, int alphaStart, int alphaStop, float prcntStart, float prcntStop) {
        alphaAnimator.setIntValues(alphaStart, alphaStop);
        maxYAnimator.setFloatValues((float) oldScene.getMaxY(), (float) newScene.getMaxY());
        minYAnimator.setFloatValues((float) oldScene.getMinY(), (float) newScene.getMinY());
        minY = (float) oldScene.getMinY();
        percentAnimator.setFloatValues(prcntStart, prcntStop);
        animatorSet.start();
    }

    public interface AnimationListener {
        void onAnimationEnd(Scene scene);
    }

    void setAnimationListener(AnimationListener animationListener) {
        this.animationListener = animationListener;
    }
}
