package com.adi.lib.chart;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;

import com.adi.lib.chart.entity.Chart;
import com.adi.lib.chart.entity.GridState;
import com.adi.lib.chart.entity.Scene;

class ChartGridAnimator {
    private ValueAnimator grid1ScaleAnimator = new ValueAnimator();
    private ValueAnimator grid1AlphaAnimator = new ValueAnimator();
    private ValueAnimator grid2ScaleAnimator = new ValueAnimator();
    private ValueAnimator grid2AlphaAnimator = new ValueAnimator();
    private ValueAnimator appearAnimator = new ValueAnimator();
    private AnimatorSet animatorSet = new AnimatorSet();
    private ChartGridView chartGreedView;
    private GridState grid1 = new GridState();
    private GridState grid2 = new GridState();
    private GridState scaledGrid1 = new GridState();
    private GridState scaledGrid2 = new GridState();
    private float maxDelta, minDelta;
    private Scene currentOldScene, currentNewScene, nextOldScene, nextNewScene;
    private Chart chart;
    private boolean appear, disappear;
    private Scene appearScene;
    private int visibleCount;
    private boolean sceneChanged;

    ChartGridAnimator() {
        appearAnimator.addUpdateListener(a -> {
            if (appear) {
                if (chart.isyScaled()) {
                    if (chart.getChartLines().get(appearScene.getNotScaledYIndex()).isVisible()) {
                        grid1.alpha = (int) a.getAnimatedValue();
                    } else {
                        scaledGrid1.alpha = (int) a.getAnimatedValue();
                    }
                } else {
                    grid1.alpha = (int) a.getAnimatedValue();
                }
            } else if (disappear) {
                if (chart.isyScaled()) {
                    if (chart.getChartLines().get(appearScene.getNotScaledYIndex()).isAnimationInProcess()) {
                        grid1.alpha = (int) a.getAnimatedValue();
                    } else {
                        scaledGrid1.alpha = (int) a.getAnimatedValue();
                    }
                } else {
                    grid1.alpha = (int) a.getAnimatedValue();
                }
            }
        });
        grid1ScaleAnimator.addUpdateListener(a -> {
            if (!appear && !disappear && visibleCount > 0) {
                if (chart.isyScaled()) {
                    grid1.scaleFactor = (float) a.getAnimatedValue();
                    scaledGrid1.scaleFactor = (float) a.getAnimatedValue();
                    chartGreedView.update(grid1, grid2, scaledGrid1, scaledGrid2);
                } else {
                    grid1.scaleFactor = (float) a.getAnimatedValue();
                    chartGreedView.update(grid1, grid2);
                }
            } else {
                if (chart.isyScaled()) {
                    chartGreedView.update(grid1, grid2, scaledGrid1, scaledGrid2);
                } else {
                    chartGreedView.update(grid1, grid2);
                }
            }
        });
        grid1AlphaAnimator.addUpdateListener(a -> {
            if (!appear && !disappear && visibleCount > 0) {
                if (chart.isyScaled()) {
                    if (chart.getChartLines().get(chartGreedView.scene.getNotScaledYIndex()).isVisible()) {
                        grid1.alpha = (int) a.getAnimatedValue();
                    } else {
                        grid1.alpha = 0;
                    }

                    if (chart.getChartLines().get(chartGreedView.scene.getScaledYIndex()).isVisible()) {
                        scaledGrid1.alpha = (int) a.getAnimatedValue();
                    } else {
                        scaledGrid1.alpha = 0;
                    }
                } else {
                    grid1.alpha = (int) a.getAnimatedValue();
                }
            }
        });
        grid2ScaleAnimator.addUpdateListener(a -> {
            if (!appear && !disappear && visibleCount > 0) {
                grid2.scaleFactor = (float) a.getAnimatedValue();
                if (chart.isyScaled()) {
                    scaledGrid2.scaleFactor = (float) a.getAnimatedValue();
                }
            }
        });
        grid2AlphaAnimator.addUpdateListener(a -> {
            if (!appear && !disappear && visibleCount > 0) {
                if (chart.isyScaled()) {
                    if (chart.getChartLines().get(chartGreedView.scene.getNotScaledYIndex()).isAnimationInProcess()) {
                        grid2.alpha = 0;
                    } else {
                        if (chart.getChartLines().get(chartGreedView.scene.getNotScaledYIndex()).isVisible()) {
                            grid2.alpha = (int) a.getAnimatedValue();
                        }
                    }

                    if (chart.getChartLines().get(chartGreedView.scene.getScaledYIndex()).isAnimationInProcess()) {
                        scaledGrid2.alpha = 0;
                    } else {
                        if (chart.getChartLines().get(chartGreedView.scene.getScaledYIndex()).isVisible()) {
                            scaledGrid2.alpha = (int) a.getAnimatedValue();
                        }
                    }
                } else {
                    grid2.alpha = (int) a.getAnimatedValue();
                }
            }
        });
        animatorSet.setDuration(ChartView.ANIMATOR_DURATION);
        animatorSet.playTogether(grid1ScaleAnimator, grid1AlphaAnimator, grid2ScaleAnimator, grid2AlphaAnimator, appearAnimator);
        animatorSet.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                if (nextOldScene != null && nextNewScene != null) {
                    currentOldScene = nextOldScene;
                    currentNewScene = nextNewScene;
                    nextOldScene = null;
                    nextNewScene = null;
                    process();
                }
            }
        });
    }

    void disappear(ChartGridView chartGreedView, Scene scene, Chart chart) {
        this.chartGreedView = chartGreedView;
        this.appearScene = scene;
        this.chart = chart;
        this.disappear = true;
        this.appear = false;
        appearAnimator.setIntValues(255, 0);
        grid1AlphaAnimator.setIntValues(255, 255);
        grid2AlphaAnimator.setIntValues(255, 255);
        grid1ScaleAnimator.setFloatValues(1f, 1f);
        grid2ScaleAnimator.setFloatValues(1f, 1f);
        if (chart.isyScaled()) {
            if (chart.getChartLines().get(scene.getNotScaledYIndex()).isAnimationInProcess()) {
                grid1.set(scene.getMinY(), scene.getMaxY(), 255, 1.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
                grid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
                scaledGrid1.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
                scaledGrid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
            } else {
                scaledGrid1.set(scene.getMinY(), scene.getMaxY(), 255, 1.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
                scaledGrid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
                grid1.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
                grid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
            }
        } else {
            grid1.set(scene.getMinY(), scene.getMaxY(), 255, 1.0f, false);
            grid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false);
        }
        animatorSet.start();
    }

    void appear(ChartGridView chartGreedView, Scene scene, Chart chart) {
        this.chartGreedView = chartGreedView;
        this.appearScene = scene;
        this.chart = chart;
        this.appear = true;
        this.disappear = false;
        appearAnimator.setIntValues(0, 255);
        grid1AlphaAnimator.setIntValues(255, 255);
        grid2AlphaAnimator.setIntValues(255, 255);
        grid1ScaleAnimator.setFloatValues(1f, 1f);
        grid2ScaleAnimator.setFloatValues(1f, 1f);
        if (chart.isyScaled()) {
            if (chart.getChartLines().get(scene.getNotScaledYIndex()).isAnimationInProcess()) {
                grid1.set(scene.getMinY(), scene.getMaxY(), 0, 1.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
                grid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
                scaledGrid1.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
                scaledGrid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
            } else {
                scaledGrid1.set(scene.getMinY(), scene.getMaxY(), 0, 1.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
                scaledGrid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, true, chart.getChartLines().get(scene.getScaledYIndex()).getColor());
                grid1.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
                grid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false, chart.getChartLines().get(scene.getNotScaledYIndex()).getColor());
            }
        } else {
            grid1.set(scene.getMinY(), scene.getMaxY(), 0, 1.0f, false);
            grid2.set(scene.getMinY(), scene.getMaxY(), 0, 0.0f, false);
        }
        animatorSet.start();
    }

    synchronized void animate(ChartGridView chartGreedView, Scene scene1, Scene scene2, Chart chart) {
        //grid 1 появляется grid 2 исчезает
        visibleCount = ChartCore.getVisibleChartLinesCount(chart.getChartLines());
        this.chartGreedView = chartGreedView;
        this.appear = false;
        this.disappear = false;
        this.chart = chart;
        if (animatorSet.isRunning()) {
            nextOldScene = scene1;
            nextNewScene = scene2;
        } else {
            currentOldScene = scene1;
            currentNewScene = scene2;
            nextOldScene = null;
            nextNewScene = null;
            process();
        }
    }


    private void process() {
        appearAnimator.setIntValues(255, 255);
        grid1AlphaAnimator.setIntValues(0, 255);
        grid2AlphaAnimator.setIntValues(255, 0);
        grid1.set(currentNewScene.getMinY(), currentNewScene.getMaxY());
        grid2.set(currentOldScene.getMinY(), currentOldScene.getMaxY());
        if (chart.isyScaled()) {
            scaledGrid1.set(currentNewScene.getMinY(), currentNewScene.getMaxY(), true);
            scaledGrid2.set(currentOldScene.getMinY(), currentOldScene.getMaxY(), true);
            grid1.color = chart.getChartLines().get(chartGreedView.scene.getNotScaledYIndex()).getColor();
            grid2.color = chart.getChartLines().get(chartGreedView.scene.getNotScaledYIndex()).getColor();
            scaledGrid1.color = chart.getChartLines().get(chartGreedView.scene.getScaledYIndex()).getColor();
            scaledGrid2.color = chart.getChartLines().get(chartGreedView.scene.getScaledYIndex()).getColor();
        }
        minDelta = (float) (currentNewScene.getMinY() - currentOldScene.getMinY());
        maxDelta = (float) (currentNewScene.getMaxY() - currentOldScene.getMaxY());
        sceneChanged = minDelta != 0 || maxDelta != 0;

        if (Math.abs(maxDelta) >= Math.abs(minDelta)) {
            animateMaxYChange(maxDelta);
        } else {
            animateMinYChange(minDelta);
        }

        animatorSet.start();
    }

    private void animateMinYChange(float minDelta) {
        grid1.greedCenter = -1;
        grid2.greedCenter = -1;
        if (chart.isyScaled()) {
            scaledGrid1.greedCenter = -1;
            scaledGrid2.greedCenter = -1;
        }
        if (minDelta < 0) {
            grid1ScaleAnimator.setFloatValues(2f, 1f);
            grid2ScaleAnimator.setFloatValues(1f, 0.7f);
        } else {
            grid1ScaleAnimator.setFloatValues(0.7f, 1f);
            grid2ScaleAnimator.setFloatValues(1f, 2f);
        }
    }

    private void animateMaxYChange(float maxDelta) {
        grid1.greedCenter = 1;
        grid2.greedCenter = 1;
        if (chart.isyScaled()) {
            scaledGrid1.greedCenter = 1;
            scaledGrid2.greedCenter = 1;
        }
        if (maxDelta < 0) {//сцена уменьшается, низ не меняется
            grid1ScaleAnimator.setFloatValues(0f, 1f);
            grid2ScaleAnimator.setFloatValues(1f, 2f);
        } else { //сцена увеличивается вверх, низ не меняется
            grid1ScaleAnimator.setFloatValues(2f, 1f);
            grid2ScaleAnimator.setFloatValues(1f, 0f);
        }
    }


}
