/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class QueryMsgDetails
extends SMPPRequest {
    private int smLength;

    public QueryMsgDetails() {
        super(36);
    }

    public QueryMsgDetails(int seqNum) {
        super(36, seqNum);
    }

    public void setSmLength(int len) {
        this.smLength = len;
        if (this.smLength < 0) {
            this.smLength = 0;
        }
        if (this.smLength > 160) {
            this.smLength = 160;
        }
    }

    public int getSmLength() {
        return this.smLength;
    }

    public int getBodyLength() {
        int len = (this.messageId != null ? this.messageId.length() : 0) + (this.source != null ? this.source.getLength() : 3);
        return len + 1 + 1;
    }

    protected void encodeBody(OutputStream out) throws IOException {
        SMPPIO.writeCString(this.getMessageId(), out);
        if (this.source != null) {
            this.source.writeTo(out);
        } else {
            new Address(0, 0, "").writeTo(out);
        }
        SMPPIO.writeInt(this.smLength, 1, out);
    }

    public void readBodyFrom(byte[] body, int offset) throws SMPPProtocolException {
        this.messageId = SMPPIO.readCString(body, offset);
        this.source = new Address();
        this.source.readFrom(body, offset += this.messageId.length() + 1);
        offset += this.source.getLength();
        this.smLength = SMPPIO.bytesToInt(body, offset++, 1);
    }

    public String toString() {
        return new String("query_msg_details");
    }
}

