/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class ParamRetrieve
extends SMPPRequest {
    private String paramName = null;

    public ParamRetrieve() {
        super(34);
    }

    public ParamRetrieve(int seqNum) {
        super(34, seqNum);
    }

    public void setParamName(String paramName) throws InvalidParameterValueException {
        if (paramName == null) {
            this.paramName = null;
            return;
        }
        if (paramName.length() >= 32) {
            throw new InvalidParameterValueException("Parameter name is invalid", paramName);
        }
        this.paramName = paramName;
    }

    public String getParamName() {
        return this.paramName;
    }

    public int getBodyLength() {
        int len = this.paramName != null ? this.paramName.length() : 0;
        return len + 1;
    }

    protected void encodeBody(OutputStream out) throws IOException {
        SMPPIO.writeCString(this.paramName, out);
    }

    public void readBodyFrom(byte[] body, int offset) throws SMPPProtocolException {
        this.paramName = SMPPIO.readCString(body, offset);
    }

    public String toString() {
        return new String("param_retrieve");
    }
}

