/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.junit.jupiter.yaml;

import com.adelean.inject.resources.commons.ClassSupport;
import com.adelean.inject.resources.commons.CollectionFactory;
import com.adelean.inject.resources.commons.FieldAsserts;
import com.adelean.inject.resources.core.ResourceAsReader;
import com.adelean.inject.resources.core.helpers.StringUtils;
import com.adelean.inject.resources.junit.jupiter.GivenYamlDocumentsResource;
import com.adelean.inject.resources.junit.jupiter.core.cdi.InjectionContext;
import com.adelean.inject.resources.junit.jupiter.yaml.AbstractYamlResourcesInjector;
import com.adelean.inject.resources.junit.jupiter.yaml.SnakeYamlResourceParser;
import com.adelean.inject.resources.junit.jupiter.yaml.YamlDocumentsResourceResolver;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;

public final class YamlDocumentsResourcesInjector
extends AbstractYamlResourcesInjector<GivenYamlDocumentsResource> {
    private final YamlDocumentsResourceResolver resourceResolver;

    public YamlDocumentsResourcesInjector(InjectionContext injectionContext, @Nullable Object testInstance, Class<?> testClass) {
        super(injectionContext, testInstance, testClass, GivenYamlDocumentsResource.class);
        this.resourceResolver = new YamlDocumentsResourceResolver(testClass);
    }

    @Override
    protected void assertValidField(Field field) {
        FieldAsserts.assertNonPrivate(field, this.annotationType);
        FieldAsserts.assertArrayOrCollection("field", field.getType(), this.annotationType);
    }

    @Override
    public void assertValidParameter(Parameter parameter) {
        FieldAsserts.assertArrayOrCollection("parameter", parameter.getType(), this.annotationType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object valueToInject(Type valueType, GivenYamlDocumentsResource resourceAnnotation) {
        SnakeYamlResourceParser parser = this.findSnakeYamlParser(resourceAnnotation);
        Class<?> elementType = ClassSupport.fromType(ClassSupport.elementType(valueType));
        try (ResourceAsReader resource = this.resourceResolver.resolve(resourceAnnotation);){
            Iterable documents = parser.getYaml().loadAll((Reader)resource.reader());
            if (ClassSupport.isArray(valueType)) {
                A[] AArray = StreamSupport.stream(documents.spliterator(), false).toArray(length -> (Object[])Array.newInstance(elementType, length));
                return AArray;
            }
            if (!ClassSupport.isCollection(valueType)) return null;
            Collection collection = CollectionFactory.newCollection((ParameterizedType)valueType);
            documents.forEach(collection::add);
            Collection collection2 = collection;
            return collection2;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    @Nullable
    protected String yamlParserName(GivenYamlDocumentsResource resourceAnnotation) {
        return StringUtils.blankToNull((String)resourceAnnotation.yaml());
    }
}

