/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.junit.jupiter.core;

import com.adelean.inject.resources.commons.Errors;
import com.adelean.inject.resources.junit.jupiter.TestsAdvice;
import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.platform.commons.support.ModifierSupport;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public final class TestsAdviceProcessor {
    private static final String ERR_MULTIPLE_TESTS_ADVICES_ON_CLASSPATH = "Multiple classes annotated with @TestsAdvice was found on classpath. Only one advice is allowed. Following advice classes found:\n%s";
    private static final String MSG_TESTS_ADVICE_SPEC = "Tests advice class must be public, final, not extends any other class, and have a public constructor without arguments.";
    private static final String ERR_TESTS_ADVICE_IS_NOT_PUBLIC = "Class %s annotated with @TestsAdvice is not public! Tests advice class must be public, final, not extends any other class, and have a public constructor without arguments.";
    private static final String ERR_TESTS_ADVICE_IS_NOT_FINAL = "Class %s annotated with @TestsAdvice is not final! Tests advice class must be public, final, not extends any other class, and have a public constructor without arguments.";
    private static final String ERR_TESTS_ADVICE_HAS_SUPERCLASS = "Class %s annotated with @TestsAdvice inherits from class %s! Tests advice class must be public, final, not extends any other class, and have a public constructor without arguments.";
    private static final String ERR_TESTS_ADVICE_INVALID_CONSTRUCTOR = "Class %s annotated with @TestsAdvice doesn't have a public constructor without arguments! Tests advice class must be public, final, not extends any other class, and have a public constructor without arguments.";

    public static Optional<Class<?>> findAdviceClass() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath()));
        Set advices = reflections.getTypesAnnotatedWith(TestsAdvice.class);
        if (advices.isEmpty()) {
            return Optional.empty();
        }
        if (advices.size() > 1) {
            throw new ExtensionConfigurationException(String.format(ERR_MULTIPLE_TESTS_ADVICES_ON_CLASSPATH, Errors.typesToString(advices.toArray(new Class[0]))));
        }
        Class testsAdvice = (Class)advices.iterator().next();
        TestsAdviceProcessor.assertTestAdviceClass(testsAdvice);
        return Optional.of(testsAdvice);
    }

    static void assertTestAdviceClass(Class<?> testsAdvice) {
        TestsAdviceProcessor.assertIsPublic(testsAdvice);
        TestsAdviceProcessor.assertIsFinal(testsAdvice);
        TestsAdviceProcessor.assertHasNoSuperclass(testsAdvice);
        TestsAdviceProcessor.assertHasDefaultConstructor(testsAdvice);
    }

    static void assertIsPublic(Class<?> testsAdvice) {
        if (!ModifierSupport.isPublic(testsAdvice)) {
            throw new ExtensionConfigurationException(String.format(ERR_TESTS_ADVICE_IS_NOT_PUBLIC, testsAdvice.getName()));
        }
    }

    static void assertIsFinal(Class<?> testsAdvice) {
        if (ModifierSupport.isNotFinal(testsAdvice)) {
            throw new ExtensionConfigurationException(String.format(ERR_TESTS_ADVICE_IS_NOT_FINAL, testsAdvice.getName()));
        }
    }

    static void assertHasNoSuperclass(Class<?> testsAdvice) {
        Class<?> superclass = testsAdvice.getSuperclass();
        if (superclass != Object.class) {
            throw new ExtensionConfigurationException(String.format(ERR_TESTS_ADVICE_HAS_SUPERCLASS, testsAdvice.getName(), superclass.getName()));
        }
    }

    static void assertHasDefaultConstructor(Class<?> testsAdvice) {
        Set<Constructor> validConstructor = TestsAdviceProcessor.getDefaultConstructor(testsAdvice);
        if (validConstructor.size() != 1) {
            throw new ExtensionConfigurationException(String.format(ERR_TESTS_ADVICE_INVALID_CONSTRUCTOR, testsAdvice.getName()));
        }
    }

    public static Set<Constructor> getDefaultConstructor(Class<?> testsAdvice) {
        return ReflectionUtils.getConstructors(testsAdvice, (Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), ReflectionUtils.withParametersCount((int)0)});
    }
}

