/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.commons;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public final class ClassSupport {
    private ClassSupport() {
    }

    public static boolean isSubclass(Class<?> clazz, Class<?> superClass) {
        return clazz != superClass && superClass.isAssignableFrom(clazz);
    }

    public static boolean isArray(Type type) {
        return type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray();
    }

    public static boolean isCollection(Type type) {
        return type instanceof Class && Collection.class.isAssignableFrom((Class)type) || type instanceof ParameterizedType && Collection.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType());
    }

    public static Class<?> fromType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return Object.class;
    }

    @Nullable
    public static Type elementType(Type arrayOrCollectionType) {
        Class<?> elementType = null;
        if (ClassSupport.isArray(arrayOrCollectionType)) {
            if (arrayOrCollectionType instanceof GenericArrayType) {
                return ((GenericArrayType)arrayOrCollectionType).getGenericComponentType();
            }
            if (arrayOrCollectionType instanceof Class) {
                Class arrayType = (Class)arrayOrCollectionType;
                elementType = arrayType.getComponentType();
            }
        } else if (ClassSupport.isCollection(arrayOrCollectionType)) {
            ParameterizedType collectionType = (ParameterizedType)arrayOrCollectionType;
            elementType = collectionType.getActualTypeArguments()[0];
        }
        return elementType;
    }
}

