package com.adelean.inject.resources.junit.jupiter.yaml;

import com.adelean.inject.resources.commons.AnnotationSupport;
import com.adelean.inject.resources.core.ResourceAsReader;
import com.adelean.inject.resources.junit.jupiter.GivenYamlResource;
import com.adelean.inject.resources.junit.jupiter.core.ResourceResolver;

import java.nio.charset.Charset;

import static com.adelean.inject.resources.core.InjectResources.resource;

public final class YamlResourceResolver extends ResourceResolver<GivenYamlResource, ResourceAsReader> {
    protected YamlResourceResolver(Class<?> testClass) {
        super(testClass);
    }

    @Override
    public ResourceAsReader resolve(GivenYamlResource resourceAnnotation) {
        String path = AnnotationSupport.getFrom(resourceAnnotation);
        Charset charset = Charset.forName(resourceAnnotation.charset());

        return resource()
                .onClassLoaderOf(testClass)
                .withPath(path)
                .asReader(charset);
    }
}
