/*
 * Decompiled with CFR 0.152.
 */
package com.adelean.inject.resources.junit.jupiter.core.cdi;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class InjectionContext {
    public static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{InjectionContext.class});
    private final ExtensionContext.Store store;

    public InjectionContext(ExtensionContext context) {
        this.store = context.getStore(NAMESPACE);
    }

    public void defineBean(Class<?> testClass, String beanName, Class<?> beanType, Object instance) {
        Context context = (Context)this.store.getOrComputeIfAbsent(testClass, x$0 -> new Context((Class)x$0), Context.class);
        Bean bean = new Bean(beanType, beanName, instance);
        context.addBean(bean);
    }

    public <T, B> Optional<B> findBean(Class<T> testClass, String beanName, Class<B> beanType) {
        Class<T> testParentClass;
        Context context = (Context)this.store.get(testClass, Context.class);
        Optional<Object> foundBean = Optional.ofNullable(context).flatMap(ctx -> ((Context)ctx).findBean(beanName, beanType)).map(bean -> ((Bean)bean).instance);
        if (!foundBean.isPresent() && (testParentClass = testClass.getSuperclass()) != null) {
            foundBean = this.findBean(testParentClass, beanName, beanType);
        }
        return foundBean;
    }

    private static final class Context<T> {
        private static final String ERR_PARSER_ALREADY_DEFINED = "Class %s has already declared parser with name '%s'.";
        private static final String ERR_BEAN_WRONG_TYPE = "Bean %s of type %s declared in test class %s is not casted to %s.";
        private final Class<T> testClass;
        private final Map<String, Bean<?>> beans = new HashMap();

        private Context(Class<T> testClass) {
            this.testClass = testClass;
        }

        private <B> void addBean(Bean<B> bean) {
            if (this.beans.containsKey(((Bean)bean).name)) {
                throw new RuntimeException(String.format(ERR_PARSER_ALREADY_DEFINED, this.testClass.getName(), ((Bean)bean).name));
            }
            this.beans.put(((Bean)bean).name, bean);
        }

        private <B> Optional<Bean<B>> findBean(String beanName, Class<B> beanType) {
            return beanName != null ? this.findByName(beanName, beanType) : this.findByType(beanType);
        }

        private <B> Optional<Bean<B>> findByName(String beanName, Class<B> beanType) {
            Bean<?> bean = this.beans.get(beanName);
            if (bean != null) {
                if (((Bean)bean).matchType(beanType)) {
                    return Optional.of(bean);
                }
                throw new RuntimeException(String.format(ERR_BEAN_WRONG_TYPE, ((Bean)bean).name, ((Bean)bean).beanType.getName(), this.testClass.getName(), beanType.getName()));
            }
            return Optional.empty();
        }

        private <B> Optional<Bean<B>> findByType(Class<B> beanType) {
            return this.beans.values().stream().filter(bean -> ((Bean)bean).matchType(beanType)).map(bean -> bean).findAny();
        }
    }

    private static final class Bean<B> {
        private final Class<B> beanType;
        private final String name;
        private final B instance;

        private Bean(Class<B> beanType, String name, B instance) {
            this.beanType = beanType;
            this.name = name;
            this.instance = instance;
        }

        private boolean matchType(Class<?> requiredType) {
            return this.beanType.isAssignableFrom(requiredType);
        }
    }
}

