/*
 * Decompiled with CFR 0.152.
 */
package com.adcolony.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adcolony.sdk.a;
import com.adcolony.sdk.ab;
import com.adcolony.sdk.av;
import com.adcolony.sdk.j;
import com.adcolony.sdk.u;
import com.adcolony.sdk.w;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class AdColonyEventTracker {
    private static final List<JSONObject> a = Collections.synchronizedList(new ArrayList());
    private static final int b = 200;
    public static final String SOCIAL_SHARING_FACEBOOK = "ADCT_FACEBOOK_SHARING";
    public static final String SOCIAL_SHARING_TWITTER = "ADCT_TWITTER_SHARING";
    public static final String SOCIAL_SHARING_GOOGLE = "ADCT_GOOGLE_SHARING";
    public static final String SOCIAL_SHARING_LINKEDIN = "ADCT_LINKEDIN_SHARING";
    public static final String SOCIAL_SHARING_PINTEREST = "ADCT_PINTEREST_SHARING";
    public static final String SOCIAL_SHARING_YOUTUBE = "ADCT_YOUTUBE_SHARING";
    public static final String SOCIAL_SHARING_INSTAGRAM = "ADCT_INSTAGRAM_SHARING";
    public static final String SOCIAL_SHARING_TUMBLR = "ADCT_TUMBLR_SHARING";
    public static final String SOCIAL_SHARING_FLICKR = "ADCT_FLICKR_SHARING";
    public static final String SOCIAL_SHARING_VIMEO = "ADCT_VIMEO_SHARING";
    public static final String SOCIAL_SHARING_FOURSQUARE = "ADCT_FOURSQUARE_SHARING";
    public static final String SOCIAL_SHARING_VINE = "ADCT_VINE_SHARING";
    public static final String SOCIAL_SHARING_SNAPCHAT = "ADCT_SNAPCHAT_SHARING";
    public static final String SOCIAL_SHARING_CUSTOM = "ADCT_CUSTOM_SHARING";
    public static final String REGISTRATION_DEFAULT = "ADCT_DEFAULT_REGISTRATION";
    public static final String REGISTRATION_FACEBOOK = "ADCT_FACEBOOK_REGISTRATION";
    public static final String REGISTRATION_TWITTER = "ADCT_TWITTER_REGISTRATION";
    public static final String REGISTRATION_GOOGLE = "ADCT_GOOGLE_REGISTRATION";
    public static final String REGISTRATION_LINKEDIN = "ADCT_LINKEDIN_REGISTRATION";
    public static final String REGISTRATION_OPENID = "ADCT_OPENID_REGISTRATION";
    public static final String REGISTRATION_CUSTOM = "ADCT_CUSTOM_REGISTRATION";
    public static final String CUSTOM_EVENT_1 = "ADCT_CUSTOM_EVENT_1";
    public static final String CUSTOM_EVENT_2 = "ADCT_CUSTOM_EVENT_2";
    public static final String CUSTOM_EVENT_3 = "ADCT_CUSTOM_EVENT_3";
    public static final String CUSTOM_EVENT_4 = "ADCT_CUSTOM_EVENT_4";
    public static final String CUSTOM_EVENT_5 = "ADCT_CUSTOM_EVENT_5";
    public static final String LOGIN_DEFAULT = "ADCT_DEFAULT_LOGIN";
    public static final String LOGIN_FACEBOOK = "ADCT_FACEBOOK_LOGIN";
    public static final String LOGIN_TWITTER = "ADCT_TWITTER_LOGIN";
    public static final String LOGIN_GOOGLE = "ADCT_GOOGLE_LOGIN";
    public static final String LOGIN_LINKEDIN = "ADCT_LINKEDIN_LOGIN";
    public static final String LOGIN_OPENID = "ADCT_OPENID_LOGIN";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void a(JSONObject jSONObject) {
        List<JSONObject> list = a;
        synchronized (list) {
            if (200 > a.size()) {
                a.add(jSONObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void a() {
        if (!j.C().equals("")) {
            List<JSONObject> list = a;
            synchronized (list) {
                Iterator<JSONObject> iterator = a.iterator();
                while (iterator.hasNext()) {
                    AdColonyEventTracker.b(iterator.next());
                }
                a.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean b() {
        List<JSONObject> list = a;
        synchronized (list) {
            return a.size() != 0;
        }
    }

    public static void logTransaction(@Nullable String itemId, @Nullable Integer quantity, @Nullable Double price, @Nullable String currencyCode, @Nullable String receipt, @Nullable String store, @Nullable String description) {
        if (AdColonyEventTracker.a(description, "logTransaction")) {
            return;
        }
        if (currencyCode != null && currencyCode.length() != 3) {
            new w.a().a("Event logCreditsSpentWithName currency code is specified, but a three-letter ISO 4217 code, (e.g.: 'USD'). Event will not be sent.").a(w.g);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("item_id", itemId);
        hashMap.put("quantity", String.valueOf(quantity));
        hashMap.put("price", String.valueOf(price));
        hashMap.put("currency_code", currencyCode);
        hashMap.put("receipt", receipt);
        hashMap.put("store", store);
        hashMap.put("description", description);
        AdColonyEventTracker.logEvent("transaction", hashMap);
    }

    public static void logCreditsSpent(@Nullable String name, @Nullable Integer quantity, @Nullable Double value, @Nullable String currencyCode) {
        if (currencyCode != null && currencyCode.length() != 3) {
            new w.a().a("Event logCreditsSpentWithName currency code is specified, but a three-letter ISO 4217 code, (e.g.: 'USD'). Event will not be sent.").a(w.g);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", name);
        hashMap.put("quantity", String.valueOf(quantity));
        hashMap.put("value", String.valueOf(value));
        hashMap.put("currency_code", currencyCode);
        AdColonyEventTracker.logEvent("credits_spent", hashMap);
    }

    public static void logPaymentInfoAdded() {
        AdColonyEventTracker.logEvent("payment_info_added");
    }

    public static void logAchievementUnlocked(@Nullable String description) {
        if (AdColonyEventTracker.a(description, "logAchievementUnlocked")) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("description", description);
        AdColonyEventTracker.logEvent("achievement_unlocked", hashMap);
    }

    public static void logLevelAchieved(@Nullable Integer levelAchieved) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("level_achieved", String.valueOf(levelAchieved));
        AdColonyEventTracker.logEvent("level_achieved", hashMap);
    }

    public static void logAppRated() {
        AdColonyEventTracker.logEvent("app_rated");
    }

    public static void logActivated() {
        AdColonyEventTracker.logEvent("activated");
    }

    public static void logTutorialCompleted() {
        AdColonyEventTracker.logEvent("tutorial_completed");
    }

    public static void logSocialSharingEvent(@Nullable String network, @Nullable String description) {
        if (AdColonyEventTracker.a(description, "logSocialSharingEvent")) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("network", network);
        hashMap.put("description", description);
        AdColonyEventTracker.logEvent("social_sharing_event", hashMap);
    }

    public static void logRegistrationCompleted(@Nullable String method, @Nullable String description) {
        if (AdColonyEventTracker.a(description, "logRegistrationCompleted")) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("method", method);
        hashMap.put("description", description);
        AdColonyEventTracker.logEvent("registration_completed", hashMap);
    }

    public static void logCustomEvent(@Nullable String event, @Nullable String description) {
        if (AdColonyEventTracker.a(description, "logCustomEvent")) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", event);
        hashMap.put("description", description);
        AdColonyEventTracker.logEvent("custom_event", hashMap);
    }

    public static void logAddToCart(@Nullable String itemId) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("item_id", itemId);
        AdColonyEventTracker.logEvent("add_to_cart", hashMap);
    }

    public static void logAddToWishlist(@Nullable String itemId) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("item_id", itemId);
        AdColonyEventTracker.logEvent("add_to_wishlist", hashMap);
    }

    public static void logCheckoutInitiated() {
        AdColonyEventTracker.logEvent("checkout_initiated");
    }

    public static void logContentView(@Nullable String contentId, @Nullable String contentType) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("content_id", contentId);
        hashMap.put("content_type", contentType);
        AdColonyEventTracker.logEvent("content_view", hashMap);
    }

    public static void logInvite() {
        AdColonyEventTracker.logEvent("invite");
    }

    public static void logLogin(@Nullable String method) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("method", method);
        AdColonyEventTracker.logEvent("login", hashMap);
    }

    public static void logReservation() {
        AdColonyEventTracker.logEvent("reservation");
    }

    public static void logSearch(@Nullable String searchString) {
        if (searchString != null && searchString.length() > 512) {
            new w.a().a("logSearch searchString cannot exceed 512 characters. Event will ").a("not be sent.").a(w.g);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("search_string", searchString);
        AdColonyEventTracker.logEvent("search", hashMap);
    }

    public static void logEvent(@Nullable String eventName) {
        AdColonyEventTracker.logEvent(eventName, null);
    }

    public static void logEvent(@NonNull String eventName, @Nullable HashMap<String, String> payload) {
        JSONObject jSONObject = u.a();
        u.a(jSONObject, "event_name", eventName);
        JSONObject jSONObject2 = u.a();
        if (payload != null) {
            for (Map.Entry<String, String> entry : payload.entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("null")) continue;
                u.a(jSONObject2, entry.getKey(), entry.getValue());
            }
        }
        AdColonyEventTracker.d(jSONObject2);
        u.a(jSONObject, "payload", jSONObject2);
        AdColonyEventTracker.b(jSONObject);
    }

    private static void b(JSONObject jSONObject) {
        j j2 = com.adcolony.sdk.a.a();
        if (j.C().equals("")) {
            AdColonyEventTracker.a(jSONObject);
        } else {
            AdColonyEventTracker.c(jSONObject);
            new ab("AdColony.log_event", 1, jSONObject).b();
        }
    }

    private static void c(JSONObject jSONObject) {
        JSONObject jSONObject2 = u.f(jSONObject, "payload");
        if (av.a) {
            u.a(jSONObject2, "api_key", "bb2cf0647ba654d7228dd3f9405bbc6a");
        } else {
            u.a(jSONObject2, "api_key", j.C());
        }
        try {
            jSONObject.remove("payload");
            jSONObject.put("payload", (Object)jSONObject2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private static void d(JSONObject jSONObject) {
        u.a(jSONObject, "timezone", TimeZone.getDefault().getID());
        u.a(jSONObject, "action_time", String.valueOf(Math.round(System.currentTimeMillis() / 1000L)));
    }

    private static boolean a(String string, String string2) {
        if (string != null && string.length() > 512) {
            new w.a().a("Description of event ").a(string2).a(" must be less").a(" than 512 characters").a(w.g);
            return true;
        }
        return false;
    }
}

