/*
 * Decompiled with CFR 0.152.
 */
package com.adcolony.sdk;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import com.adcolony.sdk.AdColonyAdOptions;
import com.adcolony.sdk.AdColonyAdSize;
import com.adcolony.sdk.AdColonyAdViewListener;
import com.adcolony.sdk.AdColonyAppOptions;
import com.adcolony.sdk.AdColonyCustomMessageListener;
import com.adcolony.sdk.AdColonyInterstitial;
import com.adcolony.sdk.AdColonyInterstitialListener;
import com.adcolony.sdk.AdColonyRewardListener;
import com.adcolony.sdk.AdColonyZone;
import com.adcolony.sdk.a;
import com.adcolony.sdk.ab;
import com.adcolony.sdk.ae;
import com.adcolony.sdk.ah;
import com.adcolony.sdk.at;
import com.adcolony.sdk.av;
import com.adcolony.sdk.b;
import com.adcolony.sdk.j;
import com.adcolony.sdk.u;
import com.adcolony.sdk.w;
import com.adcolony.sdk.y;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.json.JSONObject;

public class AdColony {
    static ExecutorService a = Executors.newSingleThreadExecutor();

    public static boolean disable() {
        if (!com.adcolony.sdk.a.e()) {
            return false;
        }
        Context context = com.adcolony.sdk.a.c();
        if (context != null && context instanceof b) {
            ((Activity)context).finish();
        }
        final j j2 = com.adcolony.sdk.a.a();
        for (final AdColonyInterstitial adColonyInterstitial : j2.l().c().values()) {
            at.a(new Runnable(){

                @Override
                public void run() {
                    AdColonyInterstitialListener adColonyInterstitialListener = adColonyInterstitial.getListener();
                    adColonyInterstitial.a(true);
                    if (adColonyInterstitialListener != null) {
                        adColonyInterstitialListener.onExpiring(adColonyInterstitial);
                    }
                }
            });
        }
        at.a(new Runnable(){

            @Override
            public void run() {
                ArrayList<ae> arrayList = new ArrayList<ae>();
                for (ae ae2 : j2.q().c()) {
                    arrayList.add(ae2);
                }
                for (ae ae2 : arrayList) {
                    av av2;
                    j2.a(ae2.a());
                    if (!(ae2 instanceof av) || (av2 = (av)ae2).m()) continue;
                    av2.loadUrl("about:blank");
                    av2.clearCache(true);
                    av2.removeAllViews();
                    av2.a(true);
                }
            }
        });
        com.adcolony.sdk.a.a().a(true);
        return true;
    }

    public static boolean configure(Activity activity, @NonNull String appId, String ... zoneIds) {
        return AdColony.a((Context)activity, null, appId, zoneIds);
    }

    public static boolean configure(Activity activity, AdColonyAppOptions options, @NonNull String appId, String ... zoneIds) {
        return AdColony.a((Context)activity, options, appId, zoneIds);
    }

    public static boolean configure(Application app, @NonNull String appId, String ... zoneIds) {
        return AdColony.configure(app, null, appId, zoneIds);
    }

    public static boolean configure(Application app, AdColonyAppOptions options, @NonNull String appId, String ... zoneIds) {
        return AdColony.a((Context)app, options, appId, zoneIds);
    }

    private static boolean a(Context context, AdColonyAppOptions adColonyAppOptions, @NonNull String string, String ... stringArray) {
        Object object;
        if (ah.a(0, null)) {
            new w.a().a("Cannot configure AdColony; configuration mechanism requires 5 ").a("seconds between attempts.").a(w.e);
            return false;
        }
        Context context2 = context;
        if (context == null) {
            context2 = com.adcolony.sdk.a.c();
        }
        if (context2 == null) {
            new w.a().a("Ignoring call to AdColony.configure() as the provided Activity or ").a("Application context is null and we do not currently hold a ").a("reference to either for our use.").a(w.e);
            return false;
        }
        if (Looper.myLooper() == null) {
            Looper.prepare();
        }
        if (adColonyAppOptions == null) {
            adColonyAppOptions = new AdColonyAppOptions();
        }
        if (com.adcolony.sdk.a.b() && !u.d(com.adcolony.sdk.a.a().d().d(), "reconfigurable")) {
            object = com.adcolony.sdk.a.a();
            if (!((j)object).d().a().equals(string)) {
                new w.a().a("Ignoring call to AdColony.configure() as the app id does not ").a("match what was used during the initial configuration.").a(w.e);
                return false;
            }
            if (at.a(stringArray, ((j)object).d().b())) {
                new w.a().a("Ignoring call to AdColony.configure() as the same zone ids ").a("were used during the previous configuration.").a(w.e);
                return true;
            }
        }
        adColonyAppOptions.a(string);
        adColonyAppOptions.a(stringArray);
        adColonyAppOptions.f();
        object = new SimpleDateFormat("HH:mm:ss:SSS", Locale.US);
        long l2 = System.currentTimeMillis();
        String string2 = ((DateFormat)object).format(new Date(l2));
        boolean bl = true;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || stringArray[i2].equals("")) continue;
            bl = false;
        }
        if (string.equals("") || bl) {
            new w.a().a("AdColony.configure() called with an empty app or zone id String.").a(w.g);
            return false;
        }
        com.adcolony.sdk.a.a = true;
        if (Build.VERSION.SDK_INT < 14) {
            new w.a().a("The minimum API level for the AdColony SDK is 14.").a(w.e);
            com.adcolony.sdk.a.a(context2, adColonyAppOptions, true);
        } else {
            com.adcolony.sdk.a.a(context2, adColonyAppOptions, false);
        }
        String string3 = com.adcolony.sdk.a.a().o().c() + "/adc3/AppInfo";
        JSONObject jSONObject = u.a();
        if (new File(string3).exists()) {
            jSONObject = u.c(string3);
        }
        JSONObject jSONObject2 = u.a();
        if (u.b(jSONObject, "appId").equals(string)) {
            u.a(jSONObject2, "zoneIds", u.a(u.g(jSONObject, "zoneIds"), stringArray, true));
            u.a(jSONObject2, "appId", string);
        } else {
            u.a(jSONObject2, "zoneIds", u.a(stringArray));
            u.a(jSONObject2, "appId", string);
        }
        u.h(jSONObject2, string3);
        new w.a().a("Configure: Total Time (ms): ").a("" + (System.currentTimeMillis() - l2)).a(" and started at " + string2).a(w.f);
        return true;
    }

    public static AdColonyZone getZone(@NonNull String zoneId) {
        if (!com.adcolony.sdk.a.e()) {
            new w.a().a("Ignoring call to AdColony.getZone() as AdColony has not yet been ").a("configured.").a(w.e);
            return null;
        }
        HashMap<String, AdColonyZone> hashMap = com.adcolony.sdk.a.a().f();
        if (hashMap.containsKey(zoneId)) {
            return hashMap.get(zoneId);
        }
        AdColonyZone adColonyZone = new AdColonyZone(zoneId);
        com.adcolony.sdk.a.a().f().put(zoneId, adColonyZone);
        return adColonyZone;
    }

    public static boolean notifyIAPComplete(@NonNull String productId, @NonNull String transId) {
        return AdColony.notifyIAPComplete(productId, transId, null, 0.0);
    }

    public static boolean notifyIAPComplete(final @NonNull String productId, final @NonNull String transId, final String currencyCode, final @FloatRange(from=0.0) double price) {
        if (!com.adcolony.sdk.a.e()) {
            new w.a().a("Ignoring call to notifyIAPComplete as AdColony has not yet been ").a("configured.").a(w.e);
            return false;
        }
        if (!at.d(productId) || !at.d(transId)) {
            new w.a().a("Ignoring call to notifyIAPComplete as one of the passed Strings ").a("is greater than ").a(128).a(" characters.").a(w.e);
            return false;
        }
        if (currencyCode != null && currencyCode.length() > 3) {
            new w.a().a("You are trying to report an IAP event with a currency String ").a("containing more than 3 characters.").a(w.e);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AdColony.a();
                JSONObject jSONObject = u.a();
                if (price >= 0.0) {
                    u.a(jSONObject, "price", price);
                }
                if (currencyCode != null && currencyCode.length() <= 3) {
                    u.a(jSONObject, "currency_code", currencyCode);
                }
                u.a(jSONObject, "product_id", productId);
                u.a(jSONObject, "transaction_id", transId);
                new ab("AdColony.on_iap_report", 1, jSONObject).b();
            }
        };
        a.execute(runnable);
        return true;
    }

    public static boolean requestAdView(@NonNull String zoneId, @NonNull AdColonyAdViewListener listener, @NonNull AdColonyAdSize size) {
        return AdColony.requestAdView(zoneId, listener, size, null);
    }

    public static boolean requestAdView(final @NonNull String zoneId, final @NonNull AdColonyAdViewListener listener, final @NonNull AdColonyAdSize size, final AdColonyAdOptions options) {
        if (!com.adcolony.sdk.a.e()) {
            new w.a().a("Ignoring call to requestAdView as AdColony has not yet been").a(" configured.").a(w.e);
            AdColony.a(listener, zoneId);
            return false;
        }
        if (size.getHeight() <= 0 || size.getWidth() <= 0) {
            new w.a().a("Ignoring call to requestAdView as you've provided an AdColonyAdSize").a(" object with an invalid width or height.").a(w.e);
            return false;
        }
        Bundle bundle = new Bundle();
        bundle.putString("zone_id", zoneId);
        if (ah.a(1, bundle)) {
            AdColony.a(listener, zoneId);
            return false;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AdColonyZone adColonyZone;
                j j2 = com.adcolony.sdk.a.a();
                if (j2.g() || j2.h()) {
                    AdColony.b();
                    AdColony.a(listener, zoneId);
                }
                if (!AdColony.a() && com.adcolony.sdk.a.d()) {
                    AdColony.a(listener, zoneId);
                }
                if ((adColonyZone = j2.f().get(zoneId)) == null) {
                    adColonyZone = new AdColonyZone(zoneId);
                    new w.a().a("Zone info for ").a(zoneId).a(" doesn't exist in hashmap").a(w.b);
                }
                j2.l().a(zoneId, listener, size, options);
            }
        };
        try {
            a.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            AdColony.a(listener, zoneId);
            return false;
        }
        return true;
    }

    public static boolean setAppOptions(final @NonNull AdColonyAppOptions options) {
        if (!com.adcolony.sdk.a.e()) {
            new w.a().a("Ignoring call to AdColony.setAppOptions() as AdColony has not yet").a(" been configured.").a(w.e);
            return false;
        }
        com.adcolony.sdk.a.a().b(options);
        options.f();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AdColony.a();
                JSONObject jSONObject = u.a();
                u.a(jSONObject, "options", options.d());
                new ab("Options.set_options", 1, jSONObject).b();
            }
        };
        try {
            a.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return false;
        }
        return true;
    }

    public static AdColonyAppOptions getAppOptions() {
        if (!com.adcolony.sdk.a.e()) {
            return null;
        }
        return com.adcolony.sdk.a.a().d();
    }

    public static boolean setRewardListener(@NonNull AdColonyRewardListener listener) {
        if (!com.adcolony.sdk.a.e()) {
            new w.a().a("Ignoring call to AdColony.setRewardListener() as AdColony has not").a(" yet been configured.").a(w.e);
            return false;
        }
        com.adcolony.sdk.a.a().a(listener);
        return true;
    }

    public static boolean removeRewardListener() {
        if (!com.adcolony.sdk.a.e()) {
            new w.a().a("Ignoring call to AdColony.removeRewardListener() as AdColony has ").a("not yet been configured.").a(w.e);
            return false;
        }
        com.adcolony.sdk.a.a().a((AdColonyRewardListener)null);
        return true;
    }

    public static String getSDKVersion() {
        if (!com.adcolony.sdk.a.e()) {
            return "";
        }
        return com.adcolony.sdk.a.a().m().F();
    }

    public static AdColonyRewardListener getRewardListener() {
        if (!com.adcolony.sdk.a.e()) {
            return null;
        }
        return com.adcolony.sdk.a.a().i();
    }

    public static boolean addCustomMessageListener(@NonNull AdColonyCustomMessageListener listener, final String type) {
        if (!com.adcolony.sdk.a.e()) {
            new w.a().a("Ignoring call to AdColony.addCustomMessageListener as AdColony ").a("has not yet been configured.").a(w.e);
            return false;
        }
        if (!at.d(type)) {
            new w.a().a("Ignoring call to AdColony.addCustomMessageListener.").a(w.e);
            return false;
        }
        try {
            com.adcolony.sdk.a.a().A().put(type, listener);
            a.execute(new Runnable(){

                @Override
                public void run() {
                    AdColony.a();
                    JSONObject jSONObject = u.a();
                    u.a(jSONObject, "type", type);
                    new ab("CustomMessage.register", 1, jSONObject).b();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return false;
        }
        return true;
    }

    public static AdColonyCustomMessageListener getCustomMessageListener(@NonNull String type) {
        if (!com.adcolony.sdk.a.e()) {
            return null;
        }
        return com.adcolony.sdk.a.a().A().get(type);
    }

    public static boolean removeCustomMessageListener(final @NonNull String type) {
        if (!com.adcolony.sdk.a.e()) {
            new w.a().a("Ignoring call to AdColony.removeCustomMessageListener as AdColony").a(" has not yet been configured.").a(w.e);
            return false;
        }
        com.adcolony.sdk.a.a().A().remove(type);
        a.execute(new Runnable(){

            @Override
            public void run() {
                AdColony.a();
                JSONObject jSONObject = u.a();
                u.a(jSONObject, "type", type);
                new ab("CustomMessage.unregister", 1, jSONObject).b();
            }
        });
        return true;
    }

    public static boolean clearCustomMessageListeners() {
        if (!com.adcolony.sdk.a.e()) {
            new w.a().a("Ignoring call to AdColony.clearCustomMessageListeners as AdColony").a(" has not yet been configured.").a(w.e);
            return false;
        }
        com.adcolony.sdk.a.a().A().clear();
        a.execute(new Runnable(){

            @Override
            public void run() {
                AdColony.a();
                for (String string : com.adcolony.sdk.a.a().A().keySet()) {
                    JSONObject jSONObject = u.a();
                    u.a(jSONObject, "type", string);
                    new ab("CustomMessage.unregister", 1, jSONObject).b();
                }
            }
        });
        return true;
    }

    public static boolean requestInterstitial(@NonNull String zoneId, @NonNull AdColonyInterstitialListener listener) {
        return AdColony.requestInterstitial(zoneId, listener, null);
    }

    public static boolean requestInterstitial(final @NonNull String zoneId, final @NonNull AdColonyInterstitialListener listener, final AdColonyAdOptions options) {
        if (!com.adcolony.sdk.a.e()) {
            new w.a().a("Ignoring call to AdColony.requestInterstitial as AdColony has not").a(" yet been configured.").a(w.e);
            AdColonyZone adColonyZone = new AdColonyZone(zoneId);
            listener.onRequestNotFilled(adColonyZone);
            return false;
        }
        Bundle bundle = new Bundle();
        bundle.putString("zone_id", zoneId);
        if (ah.a(1, bundle)) {
            AdColonyZone adColonyZone = com.adcolony.sdk.a.a().f().get(zoneId);
            if (adColonyZone == null) {
                adColonyZone = new AdColonyZone(zoneId);
                new w.a().a("Zone info for ").a(zoneId + " doesn't exist in hashmap").a(w.b);
            }
            listener.onRequestNotFilled(adColonyZone);
            return false;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                j j2 = com.adcolony.sdk.a.a();
                if (j2.g() || j2.h()) {
                    AdColony.b();
                    AdColony.a(listener, zoneId);
                    return;
                }
                if (!AdColony.a() && com.adcolony.sdk.a.d()) {
                    AdColony.a(listener, zoneId);
                    return;
                }
                AdColonyZone adColonyZone = j2.f().get(zoneId);
                if (adColonyZone == null) {
                    adColonyZone = new AdColonyZone(zoneId);
                    new w.a().a("Zone info for ").a(zoneId + " doesn't exist in hashmap").a(w.b);
                }
                if (adColonyZone.getZoneType() != 2 && adColonyZone.getZoneType() != 1) {
                    j2.l().a(zoneId, listener, options);
                } else {
                    final AdColonyZone adColonyZone2 = adColonyZone;
                    at.a(new Runnable(){

                        @Override
                        public void run() {
                            listener.onRequestNotFilled(adColonyZone2);
                        }
                    });
                }
            }
        };
        try {
            a.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            AdColony.a(listener, zoneId);
            return false;
        }
        return true;
    }

    static boolean a() {
        at.a a2 = new at.a(15.0);
        j j2 = com.adcolony.sdk.a.a();
        while (!j2.B() && !a2.b()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return j2.B();
    }

    static boolean a(final AdColonyInterstitialListener adColonyInterstitialListener, final String string) {
        if (adColonyInterstitialListener != null && com.adcolony.sdk.a.d()) {
            at.a(new Runnable(){

                @Override
                public void run() {
                    AdColonyZone adColonyZone = com.adcolony.sdk.a.a().f().get(string);
                    if (adColonyZone == null) {
                        adColonyZone = new AdColonyZone(string);
                    }
                    adColonyInterstitialListener.onRequestNotFilled(adColonyZone);
                }
            });
        }
        return false;
    }

    static boolean a(final AdColonyAdViewListener adColonyAdViewListener, final String string) {
        if (adColonyAdViewListener != null && com.adcolony.sdk.a.d()) {
            at.a(new Runnable(){

                @Override
                public void run() {
                    AdColonyZone adColonyZone;
                    AdColonyZone adColonyZone2 = adColonyZone = !com.adcolony.sdk.a.b() ? null : com.adcolony.sdk.a.a().f().get(string);
                    if (adColonyZone == null) {
                        adColonyZone = new AdColonyZone(string);
                    }
                    adColonyAdViewListener.onRequestNotFilled(adColonyZone);
                }
            });
        }
        return false;
    }

    static void a(Context context, AdColonyAppOptions adColonyAppOptions) {
        if (adColonyAppOptions == null || context == null) {
            return;
        }
        String string = at.b(context);
        String string2 = at.b();
        int n2 = at.c();
        String string3 = com.adcolony.sdk.a.a().m().i();
        String string4 = "none";
        if (com.adcolony.sdk.a.a().p().a()) {
            string4 = "wifi";
        } else if (com.adcolony.sdk.a.a().p().b()) {
            string4 = "mobile";
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sessionId", "unknown");
        hashMap.put("advertiserId", "unknown");
        hashMap.put("countryLocale", Locale.getDefault().getDisplayLanguage() + " (" + Locale.getDefault().getDisplayCountry() + ")");
        hashMap.put("countryLocalShort", com.adcolony.sdk.a.a().m().w());
        hashMap.put("manufacturer", com.adcolony.sdk.a.a().m().z());
        hashMap.put("model", com.adcolony.sdk.a.a().m().A());
        hashMap.put("osVersion", com.adcolony.sdk.a.a().m().B());
        hashMap.put("carrierName", string3);
        hashMap.put("networkType", string4);
        hashMap.put("platform", "android");
        hashMap.put("appName", string);
        hashMap.put("appVersion", string2);
        hashMap.put("appBuildNumber", n2);
        hashMap.put("appId", "" + adColonyAppOptions.a());
        hashMap.put("apiLevel", Build.VERSION.SDK_INT);
        hashMap.put("sdkVersion", com.adcolony.sdk.a.a().m().F());
        hashMap.put("controllerVersion", "unknown");
        hashMap.put("zoneIds", adColonyAppOptions.c());
        JSONObject jSONObject = adColonyAppOptions.getMediationInfo();
        JSONObject jSONObject2 = adColonyAppOptions.getPluginInfo();
        if (!u.b(jSONObject, "mediation_network").equals("")) {
            hashMap.put("mediationNetwork", u.b(jSONObject, "mediation_network"));
            hashMap.put("mediationNetworkVersion", u.b(jSONObject, "mediation_network_version"));
        }
        if (!u.b(jSONObject2, "plugin").equals("")) {
            hashMap.put("plugin", u.b(jSONObject2, "plugin"));
            hashMap.put("pluginVersion", u.b(jSONObject2, "plugin_version"));
        }
        y.a(hashMap);
    }

    static void b() {
        new w.a().a("The AdColony API is not available while AdColony is disabled.").a(w.g);
    }
}

