/*
 * Decompiled with CFR 0.152.
 */
package com.adarshr.gradle.testlogger;

import com.adarshr.gradle.testlogger.TestLoggerExtension;
import com.adarshr.gradle.testlogger.util.TimeUtils;
import groovy.lang.Delegate;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.api.tasks.testing.TestResult;

public class TestResultWrapper
implements TestResult,
GroovyObject {
    @Delegate
    private final TestResult testResult;
    private final TestLoggerExtension testLoggerExtension;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public TestResultWrapper(TestResult testResult, TestLoggerExtension testLoggerExtension) {
        TestLoggerExtension testLoggerExtension2;
        TestResult testResult2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.testResult = testResult2 = testResult;
        this.testLoggerExtension = testLoggerExtension2 = testLoggerExtension;
    }

    public boolean isLoggable() {
        return this.testLoggerExtension.getShowPassed() && DefaultTypeTransformation.booleanUnbox((Object)this.testResult.getSuccessfulTestCount()) || this.testLoggerExtension.getShowSkipped() && (ScriptBytecodeAdapter.compareEqual((Object)this.testResult.getResultType(), (Object)TestResult.ResultType.SKIPPED) || DefaultTypeTransformation.booleanUnbox((Object)this.testResult.getSkippedTestCount())) || this.testLoggerExtension.getShowFailed() && DefaultTypeTransformation.booleanUnbox((Object)this.testResult.getFailedTestCount());
    }

    public boolean isStandardStreamLoggable() {
        return this.isLoggable() && this.testLoggerExtension.getShowStandardStreams() && (this.testLoggerExtension.getShowPassedStandardStreams() && DefaultTypeTransformation.booleanUnbox((Object)this.testResult.getSuccessfulTestCount()) || this.testLoggerExtension.getShowSkippedStandardStreams() && DefaultTypeTransformation.booleanUnbox((Object)this.testResult.getSkippedTestCount()) || this.testLoggerExtension.getShowFailedStandardStreams() && DefaultTypeTransformation.booleanUnbox((Object)this.testResult.getFailedTestCount()));
    }

    public boolean isTooSlow() {
        return this.testResult.getEndTime() - this.testResult.getStartTime() >= this.testLoggerExtension.getSlowThreshold();
    }

    public boolean isMediumSlow() {
        return ScriptBytecodeAdapter.compareGreaterThanEqual((Object)(this.testResult.getEndTime() - this.testResult.getStartTime()), (Object)NumberNumberDiv.div((Number)this.testLoggerExtension.getSlowThreshold(), (Number)2));
    }

    public String getDuration() {
        return TimeUtils.humanDuration(this.testResult.getEndTime() - this.testResult.getStartTime());
    }

    public List<Throwable> getExceptions() {
        return this.testResult.getExceptions();
    }

    public long getFailedTestCount() {
        return this.testResult.getFailedTestCount();
    }

    public long getSkippedTestCount() {
        return this.testResult.getSkippedTestCount();
    }

    public long getTestCount() {
        return this.testResult.getTestCount();
    }

    public long getSuccessfulTestCount() {
        return this.testResult.getSuccessfulTestCount();
    }

    public long getStartTime() {
        return this.testResult.getStartTime();
    }

    public TestResult.ResultType getResultType() {
        return this.testResult.getResultType();
    }

    public long getEndTime() {
        return this.testResult.getEndTime();
    }

    public Throwable getException() {
        return this.testResult.getException();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TestResultWrapper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

