/*
 * Decompiled with CFR 0.152.
 */
package com.adaptr.android.playersdk.models;

import com.adaptr.android.playersdk.models.AudioFile;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\b\u0010\"\u001a\u0004\u0018\u00010\u0005J\b\u0010#\u001a\u0004\u0018\u00010\u0005J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050%R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00078\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\t\"\u0004\b\u001a\u0010\u000b\u00a8\u0006("}, d2={"Lcom/adaptr/android/playersdk/models/PlayList;", "", "()V", "currentPlayList", "", "Lcom/adaptr/android/playersdk/models/AudioFile;", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "listener", "Lcom/adaptr/android/playersdk/models/PlayList$PlayListListener;", "getListener$PlayerSdk_exoDefaultRelease", "()Lcom/adaptr/android/playersdk/models/PlayList$PlayListListener;", "setListener$PlayerSdk_exoDefaultRelease", "(Lcom/adaptr/android/playersdk/models/PlayList$PlayListListener;)V", "name", "getName", "setName", "decrementIndex", "", "first", "incrementIndex", "isEmpty", "", "isNotEmpty", "last", "next", "toList", "", "Editor", "PlayListListener", "PlayerSdk_exoDefaultRelease"})
public final class PlayList {
    @SerializedName(value="id")
    @NotNull
    public String id;
    @SerializedName(value="name")
    @NotNull
    public String name;
    @SerializedName(value="audio_files")
    private List<AudioFile> currentPlayList = new ArrayList();
    @Nullable
    private PlayListListener listener;
    private int index;

    @NotNull
    public final String getId() {
        String string = this.id;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"id");
        }
        return string;
    }

    public final void setId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.id = string;
    }

    @NotNull
    public final String getName() {
        String string = this.name;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
        }
        return string;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Nullable
    public final PlayListListener getListener$PlayerSdk_exoDefaultRelease() {
        return this.listener;
    }

    public final void setListener$PlayerSdk_exoDefaultRelease(@Nullable PlayListListener playListListener) {
        this.listener = playListListener;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final boolean isEmpty() {
        return this.currentPlayList.isEmpty();
    }

    public final boolean isNotEmpty() {
        Collection collection = this.currentPlayList;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @Nullable
    public final AudioFile first() {
        return this.isNotEmpty() ? (AudioFile)CollectionsKt.first(this.currentPlayList) : null;
    }

    @Nullable
    public final AudioFile last() {
        return this.isNotEmpty() ? (AudioFile)CollectionsKt.last(this.currentPlayList) : null;
    }

    @NotNull
    public final List<AudioFile> toList() {
        return CollectionsKt.toList((Iterable)this.currentPlayList);
    }

    @Nullable
    public final AudioFile next() {
        if (this.isNotEmpty()) {
            return (AudioFile)CollectionsKt.getOrNull(this.currentPlayList, (int)this.index);
        }
        return null;
    }

    public final void incrementIndex() {
        int n = this.index;
        this.index = n + 1;
    }

    public final void decrementIndex() {
        switch (this.index) {
            case 1: {
                this.index = 0;
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.index -= 2;
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\t\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nJ\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u0004J\u0006\u0010\u0011\u001a\u00020\u0004J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a8\u0006\u0013"}, d2={"Lcom/adaptr/android/playersdk/models/PlayList$Editor;", "", "(Lcom/adaptr/android/playersdk/models/PlayList;)V", "addToPlayList", "", "file", "Lcom/adaptr/android/playersdk/models/AudioFile;", "index", "", "activePlayList", "", "clearPlayList", "moveItemToIndex", "audioFile", "pos", "removeFromPlaylist", "saveChanges", "shufflePlaylist", "viewCurrentPlayList", "PlayerSdk_exoDefaultRelease"})
    public final class Editor {
        @NotNull
        public final List<AudioFile> viewCurrentPlayList() {
            return CollectionsKt.toList((Iterable)PlayList.this.currentPlayList);
        }

        public final void clearPlayList() {
            PlayList.this.currentPlayList.clear();
        }

        public final void addToPlayList(@NotNull AudioFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PlayList.this.currentPlayList.add(file);
        }

        public final void addToPlayList(@NotNull AudioFile file, int index) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PlayList.this.currentPlayList.add(index, file);
        }

        public final void addToPlayList(@NotNull List<AudioFile> activePlayList) {
            Intrinsics.checkNotNullParameter(activePlayList, (String)"activePlayList");
            PlayList.this.currentPlayList.addAll((Collection)activePlayList);
        }

        public final void removeFromPlaylist(@NotNull AudioFile audioFile) {
            Intrinsics.checkNotNullParameter((Object)audioFile, (String)"audioFile");
            AudioFile temp = null;
            for (AudioFile file : PlayList.this.currentPlayList) {
                if (!Intrinsics.areEqual((Object)file, (Object)audioFile)) continue;
                temp = file;
                break;
            }
            if (temp != null) {
                PlayList.this.currentPlayList.remove(temp);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void moveItemToIndex(@NotNull AudioFile audioFile, int pos) {
            Intrinsics.checkNotNullParameter((Object)audioFile, (String)"audioFile");
            Integer index = null;
            boolean bl = false;
            for (AudioFile file : (Iterable)PlayList.this.currentPlayList) {
                void inde;
                if (Intrinsics.areEqual((Object)file, (Object)audioFile)) {
                    index = (int)inde;
                    break;
                }
                ++inde;
            }
            if (index != null) {
                PlayList.this.currentPlayList.remove(index);
                PlayList.this.currentPlayList.add(pos, audioFile);
            }
        }

        public final void shufflePlaylist() {
            Random random1 = new Random();
            kotlin.random.Random random = RandomKt.Random((int)random1.nextInt());
            PlayList.this.currentPlayList = CollectionsKt.toMutableList((Collection)CollectionsKt.shuffled((Iterable)PlayList.this.currentPlayList, (kotlin.random.Random)random));
        }

        public final void saveChanges() {
            block0: {
                PlayListListener playListListener = PlayList.this.getListener$PlayerSdk_exoDefaultRelease();
                if (playListListener == null) break block0;
                playListListener.onPlaylistChanged(PlayList.this);
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/adaptr/android/playersdk/models/PlayList$PlayListListener;", "", "onPlaylistChanged", "", "currentPlayList", "Lcom/adaptr/android/playersdk/models/PlayList;", "PlayerSdk_exoDefaultRelease"})
    public static interface PlayListListener {
        public void onPlaylistChanged(@NotNull PlayList var1);
    }
}

