/*
 * Decompiled with CFR 0.152.
 */
package com.adaptr.android.playersdk;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.adaptr.android.playersdk.ADLog;
import com.adaptr.android.playersdk.CacheMediaListener;
import com.adaptr.android.playersdk.ExoMixingAudioPlayer;
import com.adaptr.android.playersdk.ExoMixingAudioPlayer$Companion$WhenMappings;
import com.adaptr.android.playersdk.MixingAudioPlayer;
import com.adaptr.android.playersdk.State;
import com.adaptr.android.playersdk.models.AudioFile;
import com.adaptr.android.playersdk.models.Play;
import com.adaptr.android.playersdk.models.Station;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.upstream.cache.SimpleCache;
import fm.feed.android.playersdk.PlayerProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00cb\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f*\u0003?DH\u0018\u0000 \u0097\u00012\u00020\u0001:\u0006\u0097\u0001\u0098\u0001\u0099\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\u001cH\u0016J \u0010^\u001a\u00020\\2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u0002052\u0006\u0010\u0004\u001a\u00020bH\u0016J\u0012\u0010c\u001a\u00020\\2\b\u0010d\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010e\u001a\u00020f2\u0006\u0010_\u001a\u00020`H\u0002J\u0010\u0010g\u001a\u00020h2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010i\u001a\u00020\\H\u0016J\u0010\u0010j\u001a\u00020\r2\u0006\u0010k\u001a\u00020lH\u0002J\b\u0010m\u001a\u00020\\H\u0016J\u0010\u0010n\u001a\u00020\\2\u0006\u0010o\u001a\u00020\rH\u0016J\u0010\u0010p\u001a\u00020`2\u0006\u0010_\u001a\u00020`H\u0002J\u0012\u0010q\u001a\u00020r2\b\u0010d\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010s\u001a\u00020\rH\u0002J\b\u0010t\u001a\u00020\rH\u0002J\b\u0010u\u001a\u00020\u000bH\u0016J\b\u0010v\u001a\u00020\\H\u0016J\b\u0010d\u001a\u00020\\H\u0016J\u0010\u0010w\u001a\u00020\r2\u0006\u0010x\u001a\u00020\rH\u0002J\u0010\u0010y\u001a\u00020\\2\u0006\u0010z\u001a\u00020\u001cH\u0016J\b\u0010{\u001a\u00020\\H\u0002J\b\u0010|\u001a\u00020\\H\u0002J\u0006\u0010}\u001a\u00020\\J\b\u0010~\u001a\u00020\\H\u0002J\b\u0010\u007f\u001a\u00020\\H\u0002J\u0012\u0010\u0080\u0001\u001a\u00020\\2\u0007\u0010\u0081\u0001\u001a\u00020\u000bH\u0016J\u0011\u0010\u0082\u0001\u001a\u00020\\2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0083\u0001\u001a\u00020\\2\u0007\u0010\u0084\u0001\u001a\u00020\rJ\t\u0010\u0085\u0001\u001a\u00020\\H\u0016J0\u0010\u0086\u0001\u001a\u00020\\2\u0007\u0010\u0087\u0001\u001a\u00020\u001c2\u0007\u0010\u0088\u0001\u001a\u0002052\u0013\b\u0002\u0010\u0089\u0001\u001a\f\u0018\u00010\u008a\u0001j\u0005\u0018\u0001`\u008b\u0001H\u0002J\t\u0010\u008c\u0001\u001a\u00020\\H\u0016J\t\u0010\u008d\u0001\u001a\u00020\\H\u0002J\t\u0010\u008e\u0001\u001a\u00020\\H\u0002J\u001d\u0010\u008f\u0001\u001a\u00020\\2\u0007\u0010\u0087\u0001\u001a\u00020\u001c2\t\b\u0002\u0010\u0090\u0001\u001a\u000205H\u0002J\u0012\u0010\u0091\u0001\u001a\u00020\\2\u0007\u0010\u0087\u0001\u001a\u00020\u001cH\u0002J\t\u0010\u0092\u0001\u001a\u00020\\H\u0002J\t\u0010\u0093\u0001\u001a\u00020\\H\u0002J\t\u0010\u0094\u0001\u001a\u00020`H\u0016J\u0012\u0010\u0095\u0001\u001a\u00020\r2\u0007\u0010\u0096\u0001\u001a\u00020NH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R(\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R$\u0010'\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010$\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010-\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00106\u001a\u000607R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00108\u001a\u000607R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020\u001c0:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010;\u001a\u000607R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010<\u001a\u00060=R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010@R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010ER\u000e\u0010F\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010IR\u000e\u0010J\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010K\u001a\u0004\u0018\u00010LX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010M\u001a\u00020NX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u0018\u0010S\u001a\f\u0012\b\u0012\u00060=R\u00020\u00000TX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010V\u001a\u00020\u000b2\u0006\u0010U\u001a\u00020\u000b@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010$\"\u0004\bX\u0010*R\u000e\u0010Y\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009a\u0001"}, d2={"Lcom/adaptr/android/playersdk/ExoMixingAudioPlayer;", "Lcom/adaptr/android/playersdk/MixingAudioPlayer;", "context", "Landroid/content/Context;", "listener", "Lcom/adaptr/android/playersdk/MixingAudioPlayer$EventListener;", "looper", "Landroid/os/Looper;", "(Landroid/content/Context;Lcom/adaptr/android/playersdk/MixingAudioPlayer$EventListener;Landroid/os/Looper;)V", "(Landroid/content/Context;Landroid/os/Looper;)V", "_fadeDuration", "", "bIsFadingout", "", "bPaused", "bTimeFlag", "bTrimmingEnabled", "getBTrimmingEnabled", "()Z", "setBTrimmingEnabled", "(Z)V", "bisPlaying", "getContext", "()Landroid/content/Context;", "crossFadeInEnabled", "getCrossFadeInEnabled", "setCrossFadeInEnabled", "value", "Lcom/adaptr/android/playersdk/models/Play;", "currentPlay", "getCurrentPlay", "()Lcom/adaptr/android/playersdk/models/Play;", "setCurrentPlay", "(Lcom/adaptr/android/playersdk/models/Play;)V", "currentPlayDuration", "getCurrentPlayDuration", "()F", "currentPlayTime", "getCurrentPlayTime", "fadeDuration", "getFadeDuration", "setFadeDuration", "(F)V", "log", "Lcom/adaptr/android/playersdk/ADLog;", "mEventListener", "getMEventListener", "()Lcom/adaptr/android/playersdk/MixingAudioPlayer$EventListener;", "setMEventListener", "(Lcom/adaptr/android/playersdk/MixingAudioPlayer$EventListener;)V", "mMainHandler", "Landroid/os/Handler;", "mMinimumDurationForCrossFade", "", "mPreparingPlayer", "Lcom/adaptr/android/playersdk/ExoMixingAudioPlayer$PlayAndPlayer;", "mPrimaryPlayer", "mQueuedAudioAssets", "Ljava/util/LinkedList;", "mSecondaryPlayer", "mTimeTracker", "Lcom/adaptr/android/playersdk/ExoMixingAudioPlayer$TimeTracker;", "preparingEventListener", "com/adaptr/android/playersdk/ExoMixingAudioPlayer$preparingEventListener$1", "Lcom/adaptr/android/playersdk/ExoMixingAudioPlayer$preparingEventListener$1;", "preparingPlayerProxy", "Lfm/feed/android/playersdk/PlayerProxy;", "primaryEventListener", "com/adaptr/android/playersdk/ExoMixingAudioPlayer$primaryEventListener$1", "Lcom/adaptr/android/playersdk/ExoMixingAudioPlayer$primaryEventListener$1;", "primaryPlayerProxy", "secondaryEventListener", "com/adaptr/android/playersdk/ExoMixingAudioPlayer$secondaryEventListener$1", "Lcom/adaptr/android/playersdk/ExoMixingAudioPlayer$secondaryEventListener$1;", "secondaryPlayerProxy", "simpleCache", "Lcom/google/android/exoplayer2/upstream/cache/SimpleCache;", "state", "Lcom/adaptr/android/playersdk/State;", "getState", "()Lcom/adaptr/android/playersdk/State;", "setState", "(Lcom/adaptr/android/playersdk/State;)V", "tracker", "Ljava/util/ArrayList;", "newVolume", "volume", "getVolume", "setVolume", "volumeMax", "volumeMin", "addAudioAsset", "", "audioFile", "cacheMedia", "url", "", "maxCache", "Lcom/adaptr/android/playersdk/CacheMediaListener;", "calculateFinalTime", "play", "createMediaSource", "Lcom/google/android/exoplayer2/source/MediaSource;", "createSimpleExoPlayer", "Lcom/google/android/exoplayer2/SimpleExoPlayer;", "destroy", "enThread", "r", "Ljava/lang/Runnable;", "flush", "flushAndIncludeCurrent", "includeCurrent", "getKey", "getTrackFinalTime", "", "loadPrimaryPlayer", "loadSecondaryPlayer", "maxSeekableLengthInSeconds", "pause", "preparePlayer", "playWhenReady", "prepareTrack", "file", "primaryPlayerCompleted", "processUpdate", "resetToBeginning", "scheduleFadeOutAndFadeIn", "scheduleFadeOutNoFadeIn", "seekTo", "position", "setMixingAudioPlayerEventListener", "setTrimmingEnabled", "enabled", "skip", "skipCurrent", "previousPlay", "reason", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "skipWithCrossFade", "startFadeIn", "startFadeOut", "startFadeOutAndFadeIn", "completionReason", "startFadeOutNoFadeIn", "switchPlayerReferences", "switchPreparingReferences", "toString", "updateToState", "newState", "Companion", "PlayAndPlayer", "TimeTracker", "PlayerSdk_exoDefaultRelease"})
public final class ExoMixingAudioPlayer
implements MixingAudioPlayer {
    private final ADLog log;
    private int mMinimumDurationForCrossFade;
    private float volume;
    private float _fadeDuration;
    private boolean bTimeFlag;
    private boolean bPaused;
    private boolean bisPlaying;
    private boolean bIsFadingout;
    private boolean bTrimmingEnabled;
    private boolean crossFadeInEnabled;
    private PlayAndPlayer mPrimaryPlayer;
    private PlayAndPlayer mSecondaryPlayer;
    private final PlayerProxy primaryPlayerProxy;
    private final PlayerProxy secondaryPlayerProxy;
    private final PlayerProxy preparingPlayerProxy;
    private PlayAndPlayer mPreparingPlayer;
    @NotNull
    private State state;
    @Nullable
    private MixingAudioPlayer.EventListener mEventListener;
    private final LinkedList<Play> mQueuedAudioAssets;
    private final TimeTracker mTimeTracker;
    private SimpleCache simpleCache;
    private Handler mMainHandler;
    private final ArrayList<TimeTracker> tracker;
    private final primaryEventListener.1 primaryEventListener;
    private final secondaryEventListener.1 secondaryEventListener;
    private final preparingEventListener.1 preparingEventListener;
    private float volumeMin;
    private float volumeMax;
    @NotNull
    private final Context context;
    private static final int UPDATE_MESSAGE = 1;
    private static final int CANCEL_MESSAGE = 2;
    private static final int FADE_INTERVAL = 100;
    private static final int UPDATE_INTERVAL = 500;
    public static final Companion Companion = new Companion(null);

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(float newVolume) {
        if (this.enThread(new Runnable(this, newVolume){
            final /* synthetic */ ExoMixingAudioPlayer this$0;
            final /* synthetic */ float $newVolume;

            public final void run() {
                this.this$0.setVolume(this.$newVolume);
            }
            {
                this.this$0 = exoMixingAudioPlayer;
                this.$newVolume = f;
            }
        })) {
            return;
        }
        this.volume = newVolume > 1.0f ? 1.0f : (newVolume < 0.0f ? 0.0f : newVolume);
        Object object = this.mPrimaryPlayer.getPlay();
        Float activeStationPregain = object != null && (object = ((Play)object).getStation()) != null ? Float.valueOf(((Station)object).getPreGain()) : null;
        Object object2 = this.mPrimaryPlayer.getPlay();
        Float primaryPlayerAudioFileReplayGain = object2 != null && (object2 = ((Play)object2).getAudioFile()) != null ? Float.valueOf(((AudioFile)object2).getReplayGain()) : null;
        this.mPrimaryPlayer.getPlayer().setVolume(newVolume);
        this.mPrimaryPlayer.setPlayingVolume(newVolume);
    }

    @Override
    public float getFadeDuration() {
        return this._fadeDuration / (float)1000;
    }

    @Override
    public void setFadeDuration(float value) {
        this._fadeDuration = value * (float)1000;
        this.mMinimumDurationForCrossFade = (int)(this._fadeDuration + (float)1000);
    }

    @Override
    public boolean getBTrimmingEnabled() {
        return this.bTrimmingEnabled;
    }

    @Override
    public void setBTrimmingEnabled(boolean bl) {
        this.bTrimmingEnabled = bl;
    }

    public final boolean getCrossFadeInEnabled() {
        return this.crossFadeInEnabled;
    }

    public final void setCrossFadeInEnabled(boolean bl) {
        this.crossFadeInEnabled = bl;
    }

    @Override
    @NotNull
    public State getState() {
        return this.state;
    }

    @Override
    public void setState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    @Override
    @Nullable
    public MixingAudioPlayer.EventListener getMEventListener() {
        return this.mEventListener;
    }

    @Override
    public void setMEventListener(@Nullable MixingAudioPlayer.EventListener eventListener) {
        this.mEventListener = eventListener;
    }

    @Override
    @Nullable
    public Play getCurrentPlay() {
        return this.mPrimaryPlayer.getPlay();
    }

    public void setCurrentPlay(@Nullable Play value) {
        this.mPrimaryPlayer.setPlay(value);
    }

    @Override
    public float getCurrentPlayTime() {
        return this.mPrimaryPlayer.getPlay() == null ? 0.0f : (float)this.mPrimaryPlayer.getPlayer().getCurrentPosition() / 1000.0f;
    }

    @Override
    public float getCurrentPlayDuration() {
        return this.mPrimaryPlayer.getPlay() == null ? 0.0f : (float)this.mPrimaryPlayer.getPlayer().getDuration() / 1000.0f;
    }

    @Override
    public void destroy() {
        this.mPrimaryPlayer.getPlayer().release();
        this.mSecondaryPlayer.getPlayer().release();
        this.flush();
    }

    private final boolean enThread(Runnable r) {
        Handler handler = this.mMainHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mMainHandler");
        }
        if (Intrinsics.areEqual((Object)handler.getLooper(), (Object)Looper.myLooper()) ^ true) {
            Handler handler2 = this.mMainHandler;
            if (handler2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mMainHandler");
            }
            handler2.post(r);
            ADLog.v$default(this.log, "Switching thread to main for this call", null, 2, null);
            return true;
        }
        return false;
    }

    public final void setMixingAudioPlayerEventListener(@Nullable MixingAudioPlayer.EventListener listener2) {
        this.setMEventListener(listener2);
    }

    public final void setTrimmingEnabled(boolean enabled) {
        this.setBTrimmingEnabled(enabled);
    }

    private final boolean updateToState(State newState) {
        block1: {
            if (newState == this.getState()) {
                ADLog.v$default(this.log, "ignoring transition to the same state (" + ExoMixingAudioPlayer.Companion.stateToString(newState) + ")", null, 2, null);
                return false;
            }
            ADLog.d$default(this.log, "Changing state " + ExoMixingAudioPlayer.Companion.stateToString(this.getState()) + " -> " + ExoMixingAudioPlayer.Companion.stateToString(newState), null, 2, null);
            this.setState(newState);
            MixingAudioPlayer.EventListener eventListener = this.getMEventListener();
            if (eventListener == null) break block1;
            eventListener.onPlayerStateChanged(newState);
        }
        return true;
    }

    private final void calculateFinalTime(Play play2) {
        if (play2 != null) {
            for (TimeTracker track : this.tracker) {
                if (!Intrinsics.areEqual((Object)track.getId(), (Object)play2.getAudioFile().getUrl()) || track.getBufferingEndTime() != 0L) continue;
                track.setBufferingEndTime(System.currentTimeMillis());
            }
        }
    }

    private final long getTrackFinalTime(Play play2) {
        TimeTracker tTracker = null;
        if (play2 != null) {
            for (TimeTracker timeTracker : this.tracker) {
                if (!Intrinsics.areEqual((Object)timeTracker.getId(), (Object)play2.getAudioFile().getUrl())) continue;
                tTracker = timeTracker;
            }
        }
        Collection collection = this.tracker;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)collection2).remove(tTracker);
        long l = 0L;
        if (tTracker != null) {
            l = tTracker.getBufferingEndTime() - tTracker.getBufferingStartTime();
        }
        return l < 0L ? 0L : l;
    }

    private final String getKey(String url) {
        String key = url;
        if (StringsKt.contains$default((CharSequence)url, (CharSequence)"?", (boolean)false, (int)2, null)) {
            String string = url;
            int n = 0;
            int n2 = StringsKt.indexOf$default((CharSequence)url, (String)"?", (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            key = string3;
        }
        return key;
    }

    private final SimpleExoPlayer createSimpleExoPlayer(Looper looper) {
        return PlayerProxy.Companion.createSimpleExoplayer(this.context, looper);
    }

    @Override
    public void prepareTrack(@NotNull Play file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.enThread(new Runnable(this, file){
            final /* synthetic */ ExoMixingAudioPlayer this$0;
            final /* synthetic */ Play $file;

            public final void run() {
                this.this$0.prepareTrack(this.$file);
            }
            {
                this.this$0 = exoMixingAudioPlayer;
                this.$file = play2;
            }
        })) {
            return;
        }
        ADLog.d$default(this.log, "prepareTrack", null, 2, null);
        this.mPreparingPlayer.setPlay(file);
        MediaSource source2 = this.createMediaSource(file.getAudioFile().getUrl());
        this.mPreparingPlayer.getPlayer().prepare(source2);
        if (this.getBTrimmingEnabled() && file.getAudioFile().getStartTrim() > 0.0f && file.getAudioFile().getStartTrim() < file.getAudioFile().getDurationInSeconds()) {
            this.mPreparingPlayer.getPlayer().seekTo((long)(file.getAudioFile().getStartTrim() * (float)1000));
        }
        this.mPreparingPlayer.getPlayer().setPlayWhenReady(false);
    }

    @Override
    public void cacheMedia(@NotNull String url, int maxCache, @NotNull CacheMediaListener listener2) {
        Boolean isCached;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ADLog.d$default(this.log, "Start caching " + url, null, 2, null);
        SimpleCache simpleCache = this.simpleCache;
        Boolean bl = isCached = simpleCache != null ? Boolean.valueOf(simpleCache.isCached(this.getKey(url), 0L, (long)maxCache)) : null;
        if (Intrinsics.areEqual(isCached, (Object)true)) {
            listener2.onCacheTransferEnded();
            return;
        }
        DataSource.Factory dataSourceFactory = PlayerProxy.Companion.dataSourceFactoryCreator$PlayerSdk_exoDefaultRelease(this.context, listener2);
        DataSpec dataSpec = PlayerProxy.Companion.createDataSpec$PlayerSdk_exoDefaultRelease(url, maxCache, this.getKey(url));
        ADLog.d$default(this.log, "Start caching " + url, null, 2, null);
        new Thread(new Runnable(this, dataSourceFactory, dataSpec, listener2){
            final /* synthetic */ ExoMixingAudioPlayer this$0;
            final /* synthetic */ DataSource.Factory $dataSourceFactory;
            final /* synthetic */ DataSpec $dataSpec;
            final /* synthetic */ CacheMediaListener $listener;

            public final void run() {
                try {
                    SimpleCache simpleCache = ExoMixingAudioPlayer.access$getSimpleCache$p(this.this$0);
                    Intrinsics.checkNotNull((Object)simpleCache);
                    PlayerProxy.Companion.cache$PlayerSdk_exoDefaultRelease(this.$dataSourceFactory, this.$dataSpec, (Cache)simpleCache, new byte[131072], false, new AtomicBoolean(false), this.$listener);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            {
                this.this$0 = exoMixingAudioPlayer;
                this.$dataSourceFactory = factory2;
                this.$dataSpec = dataSpec;
                this.$listener = cacheMediaListener;
            }
        }).start();
    }

    private final MediaSource createMediaSource(String url) {
        TimeTracker timeTracker = new TimeTracker(url);
        timeTracker.setBufferingStartTime(System.currentTimeMillis());
        timeTracker.setBufferingEndTime(0L);
        this.tracker.add(timeTracker);
        DataSource.Factory dataSourceFactory = PlayerProxy.Companion.dataSourceFactoryCreator$PlayerSdk_exoDefaultRelease(this.context, null);
        MediaSource mediaSource = null;
        Uri uri = Uri.parse((String)url);
        SimpleCache simpleCache = this.simpleCache;
        Intrinsics.checkNotNull((Object)simpleCache);
        CacheDataSource.Factory source2 = PlayerProxy.Companion.createDateSourceFactory((Cache)simpleCache, dataSourceFactory);
        Uri uri2 = uri;
        Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"uri");
        mediaSource = PlayerProxy.Companion.getExtractorMediaSource(source2, uri2, this.getKey(url));
        return mediaSource;
    }

    public final void resetToBeginning() {
        if (this.enThread(new Runnable(this){
            final /* synthetic */ ExoMixingAudioPlayer this$0;

            public final void run() {
                this.this$0.resetToBeginning();
            }
            {
                this.this$0 = exoMixingAudioPlayer;
            }
        })) {
            return;
        }
        this.mPrimaryPlayer.getPlayer().seekTo(0L);
    }

    @Override
    public void seekTo(float position) {
        if (this.enThread(new Runnable(this, position){
            final /* synthetic */ ExoMixingAudioPlayer this$0;
            final /* synthetic */ float $position;

            public final void run() {
                this.this$0.seekTo(this.$position);
            }
            {
                this.this$0 = exoMixingAudioPlayer;
                this.$position = f;
            }
        })) {
            return;
        }
        float pos = position;
        if (pos > this.maxSeekableLengthInSeconds()) {
            pos = this.maxSeekableLengthInSeconds();
        }
        pos *= 1000.0f;
        if ((float)this.mPrimaryPlayer.getPlayer().getDuration() > pos) {
            this.mPrimaryPlayer.getPlayer().seekTo((long)pos + (long)this.getCurrentPlayTime());
        } else {
            long secondaryPosition = (long)pos - (this.mPrimaryPlayer.getPlayer().getDuration() - this.mPrimaryPlayer.getPlayer().getCurrentPosition());
            if (secondaryPosition < this.mSecondaryPlayer.getPlayer().getDuration()) {
                this.mSecondaryPlayer.getPlayer().seekTo(secondaryPosition);
                Play primaryPlay = this.mPrimaryPlayer.getPlay();
                if (primaryPlay != null) {
                    ExoMixingAudioPlayer.skipCurrent$default(this, primaryPlay, 1, null, 4, null);
                }
            }
        }
    }

    @Override
    public float maxSeekableLengthInSeconds() {
        long length = this.mPrimaryPlayer.getPlayer().getDuration() - this.mPrimaryPlayer.getPlayer().getCurrentPosition();
        if (this.mSecondaryPlayer.getBReadyForPlayback() && !this.mSecondaryPlayer.getBStartHasBeenReported()) {
            length += this.mSecondaryPlayer.getPlayer().getDuration() - (long)5000;
        }
        return (float)length / 1000.0f;
    }

    @Override
    public void addAudioAsset(@NotNull Play audioFile) {
        Intrinsics.checkNotNullParameter((Object)audioFile, (String)"audioFile");
        if (this.enThread(new Runnable(this, audioFile){
            final /* synthetic */ ExoMixingAudioPlayer this$0;
            final /* synthetic */ Play $audioFile;

            public final void run() {
                this.this$0.addAudioAsset(this.$audioFile);
            }
            {
                this.this$0 = exoMixingAudioPlayer;
                this.$audioFile = play2;
            }
        })) {
            return;
        }
        ADLog.d$default(this.log, "adding new audio asset " + audioFile, null, 2, null);
        this.mQueuedAudioAssets.add(audioFile);
        this.preparePlayer(this.bisPlaying);
    }

    private final boolean preparePlayer(boolean playWhenReady) {
        ADLog.i$default(this.log, "preparePlayer", null, 2, null);
        if (this.bIsFadingout) {
            return false;
        }
        Play preparingPlay = this.mPreparingPlayer.getPlay();
        Play firstQueuedAudioAsset = this.mQueuedAudioAssets.peek();
        if (preparingPlay != null && firstQueuedAudioAsset != null && Intrinsics.areEqual((Object)firstQueuedAudioAsset.getId(), (Object)preparingPlay.getId())) {
            if (playWhenReady) {
                this.mQueuedAudioAssets.remove(firstQueuedAudioAsset);
                this.switchPreparingReferences();
                this.mPrimaryPlayer.getPlayer().setPlayWhenReady(true);
            }
            return true;
        }
        if (playWhenReady && this.mPrimaryPlayer.getPlay() == null) {
            return this.loadPrimaryPlayer();
        }
        if (this.mPrimaryPlayer.getPlay() == null && this.mSecondaryPlayer.getPlay() == null && !this.bIsFadingout) {
            return this.loadSecondaryPlayer();
        }
        return false;
    }

    private final boolean loadPrimaryPlayer() {
        ADLog.i$default(this.log, "trying to load primary player", null, 2, null);
        if (this.mQueuedAudioAssets.size() > 0 && !this.bIsFadingout) {
            Play file = this.mQueuedAudioAssets.poll();
            if (file != null) {
                MediaSource source2 = this.createMediaSource(file.getAudioFile().getUrl());
                this.mPrimaryPlayer.setPlay(file);
                this.mPrimaryPlayer.getPlayer().prepare(source2);
                if (this.getBTrimmingEnabled() && file.getAudioFile().getStartTrim() > 0.0f && file.getAudioFile().getStartTrim() < file.getAudioFile().getDurationInSeconds()) {
                    this.mPrimaryPlayer.getPlayer().seekTo((long)(file.getAudioFile().getStartTrim() * (float)1000));
                }
                this.mPrimaryPlayer.getPlayer().setPlayWhenReady(true);
                ADLog.d$default(this.log, "Loaded a song into player, and playing when ready", null, 2, null);
                return true;
            }
        } else {
            ADLog.d$default(this.log, "Nothing to load into primary player", null, 2, null);
        }
        return false;
    }

    private final boolean loadSecondaryPlayer() {
        ADLog.i$default(this.log, "trying to load secondary player", null, 2, null);
        if (this.mQueuedAudioAssets.size() > 0 && !this.bIsFadingout) {
            Play file;
            Play play2 = file = this.mQueuedAudioAssets.poll();
            if ((play2 != null ? play2.getAudioFile() : null) == null) {
                return false;
            }
            ADLog.d$default(this.log, "Loading secondary player with play " + file, null, 2, null);
            this.mSecondaryPlayer.setPlay(file);
            MediaSource source2 = this.createMediaSource(file.getAudioFile().getUrl());
            this.mSecondaryPlayer.getPlayer().prepare(source2);
            if (this.getBTrimmingEnabled() && file.getAudioFile().getStartTrim() > 0.0f && file.getAudioFile().getStartTrim() < file.getAudioFile().getDurationInSeconds()) {
                this.mSecondaryPlayer.getPlayer().seekTo((long)(file.getAudioFile().getStartTrim() * (float)1000));
            }
            this.mSecondaryPlayer.getPlayer().setPlayWhenReady(false);
            return true;
        }
        return false;
    }

    @Override
    public void play() {
        if (this.enThread(new Runnable(this){
            final /* synthetic */ ExoMixingAudioPlayer this$0;

            public final void run() {
                this.this$0.play();
            }
            {
                this.this$0 = exoMixingAudioPlayer;
            }
        })) {
            return;
        }
        ADLog.i$default(this.log, "Play", null, 2, null);
        if (!this.bPaused) {
            this.bTimeFlag = true;
            this.mTimeTracker.setBufferingStartTime(System.currentTimeMillis());
        }
        this.bPaused = false;
        this.bisPlaying = true;
        if (this.mPrimaryPlayer.getPlay() == null && this.mSecondaryPlayer.getPlay() != null) {
            this.switchPlayerReferences();
        }
        if (this.mPrimaryPlayer.getPlay() != null) {
            this.mPrimaryPlayer.getPlayer().setPlayWhenReady(true);
        } else {
            boolean hasAssets = this.preparePlayer(true);
            if (!hasAssets) {
                this.updateToState(State.WAITING_FOR_ITEM);
            }
        }
    }

    @Override
    public void pause() {
        if (this.enThread(new Runnable(this){
            final /* synthetic */ ExoMixingAudioPlayer this$0;

            public final void run() {
                this.this$0.pause();
            }
            {
                this.this$0 = exoMixingAudioPlayer;
            }
        })) {
            return;
        }
        ADLog.i$default(this.log, "Pause", null, 2, null);
        if (this.getState() == State.READY_TO_PLAY || this.getState() == State.PAUSED) {
            return;
        }
        this.bPaused = true;
        this.bisPlaying = false;
        Handler handler = this.mMainHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mMainHandler");
        }
        handler.sendEmptyMessage(2);
        this.mPrimaryPlayer.getPlayer().setPlayWhenReady(false);
        this.mSecondaryPlayer.getPlayer().setPlayWhenReady(false);
        this.updateToState(State.PAUSED);
    }

    @Override
    public void skip() {
        if (this.enThread(new Runnable(this){
            final /* synthetic */ ExoMixingAudioPlayer this$0;

            public final void run() {
                this.this$0.skip();
            }
            {
                this.this$0 = exoMixingAudioPlayer;
            }
        })) {
            return;
        }
        this.bPaused = false;
        Handler handler = this.mMainHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mMainHandler");
        }
        handler.sendEmptyMessageDelayed(1, (long)500);
        if (this.mPrimaryPlayer.getPlay() == null || this.bIsFadingout) {
            return;
        }
        Play primaryPlay = this.mPrimaryPlayer.getPlay();
        if (primaryPlay != null) {
            ExoMixingAudioPlayer.skipCurrent$default(this, primaryPlay, 1, null, 4, null);
        }
    }

    @Override
    public void skipWithCrossFade() {
        if (this.enThread(new Runnable(this){
            final /* synthetic */ ExoMixingAudioPlayer this$0;

            public final void run() {
                this.this$0.skipWithCrossFade();
            }
            {
                this.this$0 = exoMixingAudioPlayer;
            }
        })) {
            return;
        }
        if (this.mPrimaryPlayer.getPlay() == null || this.bIsFadingout) {
            return;
        }
        Play primaryPlayBeforeTimer = this.mPrimaryPlayer.getPlay();
        Runnable runnable2 = new Runnable(this, primaryPlayBeforeTimer){
            final /* synthetic */ ExoMixingAudioPlayer this$0;
            final /* synthetic */ Play $primaryPlayBeforeTimer;

            public final void run() {
                Play primaryPlay = ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).getPlay();
                if (Intrinsics.areEqual((Object)this.$primaryPlayBeforeTimer, (Object)primaryPlay) ^ true) {
                    ADLog.w$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "skip timer expired, but primary play changed!", null, 2, null);
                } else if (primaryPlay == null) {
                    ADLog.w$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "skip timer expired, but primary play became null!", null, 2, null);
                } else if (ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0).getBReadyForPlayback()) {
                    float songDurationLeft = primaryPlay.getAudioFile().getDurationInSeconds() - this.this$0.getCurrentPlayTime() - primaryPlay.getAudioFile().getEndTrim();
                    float durationNextSong = 0.0f;
                    Play secondaryPlay = ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0).getPlay();
                    if (secondaryPlay != null) {
                        durationNextSong = secondaryPlay.getAudioFile().getDurationInSeconds() * (float)1000 - primaryPlay.getAudioFile().getEndTrim();
                    }
                    if (ExoMixingAudioPlayer.access$get_fadeDuration$p(this.this$0) > 0.0f && songDurationLeft * (float)1000 > (float)ExoMixingAudioPlayer.access$getMMinimumDurationForCrossFade$p(this.this$0) && durationNextSong > (float)ExoMixingAudioPlayer.access$getMMinimumDurationForCrossFade$p(this.this$0)) {
                        ADLog.v$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "CrossFading to next Station, songDurationLeft =" + songDurationLeft + " durationNextSong=" + durationNextSong, null, 2, null);
                        ExoMixingAudioPlayer.access$startFadeOutAndFadeIn(this.this$0, primaryPlay, 1);
                    } else {
                        this.this$0.skip();
                        ADLog.v$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "Cannot skip with crossFade, Skipping songDurationLeft =" + songDurationLeft + " durationNextSong=" + durationNextSong, null, 2, null);
                    }
                }
            }
            {
                this.this$0 = exoMixingAudioPlayer;
                this.$primaryPlayBeforeTimer = play2;
            }
        };
        new Timer().schedule(new TimerTask(this, runnable2){
            final /* synthetic */ ExoMixingAudioPlayer this$0;
            final /* synthetic */ Runnable $runnable;

            public void run() {
                if (ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0).getBReadyForPlayback()) {
                    this.cancel();
                    ExoMixingAudioPlayer.access$getMMainHandler$p(this.this$0).post(this.$runnable);
                }
            }
            {
                this.this$0 = this$0;
                this.$runnable = $captured_local_variable$1;
            }
        }, 0L, 250L);
    }

    private final void processUpdate() {
        ADLog.v$default(this.log, "processUpdate loop. state: " + this, null, 2, null);
        if (this.getState() == State.WAITING_FOR_ITEM) {
            ADLog.d$default(this.log, "waiting for item, so cancelling update loop", null, 2, null);
            Handler handler = this.mMainHandler;
            if (handler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mMainHandler");
            }
            handler.sendEmptyMessage(2);
        }
        long position = this.mPrimaryPlayer.getPlayer().getCurrentPosition();
        long duration = this.mPrimaryPlayer.getPlayer().getDuration();
        if (this.getState() == State.PLAYING && !this.bIsFadingout && this.mPrimaryPlayer.getPlayer().getBufferedPercentage() > 10 && this.mSecondaryPlayer.getPlay() == null && this.loadSecondaryPlayer()) {
            ADLog.d$default(this.log, "Kicked off secondary load since primary has played past 10%", null, 2, null);
        }
        Play primaryPlay = this.mPrimaryPlayer.getPlay();
        if (this.getMEventListener() != null && position < duration && primaryPlay != null && this.getState() == State.PLAYING && this.mPrimaryPlayer.getPlayer().getPlayWhenReady() && !this.mPrimaryPlayer.getBEndHasBeenReported()) {
            MixingAudioPlayer.EventListener eventListener = this.getMEventListener();
            if (eventListener != null) {
                eventListener.onProgressUpdate(primaryPlay, (float)position / 1000.0f, (float)duration / 1000.0f);
            }
        }
        if (primaryPlay != null) {
            AudioFile current = primaryPlay.getAudioFile();
            long durationMinusTrim = duration;
            if (this.getBTrimmingEnabled()) {
                double d = current.getStartTrim() * 1000.0f;
                boolean bl = false;
                long l = durationMinusTrim - (long)Math.floor(d);
                d = current.getEndTrim() * 1000.0f;
                bl = false;
                durationMinusTrim = l - (long)Math.floor(d);
            }
            if (this._fadeDuration > 0.0f && durationMinusTrim > (long)this.mMinimumDurationForCrossFade) {
                if (duration > 0L && position < duration) {
                    long msUntilCrossfadeStart = duration - position - (long)this._fadeDuration;
                    if (this.getBTrimmingEnabled()) {
                        msUntilCrossfadeStart -= (long)(primaryPlay.getAudioFile().getEndTrim() * (float)1000);
                    }
                    if (msUntilCrossfadeStart < (long)500) {
                        if (this.mSecondaryPlayer.getPlay() != null && this.mSecondaryPlayer.getPlayer().getPlaybackState() == 3) {
                            if (this.crossFadeInEnabled) {
                                this.scheduleFadeOutAndFadeIn();
                            } else {
                                this.scheduleFadeOutNoFadeIn();
                            }
                        } else {
                            this.scheduleFadeOutNoFadeIn();
                        }
                    }
                }
            } else if (this.getBTrimmingEnabled() && primaryPlay.getAudioFile().getEndTrim() > 0.0f) {
                double d = primaryPlay.getAudioFile().getEndTrim() * 1000.0f;
                boolean bl = false;
                long msUntilTrim = duration - position - (long)Math.floor(d);
                if (msUntilTrim <= 0L) {
                    this.primaryPlayerCompleted();
                }
            }
        }
    }

    private final void scheduleFadeOutAndFadeIn() {
        Play play2 = this.mPrimaryPlayer.getPlay();
        if (play2 == null) {
            return;
        }
        Play play3 = play2;
        long position = this.mPrimaryPlayer.getPlayer().getCurrentPosition();
        long duration = this.mPrimaryPlayer.getPlayer().getDuration();
        long delay = duration - position - (long)this._fadeDuration;
        if (this.getBTrimmingEnabled()) {
            delay -= (long)(play3.getAudioFile().getEndTrim() * 1000.0f);
        }
        if (delay < 0L) {
            ADLog.d$default(this.log, "scheduling fadeout/fadein in negative seconds! position = " + position + ", duration = " + duration, null, 2, null);
        }
        this.mPrimaryPlayer.setPlay(null);
        ExoMixingAudioPlayer.startFadeOutAndFadeIn$default(this, play3, 0, 2, null);
    }

    private final void scheduleFadeOutNoFadeIn() {
        Play play2 = this.mPrimaryPlayer.getPlay();
        if (play2 == null) {
            return;
        }
        Play play3 = play2;
        long position = this.mPrimaryPlayer.getPlayer().getCurrentPosition();
        long duration = this.mPrimaryPlayer.getPlayer().getDuration();
        long delay = duration - position - (long)this._fadeDuration;
        if (this.getBTrimmingEnabled()) {
            delay -= (long)(play3.getAudioFile().getEndTrim() * 1000.0f);
        }
        if (delay < 0L) {
            ADLog.e$default(this.log, "scheduling fadeout/no fade in in negative seconds! position = " + position + ", duration = " + duration, null, 2, null);
        }
        this.mPrimaryPlayer.setPlay(null);
        this.startFadeOutNoFadeIn(play3);
    }

    private final void startFadeOutNoFadeIn(Play previousPlay) {
        ADLog.i$default(this.log, "Fading out only", null, 2, null);
        if (this.mSecondaryPlayer.getPlay() != null) {
            this.switchPlayerReferences();
            if (this.getMEventListener() != null) {
                this.mPrimaryPlayer.setBEndHasBeenReported(true);
                MixingAudioPlayer.EventListener eventListener = this.getMEventListener();
                if (eventListener != null) {
                    eventListener.onPlayItemFinishedPlayback(previousPlay, 0, null);
                }
            }
            this.mSecondaryPlayer.setPlay(null);
            this.mPrimaryPlayer.getPlayer().setPlayWhenReady(true);
            this.mSecondaryPlayer.getPlayer().setPlayWhenReady(true);
            this.startFadeOut();
        } else if (this.loadSecondaryPlayer()) {
            this.switchPlayerReferences();
            if (this.getMEventListener() != null) {
                this.mPrimaryPlayer.setBEndHasBeenReported(true);
                MixingAudioPlayer.EventListener eventListener = this.getMEventListener();
                if (eventListener != null) {
                    eventListener.onPlayItemFinishedPlayback(previousPlay, 0, null);
                }
            }
            this.startFadeOut();
            this.mPrimaryPlayer.getPlayer().setPlayWhenReady(true);
        } else {
            this.switchPlayerReferences();
            this.updateToState(State.WAITING_FOR_ITEM);
            if (this.getMEventListener() != null) {
                this.mPrimaryPlayer.setBEndHasBeenReported(true);
                MixingAudioPlayer.EventListener eventListener = this.getMEventListener();
                if (eventListener != null) {
                    eventListener.onPlayItemFinishedPlayback(previousPlay, 0, null);
                }
            }
            this.startFadeOut();
            ADLog.d$default(this.log, "Nothing to fade out to", null, 2, null);
        }
    }

    private final void startFadeOutAndFadeIn(Play previousPlay, int completionReason) {
        ADLog.i$default(this.log, "Fading out and fading in", null, 2, null);
        if (this.mSecondaryPlayer.getPlayer().getPlaybackState() == 3) {
            this.switchPlayerReferences();
            if (this.getMEventListener() != null) {
                this.mPrimaryPlayer.setBEndHasBeenReported(true);
                MixingAudioPlayer.EventListener eventListener = this.getMEventListener();
                if (eventListener != null) {
                    eventListener.onPlayItemFinishedPlayback(previousPlay, completionReason, null);
                }
            }
            this.startFadeOut();
            this.startFadeIn();
        } else if (this.loadSecondaryPlayer()) {
            this.switchPlayerReferences();
            this.mPrimaryPlayer.getPlayer().setPlayWhenReady(true);
            if (this.getMEventListener() != null) {
                this.mPrimaryPlayer.setBEndHasBeenReported(true);
                MixingAudioPlayer.EventListener eventListener = this.getMEventListener();
                if (eventListener != null) {
                    eventListener.onPlayItemFinishedPlayback(previousPlay, completionReason, null);
                }
            }
            this.startFadeOut();
        } else {
            this.switchPlayerReferences();
            this.updateToState(State.WAITING_FOR_ITEM);
            if (this.getMEventListener() != null) {
                this.mPrimaryPlayer.setBEndHasBeenReported(true);
                MixingAudioPlayer.EventListener eventListener = this.getMEventListener();
                if (eventListener != null) {
                    eventListener.onPlayItemFinishedPlayback(previousPlay, completionReason, null);
                }
            }
            this.startFadeOut();
            ADLog.d$default(this.log, "Nothing to fade out to", null, 2, null);
        }
    }

    static /* synthetic */ void startFadeOutAndFadeIn$default(ExoMixingAudioPlayer exoMixingAudioPlayer, Play play2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        exoMixingAudioPlayer.startFadeOutAndFadeIn(play2, n);
    }

    private final void startFadeIn() {
        ADLog.d$default(this.log, "Starting primary player fade in", null, 2, null);
        this.volumeMin = 0.0f;
        float numberOfSteps = this._fadeDuration / (float)100;
        float deltaVolume = this.mPrimaryPlayer.getPlayingVolume() / numberOfSteps;
        this.mPrimaryPlayer.getPlayer().setVolume(this.volumeMin);
        this.mPrimaryPlayer.getPlayer().setPlayWhenReady(true);
        Timer timer = new Timer(true);
        TimerTask timerTask2 = new TimerTask(this, deltaVolume, timer){
            final /* synthetic */ ExoMixingAudioPlayer this$0;
            final /* synthetic */ float $deltaVolume;
            final /* synthetic */ Timer $timer;

            public void run() {
                ExoMixingAudioPlayer.access$getMMainHandler$p(this.this$0).postAtFrontOfQueue(new Runnable(this){
                    final /* synthetic */ startFadeIn.timerTask.1 this$0;

                    public final void run() {
                        ADLog.v$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0.this$0), "primary player volume increased to = " + ExoMixingAudioPlayer.access$getVolumeMin$p(this.this$0.this$0), null, 2, null);
                        ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0.this$0).getPlayer().setVolume(ExoMixingAudioPlayer.access$getVolumeMin$p(this.this$0.this$0));
                        ExoMixingAudioPlayer exoMixingAudioPlayer = this.this$0.this$0;
                        ExoMixingAudioPlayer.access$setVolumeMin$p(exoMixingAudioPlayer, ExoMixingAudioPlayer.access$getVolumeMin$p(exoMixingAudioPlayer) + this.this$0.$deltaVolume);
                        if (ExoMixingAudioPlayer.access$getVolumeMin$p(this.this$0.this$0) >= ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0.this$0).getPlayingVolume()) {
                            this.this$0.$timer.cancel();
                            this.this$0.$timer.purge();
                            ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0.this$0).getPlayer().setVolume(ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0.this$0).getPlayingVolume());
                            ADLog.v$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0.this$0), "Ended primary player fade in", null, 2, null);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = this$0;
                this.$deltaVolume = $captured_local_variable$1;
                this.$timer = $captured_local_variable$2;
            }
        };
        timer.schedule(timerTask2, 100, (long)100);
    }

    private final void startFadeOut() {
        if (this.bIsFadingout) {
            return;
        }
        this.bIsFadingout = true;
        ADLog.v$default(this.log, "Starting secondary player fade out from volume = " + this.mSecondaryPlayer + ".playingVolume", null, 2, null);
        this.volumeMax = this.mSecondaryPlayer.getPlayingVolume();
        int numberOfSteps = (int)(this._fadeDuration / (float)100);
        float deltaVolume = this.mSecondaryPlayer.getPlayingVolume() / (float)numberOfSteps;
        Timer timer = new Timer(true);
        Play play2 = this.mSecondaryPlayer.getPlay();
        TimerTask timerTask2 = new TimerTask(this, deltaVolume, timer, play2){
            final /* synthetic */ ExoMixingAudioPlayer this$0;
            final /* synthetic */ float $deltaVolume;
            final /* synthetic */ Timer $timer;
            final /* synthetic */ Play $play;

            public void run() {
                ExoMixingAudioPlayer.access$getMMainHandler$p(this.this$0).postAtFrontOfQueue(new Runnable(this){
                    final /* synthetic */ startFadeOut.timerTask.1 this$0;

                    public final void run() {
                        if (ExoMixingAudioPlayer.access$getVolumeMax$p(this.this$0.this$0) >= ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0.this$0).getPlayingVolume()) {
                            ExoMixingAudioPlayer.access$setVolumeMax$p(this.this$0.this$0, ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0.this$0).getPlayingVolume());
                        }
                        ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0.this$0).getPlayer().setVolume(ExoMixingAudioPlayer.access$getVolumeMax$p(this.this$0.this$0));
                        ExoMixingAudioPlayer exoMixingAudioPlayer = this.this$0.this$0;
                        ExoMixingAudioPlayer.access$setVolumeMax$p(exoMixingAudioPlayer, ExoMixingAudioPlayer.access$getVolumeMax$p(exoMixingAudioPlayer) - this.this$0.$deltaVolume);
                        ADLog.v$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0.this$0), "secondary player volume decreased to = " + ExoMixingAudioPlayer.access$getVolumeMax$p(this.this$0.this$0), null, 2, null);
                        if ((double)ExoMixingAudioPlayer.access$getVolumeMax$p(this.this$0.this$0) <= 0.03) {
                            this.this$0.$timer.cancel();
                            this.this$0.$timer.purge();
                            ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0.this$0).getPlayer().setVolume(ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0.this$0).getPlayingVolume());
                            ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0.this$0).getPlayer().setPlayWhenReady(false);
                            if (ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0.this$0).getPlay() != null && Intrinsics.areEqual((Object)ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0.this$0).getPlay(), (Object)this.this$0.$play)) {
                                ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0.this$0).setPlay(null);
                            }
                            ExoMixingAudioPlayer.access$setBIsFadingout$p(this.this$0.this$0, false);
                            ADLog.v$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0.this$0), "Ended secondary player fade out", null, 2, null);
                            ExoMixingAudioPlayer.access$preparePlayer(this.this$0.this$0, ExoMixingAudioPlayer.access$getBisPlaying$p(this.this$0.this$0));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = this$0;
                this.$deltaVolume = $captured_local_variable$1;
                this.$timer = $captured_local_variable$2;
                this.$play = $captured_local_variable$3;
            }
        };
        timer.schedule(timerTask2, 100, (long)100);
    }

    private final void primaryPlayerCompleted() {
        ADLog.d$default(this.log, "primary player completed playback", null, 2, null);
        Play primaryPlay = this.mPrimaryPlayer.getPlay();
        if (primaryPlay != null) {
            ExoMixingAudioPlayer.skipCurrent$default(this, primaryPlay, 0, null, 4, null);
        }
    }

    private final void switchPreparingReferences() {
        ADLog.d$default(this.log, "about to swap players. primary is now " + this.mPrimaryPlayer + ", and preparing is " + this.mPreparingPlayer, null, 2, null);
        this.mPreparingPlayer.getPlayer().removeListener(this.preparingPlayerProxy.getExoListener());
        this.mPrimaryPlayer.getPlayer().removeListener(this.primaryPlayerProxy.getExoListener());
        PlayAndPlayer player = this.mPrimaryPlayer;
        this.mPrimaryPlayer = this.mPreparingPlayer;
        this.mPreparingPlayer = player;
        this.mPrimaryPlayer.setBStartHasBeenReported(false);
        this.mPrimaryPlayer.setBEndHasBeenReported(false);
        this.mPreparingPlayer.setBStartHasBeenReported(false);
        this.mPreparingPlayer.setBReadyForPlayback(false);
        this.mPreparingPlayer.setBEndHasBeenReported(false);
        this.mPrimaryPlayer.getPlayer().addListener(this.primaryPlayerProxy.getExoListener());
        this.mPreparingPlayer.getPlayer().addListener(this.preparingPlayerProxy.getExoListener());
        ADLog.d$default(this.log, "players have been swapped. primary is now " + this.mPrimaryPlayer + ", and preparing is " + this.mPreparingPlayer, null, 2, null);
    }

    private final void switchPlayerReferences() {
        ADLog.d$default(this.log, "about to swap players. primary is now " + this.mPrimaryPlayer + ", and secondary is " + this.mSecondaryPlayer, null, 2, null);
        if (this.mSecondaryPlayer.getPlayer().getPlaybackState() == 4) {
            ADLog.e$default(this.log, "Secondary player had state ended but is being swapped to primary, This could cause problems!!!", null, 2, null);
        }
        this.mPrimaryPlayer.getPlayer().removeListener(this.primaryPlayerProxy.getExoListener());
        this.mSecondaryPlayer.getPlayer().removeListener(this.secondaryPlayerProxy.getExoListener());
        PlayAndPlayer player = this.mPrimaryPlayer;
        this.mPrimaryPlayer = this.mSecondaryPlayer;
        this.mSecondaryPlayer = player;
        this.mPrimaryPlayer.setPlayingVolume(this.getVolume());
        this.mSecondaryPlayer.setPlayingVolume(this.mPrimaryPlayer.getPlayingVolume());
        this.mPrimaryPlayer.setBEndHasBeenReported(false);
        this.mSecondaryPlayer.setBStartHasBeenReported(false);
        this.mSecondaryPlayer.setBReadyForPlayback(false);
        this.mSecondaryPlayer.setBEndHasBeenReported(false);
        this.mPrimaryPlayer.getPlayer().addListener(this.primaryPlayerProxy.getExoListener());
        this.mSecondaryPlayer.getPlayer().addListener(this.secondaryPlayerProxy.getExoListener());
        ADLog.d$default(this.log, "players have been swapped. primary is now " + this.mPrimaryPlayer + ", and secondary is " + this.mSecondaryPlayer, null, 2, null);
    }

    private final void skipCurrent(Play previousPlay, int reason, Exception error) {
        ADLog.d$default(this.log, "Skip current", null, 2, null);
        if (!this.mPrimaryPlayer.getBStartHasBeenReported() && this.mPrimaryPlayer.getPlayer().getPlaybackState() == 2 && reason != 3) {
            ADLog.d$default(this.log, "New song is still being loaded into primary player no need to skip", null, 2, null);
            return;
        }
        if (this.mSecondaryPlayer.getPlay() != null || this.loadSecondaryPlayer()) {
            if (this.getMEventListener() != null && !this.mPrimaryPlayer.getBEndHasBeenReported()) {
                this.mPrimaryPlayer.setBEndHasBeenReported(true);
                MixingAudioPlayer.EventListener eventListener = this.getMEventListener();
                if (eventListener != null) {
                    eventListener.onPlayItemFinishedPlayback(previousPlay, reason, error);
                }
            }
            this.switchPlayerReferences();
            this.mSecondaryPlayer.setPlay(null);
            this.mSecondaryPlayer.getPlayer().setPlayWhenReady(false);
            this.mPrimaryPlayer.getPlayer().setPlayWhenReady(true);
        } else {
            if (this.getMEventListener() != null && !this.mPrimaryPlayer.getBEndHasBeenReported()) {
                this.mPrimaryPlayer.setBEndHasBeenReported(true);
                MixingAudioPlayer.EventListener eventListener = this.getMEventListener();
                if (eventListener != null) {
                    eventListener.onPlayItemFinishedPlayback(previousPlay, reason, error);
                }
            }
            ADLog.d$default(this.log, "Finished playback of all songs", null, 2, null);
            this.mPrimaryPlayer.setPlay(null);
            this.mPrimaryPlayer.setBReadyForPlayback(false);
            this.mPrimaryPlayer.setBStartHasBeenReported(false);
            this.updateToState(State.WAITING_FOR_ITEM);
        }
    }

    static /* synthetic */ void skipCurrent$default(ExoMixingAudioPlayer exoMixingAudioPlayer, Play play2, int n, Exception exception, int n2, Object object) {
        if ((n2 & 4) != 0) {
            exception = null;
        }
        exoMixingAudioPlayer.skipCurrent(play2, n, exception);
    }

    @Override
    public void flush() {
        if (this.enThread(new Runnable(this){
            final /* synthetic */ ExoMixingAudioPlayer this$0;

            public final void run() {
                this.this$0.flush();
            }
            {
                this.this$0 = exoMixingAudioPlayer;
            }
        })) {
            return;
        }
        ADLog.e$default(this.log, "FLUSHED", null, 2, null);
        this.mQueuedAudioAssets.clear();
        this.mSecondaryPlayer.getPlayer().stop();
        this.mPrimaryPlayer.getPlayer().stop();
        if (this.getState() == State.PLAYING || this.getState() == State.STALLED) {
            this.updateToState(State.WAITING_FOR_ITEM);
        } else if (this.getState() != State.PAUSED) {
            this.updateToState(State.READY_TO_PLAY);
        }
        Play primaryPlay = this.mPrimaryPlayer.getPlay();
        if (this.getMEventListener() != null && primaryPlay != null) {
            this.mPrimaryPlayer.setBEndHasBeenReported(true);
            MixingAudioPlayer.EventListener eventListener = this.getMEventListener();
            if (eventListener != null) {
                eventListener.onPlayItemFinishedPlayback(primaryPlay, 2, null);
            }
        }
        this.mPrimaryPlayer.setPlay(null);
        this.mPrimaryPlayer.setBReadyForPlayback(false);
        this.mPrimaryPlayer.setBStartHasBeenReported(false);
        this.mPrimaryPlayer.setBEndHasBeenReported(false);
        this.mSecondaryPlayer.setPlay(null);
        this.mSecondaryPlayer.setBReadyForPlayback(false);
        this.mSecondaryPlayer.setBStartHasBeenReported(false);
        this.mSecondaryPlayer.setBEndHasBeenReported(false);
        Handler handler = this.mMainHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mMainHandler");
        }
        handler.sendEmptyMessage(2);
    }

    @Override
    public void flushAndIncludeCurrent(boolean includeCurrent) {
        if (this.enThread(new Runnable(this, includeCurrent){
            final /* synthetic */ ExoMixingAudioPlayer this$0;
            final /* synthetic */ boolean $includeCurrent;

            public final void run() {
                this.this$0.flushAndIncludeCurrent(this.$includeCurrent);
            }
            {
                this.this$0 = exoMixingAudioPlayer;
                this.$includeCurrent = bl;
            }
        })) {
            return;
        }
        ADLog.v$default(this.log, "flushing player" + (includeCurrent ? " along with current play" : ""), null, 2, null);
        if (includeCurrent) {
            this.flush();
        } else {
            this.mQueuedAudioAssets.clear();
            this.mSecondaryPlayer.getPlayer().stop();
            this.mSecondaryPlayer.setPlay(null);
        }
    }

    @NotNull
    public String toString() {
        return "{  state: " + (Object)((Object)this.getState()) + ", primaryPlayer: " + this.mPrimaryPlayer + ", secondaryPlayer: " + this.mSecondaryPlayer + ", preparingPlayer: " + this.mPreparingPlayer + ", timeFlag: " + this.bTimeFlag + ", isPaused: " + this.bPaused + ", isPlaying: " + this.bisPlaying + ", queuedAudioAssets: " + this.mQueuedAudioAssets.size() + ", isFadingOut: " + this.bIsFadingout + " }";
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public ExoMixingAudioPlayer(@NotNull Context context, final @NotNull Looper looper) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)looper, (String)"looper");
        this.context = context;
        this.log = new ADLog("com.adaptr.ExoMP");
        this.mMinimumDurationForCrossFade = 1000;
        this.volume = 1.0f;
        this.bTimeFlag = true;
        this.crossFadeInEnabled = true;
        this.mPrimaryPlayer = new PlayAndPlayer();
        this.mSecondaryPlayer = new PlayAndPlayer();
        this.mPreparingPlayer = new PlayAndPlayer();
        this.state = State.UNINITIALIZED;
        this.mQueuedAudioAssets = new LinkedList();
        this.mTimeTracker = new TimeTracker("0");
        this.tracker = new ArrayList();
        this.primaryEventListener = new PlayerProxy.ExoEventListener(this){
            final /* synthetic */ ExoMixingAudioPlayer this$0;

            public void onLoadingChanged(boolean isLoading) {
                ADLog.v$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "primary player is " + (isLoading ? "still" : "done") + " loading", null, 2, null);
            }

            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                ADLog.d$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "Primary player state changed to " + com.adaptr.android.playersdk.ExoMixingAudioPlayer$Companion.access$exoplayerStateToString(ExoMixingAudioPlayer.Companion, playbackState) + " (exoplayer.playWhenReady = " + playWhenReady + ")", null, 2, null);
                if (playbackState == 3 && playWhenReady) {
                    ExoMixingAudioPlayer.access$getMMainHandler$p(this.this$0).sendEmptyMessageDelayed(1, (long)500);
                    boolean bAnnounceStateChange = false;
                    if (this.this$0.getState() != State.PLAYING) {
                        bAnnounceStateChange = true;
                        ADLog.d$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "Changing state " + com.adaptr.android.playersdk.ExoMixingAudioPlayer$Companion.access$stateToString(ExoMixingAudioPlayer.Companion, this.this$0.getState()) + " -> " + com.adaptr.android.playersdk.ExoMixingAudioPlayer$Companion.access$stateToString(ExoMixingAudioPlayer.Companion, State.PLAYING), null, 2, null);
                        this.this$0.setState(State.PLAYING);
                    }
                    Play primaryPlay = ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).getPlay();
                    if (this.this$0.getMEventListener() != null && primaryPlay != null) {
                        if ((float)ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).getPlayer().getCurrentPosition() <= primaryPlay.getAudioFile().getStartTrim() * (float)1000 + (float)50 && !ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).getBReadyForPlayback()) {
                            ExoMixingAudioPlayer.access$calculateFinalTime(this.this$0, ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).getPlay());
                            MixingAudioPlayer.EventListener eventListener = this.this$0.getMEventListener();
                            if (eventListener != null) {
                                eventListener.onPlayItemReadyForPlayback(primaryPlay);
                            }
                            ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).setBReadyForPlayback(true);
                        }
                        if (!ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).getBStartHasBeenReported()) {
                            ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).setBStartHasBeenReported(true);
                            ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).setBEndHasBeenReported(false);
                            ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).setPlayingVolume(this.this$0.getVolume());
                            ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).getPlayer().setVolume(ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).getPlayingVolume());
                            long waitingTime = -1L;
                            if (ExoMixingAudioPlayer.access$getBTimeFlag$p(this.this$0)) {
                                ExoMixingAudioPlayer.access$getMTimeTracker$p(this.this$0).setBufferingEndTime(System.currentTimeMillis());
                                ExoMixingAudioPlayer.access$setBTimeFlag$p(this.this$0, false);
                                waitingTime = ExoMixingAudioPlayer.access$getMTimeTracker$p(this.this$0).getBufferingEndTime() - ExoMixingAudioPlayer.access$getMTimeTracker$p(this.this$0).getBufferingStartTime();
                            }
                            MixingAudioPlayer.EventListener eventListener = this.this$0.getMEventListener();
                            if (eventListener != null) {
                                eventListener.onPlayItemBeganPlayback((int)waitingTime, primaryPlay, ExoMixingAudioPlayer.access$getTrackFinalTime(this.this$0, primaryPlay));
                            }
                            ExoMixingAudioPlayer.access$getMTimeTracker$p(this.this$0).setBufferingEndTime(0L);
                            ExoMixingAudioPlayer.access$getMTimeTracker$p(this.this$0).setBufferingStartTime(0L);
                        }
                    }
                    if (bAnnounceStateChange) {
                        MixingAudioPlayer.EventListener eventListener = this.this$0.getMEventListener();
                        if (eventListener != null) {
                            eventListener.onPlayerStateChanged(this.this$0.getState());
                        }
                    }
                } else if (playbackState == 3) {
                    if (ExoMixingAudioPlayer.access$getBPaused$p(this.this$0)) {
                        ExoMixingAudioPlayer.access$updateToState(this.this$0, State.PAUSED);
                    } else {
                        ExoMixingAudioPlayer.access$updateToState(this.this$0, State.READY_TO_PLAY);
                        Play primaryPlay = ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).getPlay();
                        if (primaryPlay != null) {
                            ExoMixingAudioPlayer.access$calculateFinalTime(this.this$0, primaryPlay);
                            MixingAudioPlayer.EventListener eventListener = this.this$0.getMEventListener();
                            if (eventListener != null) {
                                eventListener.onPlayItemReadyForPlayback(primaryPlay);
                            }
                        }
                    }
                } else if (playbackState == 2) {
                    ExoMixingAudioPlayer.access$updateToState(this.this$0, State.STALLED);
                } else if (playbackState == 1) {
                    if (ExoMixingAudioPlayer.access$getBPaused$p(this.this$0)) {
                        ExoMixingAudioPlayer.access$updateToState(this.this$0, State.PAUSED);
                    } else if (ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).getPlay() == null && ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0).getPlay() == null) {
                        ExoMixingAudioPlayer.access$updateToState(this.this$0, State.WAITING_FOR_ITEM);
                    }
                } else if (playbackState == 4) {
                    ExoMixingAudioPlayer.access$primaryPlayerCompleted(this.this$0);
                }
            }

            public void onPlayerError(@Nullable ExoPlaybackException error) {
                Exception err;
                ExoMixingAudioPlayer.access$getLog$p(this.this$0).e("primary player error \n", (Throwable)error);
                Play play2 = ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).getPlay();
                if (play2 == null) {
                    return;
                }
                Play play3 = play2;
                ExoPlaybackException exoPlaybackException = error;
                Exception exception = err = exoPlaybackException != null ? (Exception)exoPlaybackException : new Exception("Exoplayer failed to play this track");
                if (!ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).getBStartHasBeenReported()) {
                    ExoMixingAudioPlayer.access$getMPrimaryPlayer$p(this.this$0).setBStartHasBeenReported(true);
                    long waitingTime = -1L;
                    if (ExoMixingAudioPlayer.access$getBTimeFlag$p(this.this$0)) {
                        ExoMixingAudioPlayer.access$getMTimeTracker$p(this.this$0).setBufferingEndTime(System.currentTimeMillis());
                        ExoMixingAudioPlayer.access$setBTimeFlag$p(this.this$0, false);
                        waitingTime = ExoMixingAudioPlayer.access$getMTimeTracker$p(this.this$0).getBufferingEndTime() - ExoMixingAudioPlayer.access$getMTimeTracker$p(this.this$0).getBufferingStartTime();
                    }
                    MixingAudioPlayer.EventListener eventListener = this.this$0.getMEventListener();
                    if (eventListener != null) {
                        eventListener.onPlayItemBeganPlayback((int)waitingTime, play3, ExoMixingAudioPlayer.access$getTrackFinalTime(this.this$0, play3));
                    }
                }
                ExoMixingAudioPlayer.access$skipCurrent(this.this$0, play3, 3, err);
            }

            public void onSeekProcessed() {
            }
            {
                this.this$0 = this$0;
            }
        };
        this.secondaryEventListener = new PlayerProxy.ExoEventListener(this){
            final /* synthetic */ ExoMixingAudioPlayer this$0;

            public void onLoadingChanged(boolean isLoading) {
            }

            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                ADLog.d$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "Secondary player state changed to " + com.adaptr.android.playersdk.ExoMixingAudioPlayer$Companion.access$exoplayerStateToString(ExoMixingAudioPlayer.Companion, playbackState), null, 2, null);
                if (playbackState == 3 && playWhenReady) {
                    ADLog.e$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "secondary player became ready and tried to begin playback!!", null, 2, null);
                } else if (playbackState == 2) {
                    ADLog.d$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "secondary player is now buffering", null, 2, null);
                } else if (playbackState == 3) {
                    ADLog.d$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "secondary player is now ready", null, 2, null);
                    Play secondaryPlay = ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0).getPlay();
                    if (secondaryPlay != null) {
                        ExoMixingAudioPlayer.access$calculateFinalTime(this.this$0, secondaryPlay);
                        MixingAudioPlayer.EventListener eventListener = this.this$0.getMEventListener();
                        if (eventListener != null) {
                            eventListener.onPlayItemReadyForPlayback(secondaryPlay);
                        }
                        ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0).setBReadyForPlayback(true);
                    }
                } else if (playbackState == 4) {
                    ADLog.d$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "secondary player is now ended", null, 2, null);
                } else if (playbackState == 1) {
                    ADLog.d$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "secondary player is now idle", null, 2, null);
                }
            }

            public void onPlayerError(@Nullable ExoPlaybackException error) {
                Exception err = (Exception)error;
                Exception exception = err;
                ADLog.e$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "secondary player error \n" + (exception != null ? exception.getStackTrace() : null), null, 2, null);
                if (err == null) {
                    err = new Exception("Exoplayer failed to play this track");
                }
                ADLog.e$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "secondary failed to prepare", null, 2, null);
                Play secondaryPlay = ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0).getPlay();
                if (secondaryPlay != null) {
                    MixingAudioPlayer.EventListener eventListener = this.this$0.getMEventListener();
                    if (eventListener != null) {
                        eventListener.onPlayFailedToPrepare(secondaryPlay, err);
                    }
                }
                ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0).setPlay(null);
                ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0).setBReadyForPlayback(false);
                ExoMixingAudioPlayer.access$getMSecondaryPlayer$p(this.this$0).setBStartHasBeenReported(false);
                ExoMixingAudioPlayer.access$loadSecondaryPlayer(this.this$0);
            }

            public void onSeekProcessed() {
            }
            {
                this.this$0 = this$0;
            }
        };
        this.preparingEventListener = new PlayerProxy.ExoEventListener(this){
            final /* synthetic */ ExoMixingAudioPlayer this$0;

            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                ADLog.d$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "preparing player state changed to " + com.adaptr.android.playersdk.ExoMixingAudioPlayer$Companion.access$exoplayerStateToString(ExoMixingAudioPlayer.Companion, playbackState), null, 2, null);
                if (playbackState == 3 && playWhenReady) {
                    ADLog.e$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "preparing player became ready and tried to begin playback!!", null, 2, null);
                } else if (playbackState == 2) {
                    ADLog.d$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "preparing player is now buffering", null, 2, null);
                } else if (playbackState == 3) {
                    ADLog.d$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "preparing player is now ready", null, 2, null);
                    Play preparingPlay = ExoMixingAudioPlayer.access$getMPreparingPlayer$p(this.this$0).getPlay();
                    if (preparingPlay != null) {
                        ExoMixingAudioPlayer.access$calculateFinalTime(this.this$0, preparingPlay);
                        MixingAudioPlayer.EventListener eventListener = this.this$0.getMEventListener();
                        if (eventListener != null) {
                            eventListener.onPlayItemReadyForPlayback(preparingPlay);
                        }
                        ExoMixingAudioPlayer.access$getMPreparingPlayer$p(this.this$0).setBReadyForPlayback(true);
                    }
                } else if (playbackState == 4) {
                    ADLog.d$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "preparing player is now ended", null, 2, null);
                } else if (playbackState == 1) {
                    ADLog.d$default(ExoMixingAudioPlayer.access$getLog$p(this.this$0), "preparing player is now idle", null, 2, null);
                }
            }

            public void onPlayerError(@Nullable ExoPlaybackException error) {
            }

            public void onSeekProcessed() {
            }

            public void onLoadingChanged(boolean isLoading) {
            }
            {
                this.this$0 = this$0;
            }
        };
        ADLog.i$default(this.log, "Exoplayer is Starting up", null, 2, null);
        this.mPrimaryPlayer.setPlayer(this.createSimpleExoPlayer(looper));
        this.primaryPlayerProxy = new PlayerProxy(this.primaryEventListener);
        this.mPrimaryPlayer.getPlayer().addListener(this.primaryPlayerProxy.getExoListener());
        this.mSecondaryPlayer.setPlayer(this.createSimpleExoPlayer(looper));
        this.secondaryPlayerProxy = new PlayerProxy(this.secondaryEventListener);
        this.mSecondaryPlayer.getPlayer().addListener(this.secondaryPlayerProxy.getExoListener());
        this.mPreparingPlayer.setPlayer(this.createSimpleExoPlayer(looper));
        this.preparingPlayerProxy = new PlayerProxy(this.preparingEventListener);
        this.mPreparingPlayer.getPlayer().addListener(this.preparingPlayerProxy.getExoListener());
        this.simpleCache = PlayerProxy.Companion.getSimpleCache();
        if (this.simpleCache == null) {
            PlayerProxy.Companion.setSimpleCache$PlayerSdk_exoDefaultRelease(this.context);
            this.simpleCache = PlayerProxy.Companion.getSimpleCache();
        }
        ADLog.i$default(this.log, "Exoplayer is up", null, 2, null);
        this.setState(State.READY_TO_PLAY);
        this.mMainHandler = new Handler(looper){

            public void handleMessage(@NotNull Message msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                switch (msg.what) {
                    case 1: {
                        this.processUpdate();
                        this.removeMessages(1);
                        this.sendEmptyMessageDelayed(1, 500);
                        break;
                    }
                    case 2: {
                        this.removeMessages(1);
                        break;
                    }
                }
            }
        };
    }

    public ExoMixingAudioPlayer(@NotNull Context context, @NotNull MixingAudioPlayer.EventListener listener2, @NotNull Looper looper) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)looper, (String)"looper");
        this(context, looper);
        this.setMEventListener(listener2);
    }

    public static final /* synthetic */ SimpleCache access$getSimpleCache$p(ExoMixingAudioPlayer $this) {
        return $this.simpleCache;
    }

    public static final /* synthetic */ void access$setSimpleCache$p(ExoMixingAudioPlayer $this, SimpleCache simpleCache) {
        $this.simpleCache = simpleCache;
    }

    public static final /* synthetic */ PlayAndPlayer access$getMPrimaryPlayer$p(ExoMixingAudioPlayer $this) {
        return $this.mPrimaryPlayer;
    }

    public static final /* synthetic */ void access$setMPrimaryPlayer$p(ExoMixingAudioPlayer $this, PlayAndPlayer playAndPlayer) {
        $this.mPrimaryPlayer = playAndPlayer;
    }

    public static final /* synthetic */ ADLog access$getLog$p(ExoMixingAudioPlayer $this) {
        return $this.log;
    }

    public static final /* synthetic */ PlayAndPlayer access$getMSecondaryPlayer$p(ExoMixingAudioPlayer $this) {
        return $this.mSecondaryPlayer;
    }

    public static final /* synthetic */ void access$setMSecondaryPlayer$p(ExoMixingAudioPlayer $this, PlayAndPlayer playAndPlayer) {
        $this.mSecondaryPlayer = playAndPlayer;
    }

    public static final /* synthetic */ float access$get_fadeDuration$p(ExoMixingAudioPlayer $this) {
        return $this._fadeDuration;
    }

    public static final /* synthetic */ void access$set_fadeDuration$p(ExoMixingAudioPlayer $this, float f) {
        $this._fadeDuration = f;
    }

    public static final /* synthetic */ int access$getMMinimumDurationForCrossFade$p(ExoMixingAudioPlayer $this) {
        return $this.mMinimumDurationForCrossFade;
    }

    public static final /* synthetic */ void access$setMMinimumDurationForCrossFade$p(ExoMixingAudioPlayer $this, int n) {
        $this.mMinimumDurationForCrossFade = n;
    }

    public static final /* synthetic */ void access$startFadeOutAndFadeIn(ExoMixingAudioPlayer $this, Play previousPlay, int completionReason) {
        $this.startFadeOutAndFadeIn(previousPlay, completionReason);
    }

    public static final /* synthetic */ Handler access$getMMainHandler$p(ExoMixingAudioPlayer $this) {
        Handler handler = $this.mMainHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mMainHandler");
        }
        return handler;
    }

    public static final /* synthetic */ void access$setMMainHandler$p(ExoMixingAudioPlayer $this, Handler handler) {
        $this.mMainHandler = handler;
    }

    public static final /* synthetic */ float access$getVolumeMin$p(ExoMixingAudioPlayer $this) {
        return $this.volumeMin;
    }

    public static final /* synthetic */ void access$setVolumeMin$p(ExoMixingAudioPlayer $this, float f) {
        $this.volumeMin = f;
    }

    public static final /* synthetic */ float access$getVolumeMax$p(ExoMixingAudioPlayer $this) {
        return $this.volumeMax;
    }

    public static final /* synthetic */ void access$setVolumeMax$p(ExoMixingAudioPlayer $this, float f) {
        $this.volumeMax = f;
    }

    public static final /* synthetic */ boolean access$getBIsFadingout$p(ExoMixingAudioPlayer $this) {
        return $this.bIsFadingout;
    }

    public static final /* synthetic */ void access$setBIsFadingout$p(ExoMixingAudioPlayer $this, boolean bl) {
        $this.bIsFadingout = bl;
    }

    public static final /* synthetic */ boolean access$preparePlayer(ExoMixingAudioPlayer $this, boolean playWhenReady) {
        return $this.preparePlayer(playWhenReady);
    }

    public static final /* synthetic */ boolean access$getBisPlaying$p(ExoMixingAudioPlayer $this) {
        return $this.bisPlaying;
    }

    public static final /* synthetic */ void access$setBisPlaying$p(ExoMixingAudioPlayer $this, boolean bl) {
        $this.bisPlaying = bl;
    }

    public static final /* synthetic */ void access$calculateFinalTime(ExoMixingAudioPlayer $this, Play play2) {
        $this.calculateFinalTime(play2);
    }

    public static final /* synthetic */ boolean access$getBTimeFlag$p(ExoMixingAudioPlayer $this) {
        return $this.bTimeFlag;
    }

    public static final /* synthetic */ void access$setBTimeFlag$p(ExoMixingAudioPlayer $this, boolean bl) {
        $this.bTimeFlag = bl;
    }

    public static final /* synthetic */ TimeTracker access$getMTimeTracker$p(ExoMixingAudioPlayer $this) {
        return $this.mTimeTracker;
    }

    public static final /* synthetic */ long access$getTrackFinalTime(ExoMixingAudioPlayer $this, Play play2) {
        return $this.getTrackFinalTime(play2);
    }

    public static final /* synthetic */ boolean access$getBPaused$p(ExoMixingAudioPlayer $this) {
        return $this.bPaused;
    }

    public static final /* synthetic */ void access$setBPaused$p(ExoMixingAudioPlayer $this, boolean bl) {
        $this.bPaused = bl;
    }

    public static final /* synthetic */ boolean access$updateToState(ExoMixingAudioPlayer $this, State newState) {
        return $this.updateToState(newState);
    }

    public static final /* synthetic */ void access$primaryPlayerCompleted(ExoMixingAudioPlayer $this) {
        $this.primaryPlayerCompleted();
    }

    public static final /* synthetic */ void access$skipCurrent(ExoMixingAudioPlayer $this, Play previousPlay, int reason, Exception error) {
        $this.skipCurrent(previousPlay, reason, error);
    }

    public static final /* synthetic */ boolean access$loadSecondaryPlayer(ExoMixingAudioPlayer $this) {
        return $this.loadSecondaryPlayer();
    }

    public static final /* synthetic */ PlayAndPlayer access$getMPreparingPlayer$p(ExoMixingAudioPlayer $this) {
        return $this.mPreparingPlayer;
    }

    public static final /* synthetic */ void access$setMPreparingPlayer$p(ExoMixingAudioPlayer $this, PlayAndPlayer playAndPlayer) {
        $this.mPreparingPlayer = playAndPlayer;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\f\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/adaptr/android/playersdk/ExoMixingAudioPlayer$TimeTracker;", "", "id", "", "(Lcom/adaptr/android/playersdk/ExoMixingAudioPlayer;Ljava/lang/String;)V", "bufferingEndTime", "", "getBufferingEndTime", "()J", "setBufferingEndTime", "(J)V", "bufferingStartTime", "getBufferingStartTime", "setBufferingStartTime", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "PlayerSdk_exoDefaultRelease"})
    public final class TimeTracker {
        private long bufferingStartTime;
        private long bufferingEndTime;
        @NotNull
        private String id;

        public final long getBufferingStartTime() {
            return this.bufferingStartTime;
        }

        public final void setBufferingStartTime(long l) {
            this.bufferingStartTime = l;
        }

        public final long getBufferingEndTime() {
            return this.bufferingEndTime;
        }

        public final void setBufferingEndTime(long l) {
            this.bufferingEndTime = l;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public final void setId(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.id = string;
        }

        public TimeTracker(String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lcom/adaptr/android/playersdk/ExoMixingAudioPlayer$PlayAndPlayer;", "", "(Lcom/adaptr/android/playersdk/ExoMixingAudioPlayer;)V", "bEndHasBeenReported", "", "getBEndHasBeenReported", "()Z", "setBEndHasBeenReported", "(Z)V", "bReadyForPlayback", "getBReadyForPlayback", "setBReadyForPlayback", "bStartHasBeenReported", "getBStartHasBeenReported", "setBStartHasBeenReported", "play", "Lcom/adaptr/android/playersdk/models/Play;", "getPlay", "()Lcom/adaptr/android/playersdk/models/Play;", "setPlay", "(Lcom/adaptr/android/playersdk/models/Play;)V", "player", "Lcom/google/android/exoplayer2/SimpleExoPlayer;", "getPlayer", "()Lcom/google/android/exoplayer2/SimpleExoPlayer;", "setPlayer", "(Lcom/google/android/exoplayer2/SimpleExoPlayer;)V", "playingVolume", "", "getPlayingVolume", "()F", "setPlayingVolume", "(F)V", "toString", "", "PlayerSdk_exoDefaultRelease"})
    public final class PlayAndPlayer {
        @NotNull
        public SimpleExoPlayer player;
        @Nullable
        private Play play;
        private boolean bReadyForPlayback;
        private boolean bStartHasBeenReported;
        private boolean bEndHasBeenReported;
        private float playingVolume = 1.0f;

        @NotNull
        public final SimpleExoPlayer getPlayer() {
            SimpleExoPlayer simpleExoPlayer = this.player;
            if (simpleExoPlayer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            }
            return simpleExoPlayer;
        }

        public final void setPlayer(@NotNull SimpleExoPlayer simpleExoPlayer) {
            Intrinsics.checkNotNullParameter((Object)simpleExoPlayer, (String)"<set-?>");
            this.player = simpleExoPlayer;
        }

        @Nullable
        public final Play getPlay() {
            return this.play;
        }

        public final void setPlay(@Nullable Play play2) {
            this.play = play2;
        }

        public final boolean getBReadyForPlayback() {
            return this.bReadyForPlayback;
        }

        public final void setBReadyForPlayback(boolean bl) {
            this.bReadyForPlayback = bl;
        }

        public final boolean getBStartHasBeenReported() {
            return this.bStartHasBeenReported;
        }

        public final void setBStartHasBeenReported(boolean bl) {
            this.bStartHasBeenReported = bl;
        }

        public final boolean getBEndHasBeenReported() {
            return this.bEndHasBeenReported;
        }

        public final void setBEndHasBeenReported(boolean bl) {
            this.bEndHasBeenReported = bl;
        }

        public final float getPlayingVolume() {
            return this.playingVolume;
        }

        public final void setPlayingVolume(float f) {
            this.playingVolume = f;
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("{ state: \"");
            SimpleExoPlayer simpleExoPlayer = this.player;
            if (simpleExoPlayer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            }
            StringBuilder stringBuilder2 = stringBuilder.append(Companion.exoplayerStateToString(simpleExoPlayer.getPlaybackState())).append(", buffPercentage: ");
            SimpleExoPlayer simpleExoPlayer2 = this.player;
            if (simpleExoPlayer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            }
            StringBuilder stringBuilder3 = stringBuilder2.append(simpleExoPlayer2.getBufferedPercentage()).append(", buffPosition: ");
            SimpleExoPlayer simpleExoPlayer3 = this.player;
            if (simpleExoPlayer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            }
            StringBuilder stringBuilder4 = stringBuilder3.append(simpleExoPlayer3.getBufferedPosition()).append(", currentPosition: ");
            SimpleExoPlayer simpleExoPlayer4 = this.player;
            if (simpleExoPlayer4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            }
            StringBuilder stringBuilder5 = stringBuilder4.append(simpleExoPlayer4.getCurrentPosition()).append(", duration: ");
            SimpleExoPlayer simpleExoPlayer5 = this.player;
            if (simpleExoPlayer5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            }
            StringBuilder stringBuilder6 = stringBuilder5.append(simpleExoPlayer5.getDuration()).append(", playWhenReady: ");
            SimpleExoPlayer simpleExoPlayer6 = this.player;
            if (simpleExoPlayer6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            }
            String playerState = stringBuilder6.append(simpleExoPlayer6.getPlayWhenReady()).append(" }").toString();
            return "{ play: " + this.play + ", player: " + playerState + ", readyForPlayback: " + this.bReadyForPlayback + ", startHasBeenReported: " + this.bStartHasBeenReported + ", playingVolume: " + this.playingVolume + " }";
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/adaptr/android/playersdk/ExoMixingAudioPlayer$Companion;", "", "()V", "CANCEL_MESSAGE", "", "FADE_INTERVAL", "UPDATE_INTERVAL", "UPDATE_MESSAGE", "exoplayerStateToString", "", "state", "stateToString", "Lcom/adaptr/android/playersdk/State;", "PlayerSdk_exoDefaultRelease"})
    public static final class Companion {
        private final String stateToString(State state) {
            switch (ExoMixingAudioPlayer$Companion$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    return "STATE_PAUSED";
                }
                case 2: {
                    return "STATE_PLAYING";
                }
                case 3: {
                    return "STATE_READY_TO_PLAY";
                }
                case 4: {
                    return "STATE_STALLED";
                }
                case 5: {
                    return "STATE_WAITING_FOR_ITEM";
                }
            }
            return "** unknown state **";
        }

        private final String exoplayerStateToString(int state) {
            switch (state) {
                case 1: {
                    return "IDLE";
                }
                case 2: {
                    return "BUFFERING";
                }
                case 3: {
                    return "READY";
                }
                case 4: {
                    return "ENDED";
                }
            }
            return "** unknown state **";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

