/*
 * Decompiled with CFR 0.152.
 */
package com.adair.util;

import android.content.Context;
import android.content.SharedPreferences;
import com.adair.util.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class SPUtils {
    private static final String NAME = "share_data";

    public static SharedPreferences.Editor OpenEditor(Context context) {
        SharedPreferences sp = context.getSharedPreferences(NAME, 0);
        return sp.edit();
    }

    public static SharedPreferences Open(Context context) {
        return context.getSharedPreferences(NAME, 0);
    }

    public static void putDouble(Context context, String key, double value) {
        SharedPreferences sp = context.getSharedPreferences(NAME, 0);
        JSONObject object = new JSONObject();
        try {
            object.put("double", value);
            sp.edit().putString(key, object.toString()).apply();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static boolean putDoubleWithResult(Context context, String key, double value) {
        SharedPreferences sp = context.getSharedPreferences(NAME, 0);
        JSONObject object = new JSONObject();
        try {
            object.put("double", value);
            return sp.edit().putString(key, object.toString()).commit();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static double getDouble(Context context, String key, double defaultValue) {
        double value;
        SharedPreferences sp = context.getSharedPreferences(NAME, 0);
        String jsonString = sp.getString(key, "");
        if (StringUtils.isEmpty(jsonString)) {
            value = defaultValue;
        } else {
            try {
                JSONObject object = new JSONObject(jsonString);
                value = object.getDouble("double");
            }
            catch (JSONException e) {
                value = defaultValue;
            }
        }
        return value;
    }
}

