/*
 * Decompiled with CFR 0.152.
 */
package com.adair.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.RequiresPermission;
import android.telephony.TelephonyManager;

public class NetworkUtils {
    public static final int NETWORK_NONE = 0;
    public static final int NETWORK_WIFI = 1;
    public static final int NETWORK_2G = 2;
    public static final int NETWORK_3G = 3;
    public static final int NETWORK_4G = 4;
    public static final int NETWORK_UNKNOWN = 5;

    private NetworkUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isConnected(Context context) {
        NetworkInfo info;
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        return null != manager && (info = manager.getActiveNetworkInfo()) != null && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED;
    }

    public static boolean isWifi(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        return manager != null && manager.getActiveNetworkInfo().getType() == 1;
    }

    public static int getNetworkType(Context context) {
        NetworkInfo.State state;
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        if (null == manager) {
            return 0;
        }
        NetworkInfo activeNetworkInfo = manager.getActiveNetworkInfo();
        if (activeNetworkInfo == null || !activeNetworkInfo.isConnected()) {
            return 0;
        }
        NetworkInfo wifiInfo = manager.getNetworkInfo(1);
        if (null != wifiInfo && (state = wifiInfo.getState()) != null && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            return 1;
        }
        NetworkInfo mobileInfo = manager.getNetworkInfo(0);
        if (null != mobileInfo) {
            NetworkInfo.State state2 = mobileInfo.getState();
            String strSubTypeName = mobileInfo.getSubtypeName();
            if (null != state2 && (state2 == NetworkInfo.State.CONNECTED || state2 == NetworkInfo.State.CONNECTING)) {
                switch (activeNetworkInfo.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        return 2;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        return 3;
                    }
                    case 13: 
                    case 18: {
                        return 4;
                    }
                }
                if (strSubTypeName.equalsIgnoreCase("TD-SCDMA") || strSubTypeName.equalsIgnoreCase("WCDMA") || strSubTypeName.equalsIgnoreCase("CDMA2000")) {
                    return 3;
                }
                return 5;
            }
        }
        return 0;
    }

    public static String getNetworkOperatorName(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm != null ? tm.getNetworkOperatorName() : null;
    }
}

