/*
 * Decompiled with CFR 0.152.
 */
package com.adair.util;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class Logger {
    private static final String SEPARATOR = ",";
    private static final String TAG = "Logger";
    private static boolean LOG_DEBUG = false;

    private Logger() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void isDebug(boolean debug) {
        LOG_DEBUG = debug;
    }

    public static void v(String msg) {
        if (LOG_DEBUG) {
            StackTraceElement traceElement = Thread.currentThread().getStackTrace()[3];
            String tag = Logger.getDefaultTag(traceElement);
            Log.v((String)(TAG + tag), (String)Logger.getLogInfo(traceElement, msg));
        }
    }

    public static void d(String msg) {
        if (LOG_DEBUG) {
            StackTraceElement traceElement = Thread.currentThread().getStackTrace()[3];
            String tag = Logger.getDefaultTag(traceElement);
            Log.d((String)(TAG + tag), (String)Logger.getLogInfo(traceElement, msg));
        }
    }

    public static void i(String msg) {
        if (LOG_DEBUG) {
            StackTraceElement traceElement = Thread.currentThread().getStackTrace()[3];
            String tag = Logger.getDefaultTag(traceElement);
            Log.i((String)(TAG + tag), (String)Logger.getLogInfo(traceElement, msg));
        }
    }

    public static void w(String msg) {
        if (LOG_DEBUG) {
            StackTraceElement traceElement = Thread.currentThread().getStackTrace()[3];
            String tag = Logger.getDefaultTag(traceElement);
            Log.w((String)(TAG + tag), (String)Logger.getLogInfo(traceElement, msg));
        }
    }

    public static void e(String msg) {
        if (LOG_DEBUG) {
            StackTraceElement traceElement = Thread.currentThread().getStackTrace()[3];
            String tag = Logger.getDefaultTag(traceElement);
            Log.e((String)(TAG + tag), (String)Logger.getLogInfo(traceElement, msg));
        }
    }

    public static void e(String msg, Throwable e) {
        if (LOG_DEBUG) {
            StackTraceElement traceElement = Thread.currentThread().getStackTrace()[3];
            String tag = Logger.getDefaultTag(traceElement);
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)writer, true);
            pw.append(msg);
            e.printStackTrace(pw);
            Log.e((String)(TAG + tag), (String)Logger.getLogInfo(traceElement, writer.toString()));
            pw.close();
        }
    }

    public static void e(Throwable e) {
        if (LOG_DEBUG) {
            StackTraceElement traceElement = Thread.currentThread().getStackTrace()[3];
            String tag = Logger.getDefaultTag(traceElement);
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)writer, true);
            e.printStackTrace(pw);
            Log.e((String)(TAG + tag), (String)Logger.getLogInfo(traceElement, writer.toString()));
            pw.close();
        }
    }

    private static String getDefaultTag(StackTraceElement stackTraceElement) {
        String fileName = stackTraceElement.getFileName();
        String[] stringArray = fileName.split("\\.");
        return stringArray[0];
    }

    private static String getLogInfo(StackTraceElement stackTraceElement, String msg) {
        StringBuilder logInfoStringBuilder = new StringBuilder();
        String threadName = Thread.currentThread().getName();
        long threadID = Thread.currentThread().getId();
        String fileName = stackTraceElement.getFileName();
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        int lineNumber = stackTraceElement.getLineNumber();
        logInfoStringBuilder.append("==================================================================================================\n");
        logInfoStringBuilder.append("********");
        logInfoStringBuilder.append(" threadID = ").append(threadID).append(SEPARATOR);
        logInfoStringBuilder.append(" threadName = ").append(threadName).append(SEPARATOR);
        logInfoStringBuilder.append(" fileName = ").append(fileName).append(SEPARATOR);
        logInfoStringBuilder.append(" className = ").append(className).append(SEPARATOR);
        logInfoStringBuilder.append(" methodName = ").append(methodName).append(SEPARATOR);
        logInfoStringBuilder.append(" lineNumber = ").append(lineNumber);
        logInfoStringBuilder.append(" ********\n");
        logInfoStringBuilder.append(msg).append("\n");
        logInfoStringBuilder.append("===================================================================================================\n");
        return logInfoStringBuilder.toString();
    }
}

