/*
 * Decompiled with CFR 0.152.
 */
package com.adair.util;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.Method;

public class DensityUtils {
    private DensityUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int dp2px(Context context, float dpVal) {
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int sp2px(Context context, float spVal) {
        return (int)TypedValue.applyDimension((int)2, (float)spVal, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float px2dp(Context context, float pxVal) {
        float scale = context.getResources().getDisplayMetrics().density;
        return pxVal / scale;
    }

    public static float px2sp(Context context, float pxVal) {
        float scale = context.getResources().getDisplayMetrics().density;
        return pxVal / scale;
    }

    public static int getScreenWidth(Context context) {
        int width = 0;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        if (wm != null) {
            wm.getDefaultDisplay().getMetrics(outMetrics);
            width = outMetrics.widthPixels;
        }
        return width;
    }

    public static int getScreenHeight(Context context) {
        int height = 0;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        if (wm != null) {
            wm.getDefaultDisplay().getMetrics(outMetrics);
            height = outMetrics.heightPixels;
        }
        return height;
    }

    public static int getRealHeight(Context context) {
        int height = 0;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        if (wm != null) {
            if (Build.VERSION.SDK_INT >= 17) {
                wm.getDefaultDisplay().getRealMetrics(outMetrics);
                height = outMetrics.heightPixels;
            } else {
                Display display = wm.getDefaultDisplay();
                try {
                    Class<?> c = Class.forName("android.view.Display");
                    Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
                    method.invoke((Object)display, outMetrics);
                    height = outMetrics.heightPixels;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return height;
    }

    public static int getRealWidth(Context context) {
        int width = 0;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        if (wm != null) {
            if (Build.VERSION.SDK_INT >= 17) {
                wm.getDefaultDisplay().getRealMetrics(outMetrics);
                width = outMetrics.widthPixels;
            } else {
                Display display = wm.getDefaultDisplay();
                try {
                    Class<?> c = Class.forName("android.view.Display");
                    Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
                    method.invoke((Object)display, outMetrics);
                    width = outMetrics.widthPixels;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return width;
    }

    public static int getStatusHeight(Context context) {
        int statusHeight = 0;
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusHeight = resources.getDimensionPixelOffset(resourceId);
        }
        return statusHeight;
    }

    public static int getNavigationBarHeight(Context context) {
        int navigationBarHeight = 0;
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            navigationBarHeight = resources.getDimensionPixelOffset(resourceId);
        }
        return navigationBarHeight;
    }
}

