/*
 * Decompiled with CFR 0.152.
 */
package com.adair.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import java.io.File;
import java.util.List;

public class AppUtils {
    private AppUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String getAppName(Context context) {
        String appName = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            appName = context.getResources().getString(labelRes);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return appName;
    }

    public static String getVersionName(Context context) {
        String versionName = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            versionName = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return versionName;
    }

    public static long getVersionCode(Context context) {
        long versionCode = -1L;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            versionCode = Build.VERSION.SDK_INT >= 28 ? packageInfo.getLongVersionCode() : (long)packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return versionCode;
    }

    public static void installApk(Context context, String path, String authority) {
        Uri data;
        File file = new File(path);
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        if (Build.VERSION.SDK_INT >= 24) {
            data = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
            intent.addFlags(1);
        } else {
            data = Uri.fromFile((File)file);
        }
        intent.setDataAndType(data, "application/vnd.android.package-archive");
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void go2Setting(Activity activity, int requestCode) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)activity.getPackageName(), null);
        intent.setData(uri);
        activity.startActivityForResult(intent, requestCode);
    }

    public static void openNetworkSetting(Activity activity) {
        Intent intent = new Intent();
        if (Build.VERSION.SDK_INT > 10) {
            intent.setAction("android.settings.SETTINGS");
        } else {
            ComponentName componentName = new ComponentName("com.android.settting", "com.android.setting.WirelessSettings");
            intent.setComponent(componentName);
            intent.setAction("android.intent.action.View");
        }
        activity.startActivity(intent);
    }

    public static boolean isRunBackground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager != null) {
            List appProcessInfoList = activityManager.getRunningAppProcesses();
            String packageName = context.getPackageName();
            for (ActivityManager.RunningAppProcessInfo appProcessInfo : appProcessInfoList) {
                if (!appProcessInfo.processName.equals(packageName)) continue;
                if (Build.VERSION.SDK_INT >= 26) {
                    return appProcessInfo.importance == 400;
                }
                return appProcessInfo.importance == 400;
            }
        }
        return false;
    }

    public static boolean isRunForeground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager != null) {
            List appProcessInfoList = activityManager.getRunningAppProcesses();
            String packageName = context.getPackageName();
            for (ActivityManager.RunningAppProcessInfo appProcessInfo : appProcessInfoList) {
                if (!appProcessInfo.processName.equals(packageName)) continue;
                return appProcessInfo.importance == 100;
            }
        }
        return false;
    }
}

