/*
 * Decompiled with CFR 0.152.
 */
package com.android.util.constant;

import com.android.MathUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class MemoryConstant {
    public static final int BYTE = 1;
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;

    public static String convert(long byteLong) {
        if (byteLong < 1024L) {
            return byteLong + "B";
        }
        if (byteLong < 0x100000L) {
            return MathUtils.div(byteLong, 1024.0, 2) + "KB";
        }
        if (byteLong < 0x40000000L) {
            return MathUtils.div(byteLong, 1048576.0, 2) + "MB";
        }
        return MathUtils.div(byteLong, 1.073741824E9, 2) + "GB";
    }

    public static String convert(long byteLong, int unit) {
        switch (unit) {
            case 1: {
                return byteLong + "B";
            }
            case 1024: {
                return MathUtils.div(byteLong, 1024.0) + "KB";
            }
            case 0x100000: {
                return MathUtils.div(byteLong, 1048576.0) / 100.0 + "MB";
            }
            case 0x40000000: {
                return MathUtils.div(byteLong, 1.073741824E9) + "GB";
            }
        }
        return byteLong + "B";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Unit {
    }
}

