/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.GooglePlayServices.managers;

import android.app.PendingIntent;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.GooglePlayServices.Geofencing;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.LocationServices;
import java.util.ArrayList;
import java.util.List;

public class GeofenceRequester
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
ResultCallback<Status> {
    private static final int DEFAULT_BACKOFF_MS = 3000;
    private static final int MAX_BACKOFF_MS = 3600000;
    private static PendingIntent mGeofencePendingIntent;
    private final Context mContext;
    private int mCurrentBackoff;
    private ArrayList<Geofence> mGeofencesToAdd;
    private GoogleApiClient mLocationClient;
    private boolean mInProgress;
    private onGeofenceRequestListener mListener;

    public GeofenceRequester(Context context, onGeofenceRequestListener onGeofenceRequestListener2) {
        GeofenceRequester geofenceRequester = this;
        this.mCurrentBackoff = 3000;
        geofenceRequester.mContext = context;
        mGeofencePendingIntent = null;
        geofenceRequester.mLocationClient = null;
        geofenceRequester.mInProgress = false;
        this.mListener = onGeofenceRequestListener2;
    }

    private void requestConnection() {
        this.getLocationClient().connect();
    }

    private GoogleApiClient getLocationClient() {
        if (this.mLocationClient == null) {
            this.mLocationClient = new GoogleApiClient.Builder(this.mContext).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        }
        return this.mLocationClient;
    }

    private void continueAddGeofences() {
        LocationServices.GeofencingApi.addGeofences(this.mLocationClient, this.mGeofencesToAdd, this.getRequestPendingIntent()).setResultCallback((ResultCallback)this);
    }

    private void requestDisconnection() {
        this.mInProgress = false;
        this.getLocationClient().disconnect();
        Log.debug((String)"Geofence Plugin|Location client disconnected");
    }

    private void retry() {
        GeofenceRequester geofenceRequester = this;
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (GeofenceRequester.this.mGeofencesToAdd != null && GeofenceRequester.this.mGeofencesToAdd.size() > 0) {
                    GeofenceRequester geofenceRequester = GeofenceRequester.this;
                    geofenceRequester.addGeofences(geofenceRequester.mGeofencesToAdd);
                }
            }
        }, (long)this.mCurrentBackoff);
        geofenceRequester.mCurrentBackoff *= 2;
        if (geofenceRequester.mCurrentBackoff > 3600000) {
            this.mCurrentBackoff = 3600000;
        }
    }

    public boolean getInProgressFlag() {
        return this.mInProgress;
    }

    public void setInProgressFlag(boolean bl) {
        this.mInProgress = bl;
    }

    public PendingIntent getRequestPendingIntent() {
        if (mGeofencePendingIntent == null) {
            mGeofencePendingIntent = Geofencing.createRequestPendingIntent(this.mContext);
        }
        return mGeofencePendingIntent;
    }

    public void addGeofences(List<Geofence> list) {
        this.mGeofencesToAdd = (ArrayList)list;
        if (!this.mInProgress) {
            this.mInProgress = true;
            this.requestConnection();
        }
    }

    public void onConnected(Bundle bundle) {
        try {
            this.mCurrentBackoff = 3000;
            Log.debug((String)"Geofence Plugin|Location client connected");
            this.continueAddGeofences();
        }
        catch (SecurityException securityException) {
            Log.debug((String)"LOCATION permission denied", (Throwable)securityException);
        }
        catch (IllegalStateException illegalStateException) {
            Log.debug((String)"Geofence Plugin|Location client error, reconnecting", (Throwable)illegalStateException);
            this.mLocationClient.connect();
        }
    }

    public void onConnectionSuspended(int n) {
        GeofenceRequester geofenceRequester = this;
        geofenceRequester.mInProgress = false;
        Log.debug((String)"Geofence Plugin|Location client connection lost");
        geofenceRequester.mLocationClient = null;
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        this.mInProgress = false;
        Log.debug((String)"Geofence Plugin|Connection failed to Location client");
        this.retry();
    }

    public void onResult(Status status) {
        int n;
        int n2 = status.getStatusCode();
        String[] stringArray = new String[this.mGeofencesToAdd.size()];
        for (n = 0; n < this.mGeofencesToAdd.size(); ++n) {
            stringArray[n] = this.mGeofencesToAdd.get(n).getRequestId();
        }
        if (n2 == 0) {
            onGeofenceRequestListener onGeofenceRequestListener2 = this.mListener;
            if (onGeofenceRequestListener2 != null) {
                onGeofenceRequestListener2.onGeofencesAdded(stringArray);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                for (n = 0; n < this.mGeofencesToAdd.size(); ++n) {
                    if (!this.mGeofencesToAdd.get(n).getRequestId().equals(stringArray[i])) continue;
                    this.mGeofencesToAdd.remove(n);
                }
            }
        } else if (n2 != 1001) {
            this.retry();
        } else {
            Log.debug((String)("Geofence Plugin|Can't add more Geofences. Limit reached? Error code : " + n2));
            onGeofenceRequestListener onGeofenceRequestListener3 = this.mListener;
            if (onGeofenceRequestListener3 != null) {
                onGeofenceRequestListener3.onGeofencesAdded(stringArray);
            }
            this.mGeofencesToAdd.clear();
        }
        this.requestDisconnection();
    }

    public static interface onGeofenceRequestListener {
        public void onGeofencesAdded(String[] var1);
    }
}

