/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.GooglePlayServices;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import com.ad4screen.sdk.GeofencingReceiver;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.GeofencePlugin;
import com.ad4screen.sdk.plugins.GooglePlayServices.common.Utils;
import com.ad4screen.sdk.plugins.GooglePlayServices.managers.GeofenceRemover;
import com.ad4screen.sdk.plugins.GooglePlayServices.managers.GeofenceRequester;
import com.ad4screen.sdk.plugins.GooglePlayServices.model.SimpleGeofence;
import com.ad4screen.sdk.plugins.model.Geofence;
import java.util.ArrayList;

public class Geofencing
implements GeofencePlugin {
    private static final int PLUGIN_VERSION = 3;
    public static final String RECEIVER_ACTION_GEOFENCING_TRANSITION = "com.ad4screen.sdk.geofence.TRANSITION";
    private GeofenceRequester requester;
    private GeofenceRemover remover;
    private ArrayList<com.google.android.gms.location.Geofence> mGeofencesToAdd;

    public static PendingIntent createRequestPendingIntent(Context context) {
        Intent intent;
        Intent intent2 = intent;
        intent2(context, GeofencingReceiver.class);
        intent.addCategory(context.getPackageName());
        intent.setAction(RECEIVER_ACTION_GEOFENCING_TRANSITION);
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0x8000000);
    }

    private void addOrDelayGeofences() {
        GeofenceRemover geofenceRemover = this.remover;
        if (geofenceRemover != null && geofenceRemover.getInProgressFlag()) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    Geofencing.this.addOrDelayGeofences();
                }
            }, 1000L);
        } else {
            this.requester.addGeofences(this.mGeofencesToAdd);
        }
    }

    public int getPluginVersion() {
        return 3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(Context context, Geofence[] geofenceArray) {
        if (!Utils.checkPlayServices((Context)context)) {
            Log.error((String)"Geofence Plugin|Google Play Services unavailable");
            return;
        }
        try {
            Log.debug((String)("Geofence Plugin|Regions available" + geofenceArray.length + " geofences"));
            if (this.requester == null) {
                this.requester = new GeofenceRequester(context, new GeofenceRequester.onGeofenceRequestListener(){

                    @Override
                    public void onGeofencesAdded(String[] stringArray) {
                        Log.debug((String)("Geofence Plugin|Added " + stringArray.length + " geofences"));
                        for (int i = 0; i < stringArray.length; ++i) {
                            for (int j = 0; j < Geofencing.this.mGeofencesToAdd.size(); ++j) {
                                if (!((com.google.android.gms.location.Geofence)Geofencing.this.mGeofencesToAdd.get(j)).getRequestId().equals(stringArray[i])) continue;
                                Geofencing.this.mGeofencesToAdd.remove(j);
                            }
                        }
                    }
                });
            }
            if (this.mGeofencesToAdd == null) {
                this.mGeofencesToAdd = new ArrayList();
            }
            for (int i = 0; i < geofenceArray.length; ++i) {
                this.mGeofencesToAdd.add(new SimpleGeofence(geofenceArray[i].getId(), geofenceArray[i].getLatitude(), geofenceArray[i].getLongitude(), geofenceArray[i].getRadius(), -1L, 3).toGeofence());
            }
        }
        catch (Error error) {
            Log.error((String)"Geofence Plugin|Error occured when adding Geofence", (Throwable)error);
            return;
        }
        catch (Exception exception) {
            Log.error((String)"Geofence Plugin|Exception occured when adding Geofence", (Throwable)exception);
            return;
        }
        {
            this.addOrDelayGeofences();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(Context context, String[] stringArray) {
        if (!Utils.checkPlayServices((Context)context)) {
            Log.error((String)"Geofence Plugin|Google Play Services unavailable");
            return;
        }
        try {
            if (this.remover == null) {
                this.remover = new GeofenceRemover(context, new GeofenceRemover.OnGeofencesRemoveListener(){

                    @Override
                    public void onGeofencesRemoved() {
                        Log.debug((String)"Geofence Plugin|Removed all geofences");
                    }
                });
            }
            this.remover.removeAllGeofences();
            return;
        }
        catch (Error error) {
            Log.error((String)"Geofence Plugin|Error occured when removing Geofence", (Throwable)error);
            return;
        }
        catch (Exception exception) {
            Log.error((String)"Geofence Plugin|Exception occured when removing Geofence", (Throwable)exception);
        }
    }

    public boolean isGeofencingServiceDeclared(Context context) {
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = RECEIVER_ACTION_GEOFENCING_TRANSITION;
        String[] stringArray3 = new String[1];
        String[] stringArray4 = stringArray3;
        stringArray3[0] = context.getPackageName();
        return Utils.isReceiverDeclared((Context)context, GeofencingReceiver.class, null, (String[])stringArray2, (String[])stringArray4, (boolean)true);
    }
}

