/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.ad4screen.sdk.A4S;
import com.ad4screen.sdk.Log;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class GeofencingReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        Log.debug((String)"Geofence Plugin|Received Geofence Intent");
        GeofencingReceiver geofencingReceiver = GeofencingEvent.fromIntent((Intent)intent);
        if (geofencingReceiver.hasError()) {
            Log.error((String)("Geofence Plugin|Location client returned an error : " + geofencingReceiver.getErrorCode()));
        } else {
            int n = geofencingReceiver.getGeofenceTransition();
            Log.debug((String)("Geofence Plugin|Received Geofence Transition : " + n));
            if (n == 1 || n == 2) {
                Bundle bundle;
                Intent intent2;
                List list = geofencingReceiver.getTriggeringGeofences();
                Object[] objectArray = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    objectArray[i] = ((Geofence)list.get(i)).getRequestId();
                }
                Log.debug((String)("Geofence Plugin|Triggered geofences : " + TextUtils.join((CharSequence)",", (Object[])objectArray)));
                list = intent2;
                new Intent().addCategory("com.ad4screen.sdk.intent.category.GEOFENCE_NOTIFICATIONS");
                list.setAction("com.ad4screen.sdk.intent.action.TRIGGER");
                Bundle bundle2 = bundle;
                new Bundle().putStringArray("ids", (String[])objectArray);
                bundle2.putInt("transition", n);
                if (geofencingReceiver.getTriggeringLocation() != null) {
                    JSONObject jSONObject;
                    JSONObject jSONObject2;
                    Bundle bundle3 = bundle2;
                    geofencingReceiver = geofencingReceiver.getTriggeringLocation();
                    JSONObject jSONObject3 = jSONObject2;
                    JSONObject jSONObject4 = jSONObject2;
                    JSONObject jSONObject5 = jSONObject2;
                    JSONObject jSONObject6 = jSONObject2;
                    JSONObject jSONObject7 = jSONObject2;
                    JSONObject jSONObject8 = jSONObject2;
                    JSONObject jSONObject9 = jSONObject = jSONObject2;
                    jSONObject2 = new JSONObject();
                    JSONObject jSONObject10 = jSONObject2;
                    jSONObject8.put("latitude", geofencingReceiver.getLatitude());
                    jSONObject9.put("longitude", geofencingReceiver.getLongitude());
                    jSONObject6.put("altitude", geofencingReceiver.getAltitude());
                    double d = geofencingReceiver.getAccuracy();
                    jSONObject7.put("accuracy", d);
                    double d2 = geofencingReceiver.getBearing();
                    jSONObject4.put("bearing", d2);
                    jSONObject5.put("provider", (Object)geofencingReceiver.getProvider());
                    double d3 = geofencingReceiver.getSpeed();
                    jSONObject10.put("speed", d3);
                    jSONObject3.put("time", geofencingReceiver.getTime());
                    try {
                        bundle3.putString("triggeringLocation", jSONObject.toString());
                    }
                    catch (JSONException jSONException) {
                        Log.error((String)"Geofence Plugin|Error while parsing trigeringLocation", (Throwable)jSONException);
                    }
                }
                Context context2 = context;
                list.putExtra("com.ad4screen.sdk.extra.GEOFENCE_PAYLOAD", bundle2);
                A4S.get((Context)context2.getApplicationContext()).handleGeofencingMessage(list.getExtras());
                list.setPackage(context2.getApplicationContext().getPackageName());
                context.getApplicationContext().sendBroadcast((Intent)list, context.getApplicationContext().getPackageName() + ".permission.A4S_SEND");
            }
        }
    }
}

