/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.GooglePlayServices.managers;

import android.app.PendingIntent;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.GooglePlayServices.Geofencing;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.LocationServices;
import java.util.ArrayList;
import java.util.List;

public class GeofenceRequester
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
ResultCallback<Status> {
    private static final int DEFAULT_BACKOFF_MS = 3000;
    private static final int MAX_BACKOFF_MS = 3600000;
    private static PendingIntent mGeofencePendingIntent;
    private final Context mContext;
    private int mCurrentBackoff = 3000;
    private ArrayList<Geofence> mGeofencesToAdd;
    private GoogleApiClient mLocationClient;
    private boolean mInProgress;
    private onGeofenceRequestListener mListener;

    public GeofenceRequester(Context context, onGeofenceRequestListener listener) {
        this.mContext = context;
        mGeofencePendingIntent = null;
        this.mLocationClient = null;
        this.mInProgress = false;
        this.mListener = listener;
    }

    public boolean getInProgressFlag() {
        return this.mInProgress;
    }

    public void setInProgressFlag(boolean flag) {
        this.mInProgress = flag;
    }

    public PendingIntent getRequestPendingIntent() {
        if (mGeofencePendingIntent == null) {
            mGeofencePendingIntent = Geofencing.createRequestPendingIntent(this.mContext);
        }
        return mGeofencePendingIntent;
    }

    public void addGeofences(List<Geofence> geofences) {
        this.mGeofencesToAdd = (ArrayList)geofences;
        if (!this.mInProgress) {
            this.mInProgress = true;
            this.requestConnection();
        }
    }

    private void requestConnection() {
        this.getLocationClient().connect();
    }

    private GoogleApiClient getLocationClient() {
        if (this.mLocationClient == null) {
            this.mLocationClient = new GoogleApiClient.Builder(this.mContext).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        }
        return this.mLocationClient;
    }

    private void continueAddGeofences() {
        LocationServices.GeofencingApi.addGeofences(this.mLocationClient, this.mGeofencesToAdd, this.getRequestPendingIntent()).setResultCallback((ResultCallback)this);
    }

    private void requestDisconnection() {
        this.mInProgress = false;
        this.getLocationClient().disconnect();
        Log.debug((String)"Geofence Plugin|Location client disconnected");
    }

    public void onConnected(Bundle arg0) {
        try {
            this.mCurrentBackoff = 3000;
            Log.debug((String)"Geofence Plugin|Location client connected");
            this.continueAddGeofences();
        }
        catch (IllegalStateException e) {
            Log.debug((String)"Geofence Plugin|Location client error, reconnecting", (Throwable)e);
            this.mLocationClient.connect();
        }
        catch (SecurityException e) {
            Log.debug((String)"LOCATION permission denied", (Throwable)e);
        }
    }

    public void onConnectionSuspended(int code) {
        this.mInProgress = false;
        Log.debug((String)"Geofence Plugin|Location client connection lost");
        this.mLocationClient = null;
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        this.mInProgress = false;
        Log.debug((String)"Geofence Plugin|Connection failed to Location client");
        this.retry();
    }

    private void retry() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (GeofenceRequester.this.mGeofencesToAdd != null && GeofenceRequester.this.mGeofencesToAdd.size() > 0) {
                    GeofenceRequester.this.addGeofences(GeofenceRequester.this.mGeofencesToAdd);
                }
            }
        }, (long)this.mCurrentBackoff);
        this.mCurrentBackoff *= 2;
        if (this.mCurrentBackoff > 3600000) {
            this.mCurrentBackoff = 3600000;
        }
    }

    public void onResult(Status status) {
        int i;
        int statusCode = status.getStatusCode();
        String[] geofences = new String[this.mGeofencesToAdd.size()];
        for (i = 0; i < this.mGeofencesToAdd.size(); ++i) {
            geofences[i] = this.mGeofencesToAdd.get(i).getRequestId();
        }
        if (0 == statusCode) {
            if (this.mListener != null) {
                this.mListener.onGeofencesAdded(geofences);
            }
            for (i = 0; i < geofences.length; ++i) {
                for (int j = 0; j < this.mGeofencesToAdd.size(); ++j) {
                    if (!this.mGeofencesToAdd.get(j).getRequestId().equals(geofences[i])) continue;
                    this.mGeofencesToAdd.remove(j);
                }
            }
        } else if (statusCode != 1001) {
            this.retry();
        } else {
            Log.debug((String)("Geofence Plugin|Can't add more Geofences. Limit reached? Error code : " + statusCode));
            if (this.mListener != null) {
                this.mListener.onGeofencesAdded(geofences);
            }
            this.mGeofencesToAdd.clear();
        }
        this.requestDisconnection();
    }

    public static interface onGeofenceRequestListener {
        public void onGeofencesAdded(String[] var1);
    }
}

