/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.GooglePlayServices;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import com.ad4screen.sdk.GeofencingReceiver;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.GeofencePlugin;
import com.ad4screen.sdk.plugins.GooglePlayServices.common.Utils;
import com.ad4screen.sdk.plugins.GooglePlayServices.managers.GeofenceRemover;
import com.ad4screen.sdk.plugins.GooglePlayServices.managers.GeofenceRequester;
import com.ad4screen.sdk.plugins.GooglePlayServices.model.SimpleGeofence;
import com.ad4screen.sdk.plugins.model.Geofence;
import java.util.ArrayList;

public class Geofencing
implements GeofencePlugin {
    private static final int PLUGIN_VERSION = 3;
    public static final String RECEIVER_ACTION_GEOFENCING_TRANSITION = "com.ad4screen.sdk.geofence.TRANSITION";
    private GeofenceRequester requester;
    private GeofenceRemover remover;
    private ArrayList<com.google.android.gms.location.Geofence> mGeofencesToAdd;

    public static PendingIntent createRequestPendingIntent(Context context) {
        Intent intent = new Intent(context, GeofencingReceiver.class);
        intent.addCategory(context.getPackageName());
        intent.setAction(RECEIVER_ACTION_GEOFENCING_TRANSITION);
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x8000000);
    }

    public int getPluginVersion() {
        return 3;
    }

    public void add(Context context, Geofence[] geofences) {
        if (!Utils.checkPlayServices((Context)context)) {
            Log.error((String)"Geofence Plugin|Google Play Services unavailable");
            return;
        }
        try {
            if (this.requester == null) {
                this.requester = new GeofenceRequester(context, new GeofenceRequester.onGeofenceRequestListener(){

                    @Override
                    public void onGeofencesAdded(String[] ids) {
                        Log.debug((String)("Geofence Plugin|Added " + ids.length + " geofences"));
                        for (int i = 0; i < ids.length; ++i) {
                            for (int j = 0; j < Geofencing.this.mGeofencesToAdd.size(); ++j) {
                                if (!((com.google.android.gms.location.Geofence)Geofencing.this.mGeofencesToAdd.get(j)).getRequestId().equals(ids[i])) continue;
                                Geofencing.this.mGeofencesToAdd.remove(j);
                            }
                        }
                    }
                });
            }
            if (this.mGeofencesToAdd == null) {
                this.mGeofencesToAdd = new ArrayList();
            }
            for (int i = 0; i < geofences.length; ++i) {
                this.mGeofencesToAdd.add(new SimpleGeofence(geofences[i].getId(), geofences[i].getLatitude(), geofences[i].getLongitude(), geofences[i].getRadius(), -1L, 3).toGeofence());
            }
            this.addOrDelayGeofences();
        }
        catch (Exception e) {
            Log.error((String)"Geofence Plugin|Exception occured when adding Geofence", (Throwable)e);
        }
        catch (Error e) {
            Log.error((String)"Geofence Plugin|Error occured when adding Geofence", (Throwable)e);
        }
    }

    private void addOrDelayGeofences() {
        if (this.remover != null && this.remover.getInProgressFlag()) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    Geofencing.this.addOrDelayGeofences();
                }
            }, 1000L);
        } else {
            this.requester.addGeofences(this.mGeofencesToAdd);
        }
    }

    public void remove(Context context, String[] ids) {
        if (!Utils.checkPlayServices((Context)context)) {
            Log.error((String)"Geofence Plugin|Google Play Services unavailable");
            return;
        }
        try {
            if (this.remover == null) {
                this.remover = new GeofenceRemover(context, new GeofenceRemover.OnGeofencesRemoveListener(){

                    @Override
                    public void onGeofencesRemoved() {
                        Log.debug((String)"Geofence Plugin|Removed all geofences");
                    }
                });
            }
            this.remover.removeAllGeofences();
        }
        catch (Exception e) {
            Log.error((String)"Geofence Plugin|Exception occured when removing Geofence", (Throwable)e);
        }
        catch (Error e) {
            Log.error((String)"Geofence Plugin|Error occured when removing Geofence", (Throwable)e);
        }
    }

    public boolean isGeofencingServiceDeclared(Context context) {
        return Utils.isReceiverDeclared((Context)context, GeofencingReceiver.class, null, (String[])new String[]{RECEIVER_ACTION_GEOFENCING_TRANSITION}, (String[])new String[]{context.getPackageName()}, (boolean)true);
    }
}

