/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Bundle;
import android.text.TextUtils;
import com.ad4screen.sdk.A4S;
import com.ad4screen.sdk.Log;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class A4SGeofencingService
extends IntentService {
    public A4SGeofencingService() {
        super("ReceiveTransitionsIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        Log.debug((String)"Geofence Plugin|Received Geofence Intent");
        GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
        if (geofencingEvent.hasError()) {
            int errorCode = geofencingEvent.getErrorCode();
            Log.error((String)("Geofence Plugin|Location client returned an error : " + errorCode));
        } else {
            int transition = geofencingEvent.getGeofenceTransition();
            Log.debug((String)("Geofence Plugin|Received Geofence Transition : " + transition));
            if (transition == 1 || transition == 2) {
                List geofences = geofencingEvent.getTriggeringGeofences();
                Object[] geofenceIds = new String[geofences.size()];
                for (int index = 0; index < geofences.size(); ++index) {
                    Geofence geofence = (Geofence)geofences.get(index);
                    geofenceIds[index] = geofence.getRequestId();
                }
                String ids = TextUtils.join((CharSequence)",", (Object[])geofenceIds);
                Log.debug((String)("Geofence Plugin|Triggered geofences : " + ids));
                Intent broadcastIntent = new Intent();
                broadcastIntent.addCategory("com.ad4screen.sdk.intent.category.GEOFENCE_NOTIFICATIONS");
                broadcastIntent.setAction("com.ad4screen.sdk.intent.action.TRIGGER");
                Bundle bundle = new Bundle();
                bundle.putStringArray("ids", (String[])geofenceIds);
                bundle.putInt("transition", transition);
                if (geofencingEvent.getTriggeringLocation() != null) {
                    try {
                        Location triggeringLocation = geofencingEvent.getTriggeringLocation();
                        JSONObject location = new JSONObject();
                        location.put("latitude", triggeringLocation.getLatitude());
                        location.put("longitude", triggeringLocation.getLongitude());
                        location.put("altitude", triggeringLocation.getAltitude());
                        location.put("accuracy", (double)triggeringLocation.getAccuracy());
                        location.put("bearing", (double)triggeringLocation.getBearing());
                        location.put("provider", (Object)triggeringLocation.getProvider());
                        location.put("speed", (double)triggeringLocation.getSpeed());
                        location.put("time", triggeringLocation.getTime());
                        bundle.putString("triggeringLocation", location.toString());
                    }
                    catch (JSONException e) {
                        Log.error((String)"Geofence Plugin|Error while parsing trigeringLocation", (Throwable)e);
                    }
                }
                broadcastIntent.putExtra("com.ad4screen.sdk.extra.GEOFENCE_PAYLOAD", bundle);
                A4S.get((Context)this.getApplicationContext()).handleGeofencingMessage(broadcastIntent.getExtras());
                broadcastIntent.setPackage(this.getApplicationContext().getPackageName());
                this.getApplicationContext().sendBroadcast(broadcastIntent, this.getApplicationContext().getPackageName() + ".permission.A4S_SEND");
            }
        }
    }
}

