/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.GooglePlayServices.common;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import com.ad4screen.sdk.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;

public class Utils {
    public static boolean checkPlayServices(Context context) {
        try {
            return GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context) == 0;
        }
        catch (Exception exception) {
            Log.error((String)"Plugin|Error while checking Google Play Services", (Throwable)exception);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Log.error((String)"Plugin|GooglePlayServices not found. Please add GooglePlayServices Library to your app", (Throwable)noClassDefFoundError);
        }
        return false;
    }

    public static boolean isServiceDeclared(Context context, Class<? extends Service> clazz) {
        ComponentName componentName;
        PackageManager packageManager;
        if (context == null) {
            return false;
        }
        context = context.getApplicationContext();
        try {
            packageManager = context.getPackageManager();
            componentName = new ComponentName(context, clazz);
        }
        catch (Exception exception) {
            return false;
        }
        packageManager.getServiceInfo(componentName, 128);
        return true;
    }

    public static boolean isReceiverDeclared(Context object, Class<?> object2, String string, String[] stringArray, String[] stringArray2, boolean n) {
        int n2;
        Intent intent;
        PackageManager packageManager;
        block25: {
            ActivityInfo activityInfo;
            block24: {
                PackageManager packageManager2 = packageManager = object.getPackageManager();
                ComponentName componentName = new ComponentName((Context)object, object2);
                activityInfo = packageManager2.getReceiverInfo(componentName, 0);
                if (activityInfo.exported == n) break block24;
                int n3 = n;
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = stringBuilder.append("ManifestChecker|Receiver '").append(((Class)object2).getName());
                object = stringBuilder2.append("' must ");
                object2 = n3 != 0 ? "" : "not ";
                StringBuilder stringBuilder3 = ((StringBuilder)object).append((String)object2);
                Log.error((String)stringBuilder3.append("be exported").toString());
                return false;
            }
            if (string != null) {
                if (string.equals(activityInfo.permission)) break block25;
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder4 = stringBuilder.append("ManifestChecker|Receiver '").append(((Class)object2).getName());
                StringBuilder stringBuilder5 = stringBuilder4.append("' must require permission '").append(string);
                Log.error((String)stringBuilder5.append("' for security reasons").toString());
                return false;
            }
        }
        string = intent;
        intent = new Intent();
        n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            string.addCategory(stringArray2[i]);
            continue;
        }
        try {
            string.setPackage(object.getPackageName());
            n2 = stringArray.length;
        }
        catch (Exception exception) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            PackageManager packageManager3 = packageManager;
            String string2 = string;
            String string3 = string2;
            string2.setAction(stringArray[i]);
            if (!packageManager3.queryBroadcastReceivers((Intent)string3, 32).isEmpty()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder6 = stringBuilder.append("ManifestChecker|Receiver '").append(((Class)object2).getName());
            Log.error((String)stringBuilder6.append("' must be declared with an intent filter in your AndroidManifest.xml file").toString());
            return false;
        }
        return true;
    }

    public static String loadServiceMetadata(Context context, String string, Class<? extends Service> clazz) {
        block7: {
            block6: {
                ComponentName componentName;
                PackageManager packageManager;
                if (context == null) {
                    return null;
                }
                context = context.getApplicationContext();
                try {
                    packageManager = context.getPackageManager();
                    componentName = new ComponentName(context, clazz);
                }
                catch (Exception exception) {
                    Log.internal((String)"Could not load service metadata", (Throwable)exception);
                    return null;
                }
                context = packageManager.getServiceInfo(componentName, 128);
                if (context.metaData != null) break block6;
                return null;
            }
            if (context.metaData.containsKey(string)) break block7;
            return null;
        }
        return context.metaData.get(string).toString();
    }
}

