/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.fcm;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.ad4screen.sdk.A4S;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.fcm.AirshipFcmWrapper;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Map;

public class FcmMessageListenerService
extends FirebaseMessagingService {
    private static final String TAG = "FcmMessageListenerSrv";
    private static final String AIRSHIP_FCM_CLASS = "com.urbanairship.push.fcm.AirshipFirebaseIntegration";
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private static Boolean isAirshipFcmAvailable;

    public void onMessageReceived(RemoteMessage remoteMessage) {
        android.util.Log.d((String)TAG, (String)("onMessageReceived from " + remoteMessage.getFrom()));
        if (!remoteMessage.getData().isEmpty()) {
            final Bundle bundle = A4S.getPushBundleFromMap((Map)remoteMessage.getData());
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    A4S a4s = A4S.get((Context)FcmMessageListenerService.this.getApplicationContext());
                    if (a4s.isAccengagePush(bundle)) {
                        a4s.handlePushMessage(bundle);
                    } else {
                        android.util.Log.d((String)FcmMessageListenerService.TAG, (String)("onMessageReceived non Accengage message " + bundle.toString()));
                    }
                }
            });
        } else {
            String body = "null";
            if (remoteMessage.getNotification() != null) {
                RemoteMessage.Notification notification = remoteMessage.getNotification();
                body = notification.getBody();
            }
            Log.debug((String)("FcmMessageListenerSrv|Notification message: body=" + body));
        }
        if (this.isAirshipFcmAvailable()) {
            android.util.Log.d((String)TAG, (String)"Notifying Airship SDK onMessageReceived");
            AirshipFcmWrapper.processMessageSync(this.getApplicationContext(), remoteMessage);
        }
    }

    public void onNewToken(String token) {
        android.util.Log.d((String)TAG, (String)"onNewToken");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                A4S a4s = A4S.get((Context)FcmMessageListenerService.this.getApplicationContext());
                a4s.refreshPushToken();
            }
        });
        if (this.isAirshipFcmAvailable()) {
            android.util.Log.d((String)TAG, (String)"Notifying Airship SDK onNewToken");
            AirshipFcmWrapper.processNewToken(this.getApplicationContext());
        }
    }

    private boolean isAirshipFcmAvailable() {
        if (isAirshipFcmAvailable == null) {
            try {
                Class.forName(AIRSHIP_FCM_CLASS);
                isAirshipFcmAvailable = true;
            }
            catch (ClassNotFoundException e) {
                isAirshipFcmAvailable = false;
            }
        }
        return isAirshipFcmAvailable;
    }
}

