/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.model;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.ad4screen.sdk.model.displayformats.Format;
import com.ad4screen.sdk.provider.A4SBeaconResolver;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class Beacon
implements Parcelable,
Comparable<Beacon> {
    public static final int UNKNOWN_BEACON = 0;
    public static final String KEY_NAME = "name";
    public static final String KEY_CUSTOM_PARAMS = "data";
    public static final String KEY_GROUPS = "groups";
    public static final Parcelable.Creator<Beacon> CREATOR = new Parcelable.Creator<Beacon>(){

        public Beacon createFromParcel(Parcel parcel) {
            return new Beacon(parcel);
        }

        public Beacon[] newArray(int n2) {
            return new Beacon[n2];
        }
    };
    private long mRowId = -1L;
    private String mId;
    private String mExternalId = "";
    private boolean mIsNeedToBeRemoved = false;
    private String mName = "";
    private Map<String, String> mCustomParameters = new HashMap<String, String>();
    private String mUuid = "";
    private int mMinor = -1;
    private int mMajor = -1;
    private String mAccuracy = "UNKNOWN";
    private String mTransition = "UNKNOWN";
    private double mDistance = -1.0;
    private Set<String> mGroups = new HashSet<String>();
    private Date mDetectedTime = new Date(0L);
    private Date mNotifiedTime = new Date(0L);

    public Beacon() {
    }

    public Beacon(String string2) {
        this.mId = string2;
    }

    public Beacon(String string2, String string3, int n2, int n3) {
        this.mId = string2;
        this.mUuid = string3;
        this.mMajor = n2;
        this.mMinor = n3;
    }

    public Beacon(int n2, String string2, int n3, int n4) {
        this.mId = Integer.toString(n2);
        this.mUuid = string2;
        this.mMajor = n3;
        this.mMinor = n4;
    }

    public Beacon(Parcel parcel) {
        String string2;
        int n2;
        this.mId = parcel.readString();
        this.mRowId = parcel.readLong();
        this.mExternalId = parcel.readString();
        this.mUuid = parcel.readString();
        this.mMajor = parcel.readInt();
        this.mMinor = parcel.readInt();
        int n3 = parcel.readInt() == 1 ? 1 : 0;
        this.mIsNeedToBeRemoved = n3;
        n3 = parcel.readInt();
        this.mCustomParameters = new HashMap<String, String>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            Parcel parcel2 = parcel;
            string2 = parcel2.readString();
            String string3 = parcel2.readString();
            this.mCustomParameters.put(string2, string3);
        }
        n3 = parcel.readInt();
        this.mGroups = new HashSet<String>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            string2 = parcel.readString();
            this.mGroups.add(string2);
        }
        this.mAccuracy = parcel.readString();
        this.mTransition = parcel.readString();
        this.mDistance = parcel.readDouble();
    }

    public Set<String> getGroups() {
        return this.mGroups;
    }

    public void setGroups(Set<String> set) {
        this.mGroups = set;
    }

    public void parseGroups(JSONObject jSONObject) throws JSONException {
        jSONObject = jSONObject.getJSONArray(KEY_GROUPS);
        for (int i2 = 0; i2 < jSONObject.length(); ++i2) {
            String string2 = jSONObject.getString(i2);
            this.mGroups.add(string2);
        }
    }

    public Date getDetectedTime() {
        return new Date(this.mDetectedTime.getTime());
    }

    public void setDetectedTime(Date date) {
        this.mDetectedTime = new Date(date.getTime());
    }

    public Date getNotifiedTime() {
        return new Date(this.mNotifiedTime.getTime());
    }

    public void setNotifiedTime(Date date) {
        this.mNotifiedTime = new Date(date.getTime());
    }

    public void parseCustomParams(JSONObject jSONObject) throws JSONException {
        jSONObject = jSONObject.getJSONObject(KEY_CUSTOM_PARAMS);
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = jSONObject.getString(string2);
            if (!this.mCustomParameters.containsKey(string2)) {
                this.mCustomParameters.put(string2, string3);
                continue;
            }
            throw new JSONException(string2 + " already exists beacon: " + this.mId);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.mId);
        parcel.writeLong(this.mRowId);
        parcel.writeString(this.mExternalId);
        parcel.writeString(this.mUuid);
        parcel.writeInt(this.mMajor);
        parcel.writeInt(this.mMinor);
        parcel.writeInt(this.mIsNeedToBeRemoved ? 1 : 0);
        parcel.writeInt(this.mCustomParameters.size());
        Iterator<Object> iterator = this.mCustomParameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Parcel parcel2 = parcel;
            Map.Entry<String, String> entry = iterator.next();
            parcel2.writeString(entry.getKey());
            parcel2.writeString(entry.getValue());
        }
        parcel.writeInt(this.mGroups.size());
        iterator = this.mGroups.iterator();
        while (iterator.hasNext()) {
            parcel.writeString((String)iterator.next());
        }
        parcel.writeString(this.mAccuracy);
        parcel.writeString(this.mTransition);
        parcel.writeDouble(this.mDistance);
    }

    public int hashCode() {
        int n2 = 31;
        String string2 = this.mId;
        int n3 = string2 == null ? 0 : string2.hashCode();
        return n2 + n3;
    }

    public boolean equals(Object object) {
        if (beacon2 == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (Beacon.class != object.getClass()) {
            return false;
        }
        Beacon beacon = beacon2;
        Beacon beacon2 = (Beacon)object;
        object = beacon.mId;
        return !(object == null ? beacon2.mId != null : !((String)object).equals(beacon2.mId));
    }

    public String toString() {
        return "Beacon{mRowId=" + this.mRowId + ", mId='" + this.mId + '\'' + ", mExternalId='" + this.mExternalId + '\'' + ", mIsNeedToBeRemoved=" + this.mIsNeedToBeRemoved + ", mName='" + this.mName + '\'' + ", mCustomParameters=" + this.mCustomParameters + ", mUuid='" + this.mUuid + '\'' + ", mMinor=" + this.mMinor + ", mMajor=" + this.mMajor + ", mAccuracy='" + this.mAccuracy + '\'' + ", mTransition='" + this.mTransition + '\'' + ", mDistance=" + this.mDistance + ", mGroups=" + this.mGroups + ", mDetectedTime=" + this.mDetectedTime + ", mNotifiedTime=" + this.mNotifiedTime + '}';
    }

    public long getRowId() {
        return this.mRowId;
    }

    public void setRowId(long l2) {
        this.mRowId = l2;
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String string2) {
        this.mId = string2;
    }

    public String getExternalId() {
        return this.mExternalId;
    }

    public void setExternalId(String string2) {
        this.mExternalId = string2;
    }

    public boolean isNeedToBeRemoved() {
        return this.mIsNeedToBeRemoved;
    }

    public void setNeedToBeRemoved(boolean bl) {
        this.mIsNeedToBeRemoved = bl;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String string2) {
        this.mName = string2;
    }

    public Map<String, String> getCustomParameters() {
        return this.mCustomParameters;
    }

    public void setCustomParameters(Map<String, String> map) {
        this.mCustomParameters = map;
    }

    public String getUuid() {
        return this.mUuid;
    }

    public void setUuid(String string2) {
        this.mUuid = string2;
    }

    public int getMinor() {
        return this.mMinor;
    }

    public void setMinor(int n2) {
        this.mMinor = n2;
    }

    public int getMajor() {
        return this.mMajor;
    }

    public void setMajor(int n2) {
        this.mMajor = n2;
    }

    public String getAccuracy() {
        return this.mAccuracy;
    }

    public void setAccuracy(String string2) {
        this.mAccuracy = string2;
    }

    public String getTransition() {
        return this.mTransition;
    }

    public void setTransition(String string2) {
        this.mTransition = string2;
    }

    public double getDistance() {
        return this.mDistance;
    }

    public void setDistance(double d2) {
        this.mDistance = d2;
    }

    @Override
    public int compareTo(Beacon beacon) {
        if (this.mDistance > beacon.getDistance()) {
            return 1;
        }
        return -1;
    }

    public static class PersonalParamsReplacer
    implements Format.a {
        private A4SBeaconResolver mResolver;
        private Beacon mBeacon;

        public PersonalParamsReplacer(Context context, String string2) {
            PersonalParamsReplacer personalParamsReplacer = this;
            personalParamsReplacer.mResolver = new A4SBeaconResolver(context);
            personalParamsReplacer.mBeacon = personalParamsReplacer.mResolver.getBeaconByClientId(string2);
        }

        @Override
        public void onPersonalParamFound(String string2, StringBuffer stringBuffer) {
            if (Beacon.KEY_NAME.equals(string2)) {
                stringBuffer.append(this.mBeacon.mName);
            } else if (this.mBeacon.mCustomParameters.containsKey(string2)) {
                stringBuffer.append((String)this.mBeacon.mCustomParameters.get(string2));
            }
        }
    }
}

