/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.geofences;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.common.TextUtil;
import com.ad4screen.sdk.common.i;
import com.ad4screen.sdk.plugins.model.Geofence;
import com.ad4screen.sdk.provider.A4SGeofenceResolver;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class GeofenceUtils {
    private static final long GEOFENCE_TRACKING_LIMIT_DELAY_IN_MS = 300000L;
    public static final String TRANSITION_ENTER = "enter";
    public static final String TRANSITION_EXIT = "exit";

    private GeofenceUtils() {
    }

    public static JSONArray parseGeofences(Bundle bundle) throws JSONException {
        if ((bundle = bundle.getBundle("com.ad4screen.sdk.extra.GEOFENCE_PAYLOAD")) != null) {
            JSONArray jSONArray;
            Bundle bundle2 = bundle;
            bundle = jSONArray;
            jSONArray = new JSONArray();
            int n2 = bundle2.getInt("transition");
            String[] stringArray = bundle2.getStringArray("ids");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                JSONObject jSONObject;
                JSONObject jSONObject2;
                if ("LIMIT".equals(stringArray[i2])) continue;
                JSONObject jSONObject3 = jSONObject2 = jSONObject;
                jSONObject3();
                jSONObject3.put("date", (Object)TextUtil.a(i.f().d(), TextUtil.DateType.ISO8601));
                jSONObject.put("id", (Object)stringArray[i2]);
                if (n2 == 1) {
                    jSONObject2.put("transition", (Object)TRANSITION_ENTER);
                } else {
                    jSONObject2.put("transition", (Object)TRANSITION_EXIT);
                }
                JSONObject jSONObject4 = jSONObject2;
                jSONObject4.put("ruuid", (Object)TextUtil.a());
                bundle.put((Object)jSONObject4);
            }
            return bundle;
        }
        return null;
    }

    public static Bundle createFilteredGeofencesForTracking(Context object, Bundle bundle) throws JSONException {
        String[] stringArray;
        Bundle bundle2;
        Bundle bundle3 = bundle;
        bundle = bundle2;
        bundle2 = new Bundle();
        Bundle bundle4 = bundle3.getBundle("com.ad4screen.sdk.extra.GEOFENCE_PAYLOAD");
        if (bundle4 != null && (stringArray = bundle4.getStringArray("ids")) != null && stringArray.length > 0) {
            ArrayList arrayList;
            A4SGeofenceResolver a4SGeofenceResolver;
            Bundle bundle5;
            Bundle bundle6 = bundle4;
            bundle4 = bundle5;
            bundle5 = new Bundle();
            int n2 = bundle6.getInt("transition");
            A4SGeofenceResolver a4SGeofenceResolver2 = a4SGeofenceResolver;
            a4SGeofenceResolver = new A4SGeofenceResolver((Context)object);
            object = arrayList;
            arrayList = new ArrayList();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Geofence geofence;
                String string2 = stringArray[i2];
                if ("LIMIT".equals(string2) || (geofence = a4SGeofenceResolver2.getGeofenceByClientId(string2)) == null) continue;
                String string3 = geofence.getLastTransition();
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    if (n2 == Geofence.GEOFENCE_TRANSITION_ENTER) {
                        if (!TRANSITION_ENTER.equals(string3)) {
                            object.add(string2);
                            continue;
                        }
                    } else if (n2 == Geofence.GEOFENCE_TRANSITION_EXIT && !TRANSITION_EXIT.equals(string3)) {
                        object.add(string2);
                        continue;
                    }
                    if (i.f().d().getTime() - geofence.getNotifiedTime().getTime() < 300000L) {
                        Log.internal("GeofenceUtils|Geofence with id " + string2 + " already tracked less than 5 minutes");
                        continue;
                    }
                    object.add(string2);
                    continue;
                }
                object.add(string2);
            }
            Bundle bundle7 = bundle4;
            Object object2 = object;
            bundle7.putStringArray("ids", object2.toArray(new String[object2.size()]));
            bundle7.putInt("transition", n2);
            bundle.putBundle("com.ad4screen.sdk.extra.GEOFENCE_PAYLOAD", bundle4);
        }
        return bundle;
    }
}

